package ru.bitel.bgbilling.trayinfo;

import java.math.BigDecimal;
import java.sql.Connection;
import java.util.Date;

import bitel.billing.server.contract.bean.BalanceUtils;

import ru.bitel.bgbilling.modules.trayinfo.server.bean.TrayInfoReplyBuilder;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Utils;

/**
 * Какой-то простой формат ответа. 
 * @author dimon
 */
public class SimpleReply
	implements TrayInfoReplyBuilder
{
	private Connection conSlave = null;
	
	@Override
	public void init( Setup setup, Connection conSlave, int mid )
	{
		this.conSlave = conSlave;
	}
	
	@Override
	public String reply( int cid )
	{
		BalanceUtils bu = new BalanceUtils( conSlave );
    	BigDecimal balance = bu.getBalance( new Date(), cid );
    	bu.close();
		return "Договор cid="+cid+" привет! Баланс "+Utils.formatCost( balance )+". Сейчас " + new Date();
	}
}
