/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.kernel.entity.server.bean;

import bitel.billing.server.contract.bean.ContractParameterManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.common.Utils;
import ru.bitel.common.model.IdTitle;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttr;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrMultiList;
import ru.bitel.oss.kernel.entity.server.bean.AbstractEntityAttrDao;
import ru.bitel.oss.kernel.entity.server.bean.EntityAttrDefaultDao;

public class EntityAttrMultiListDao
extends EntityAttrDefaultDao<EntityAttrMultiList> {
    private String itemTable;

    public EntityAttrMultiListDao(Connection con, AbstractEntityAttrDao<?> entityAttrDao, String table, String listValueTable) {
        super(con, entityAttrDao, table);
        this.itemTable = listValueTable;
    }

    @Override
    protected PreparedStatement getSelectPS(int entityId, int entitySpecAttrId) throws SQLException {
        if (this.selectPS == null) {
            this.selectPS = this.con.prepareStatement("SELECT val FROM " + this.table + " WHERE " + this.idName() + "=? AND " + this.typeName() + "=?");
        }
        this.selectPS.setInt(1, entityId);
        this.selectPS.setInt(2, entitySpecAttrId);
        return this.selectPS;
    }

    @Override
    protected PreparedStatement getInsertPS(int entityId, int entitySpecAttrId) throws SQLException {
        if (this.insertPS == null) {
            this.insertPS = this.con.prepareStatement("INSERT INTO " + this.table + " (" + this.idName() + ", " + this.typeName() + ", val) VALUES (?, ?, ?)");
        }
        this.insertPS.setInt(1, entityId);
        this.insertPS.setInt(2, entitySpecAttrId);
        return this.insertPS;
    }

    @Override
    protected PreparedStatement getUpdatePS(int entityId, int entitySpecAttrId) throws SQLException {
        if (this.updatePS == null) {
            this.updatePS = this.con.prepareStatement("UPDATE " + this.table + " SET val=? WHERE " + this.idName() + "=? AND " + this.typeName() + "=? AND (@oldValue:=val) IS NOT NULL");
        }
        this.updatePS.setInt(2, entityId);
        this.updatePS.setInt(3, entitySpecAttrId);
        return this.updatePS;
    }

    @Override
    public EntityAttrMultiList get(int entityId, int attrSpecId) throws SQLException {
        EntityAttrMultiList result = null;
        PreparedStatement ps = this.getSelectPS(entityId, attrSpecId);
        ResultSet rs = ps.executeQuery();
        if (rs.next()) {
            result = new EntityAttrMultiList(entityId, attrSpecId, rs.getString(1), new ArrayList<IdTitle>());
        }
        rs.close();
        if (result != null) {
            ps = this.con.prepareStatement("SELECT val, custom_value FROM " + this.itemTable + " WHERE " + this.idName() + "=? AND " + this.typeName() + "=?");
            ps.setInt(1, entityId);
            ps.setInt(2, attrSpecId);
            rs = ps.executeQuery();
            while (rs.next()) {
                result.getValueList().add(new IdTitle(rs.getInt(1), rs.getString(2)));
            }
            rs.close();
            ps.close();
        }
        return result;
    }

    @Override
    public void insert(int entityId, EntityAttr attr) throws SQLException, BGException {
        EntityAttrMultiList mList = (EntityAttrMultiList)attr;
        this.clean(mList);
        PreparedStatement ps = this.getInsertPS(entityId, mList.getEntitySpecAttrId());
        ps.setString(3, mList.getTitle());
        ps.executeUpdate();
        this.updateListValues(entityId, mList);
    }

    @Override
    protected boolean updateImpl(int entityId, EntityAttrMultiList attr) throws SQLException, BGException {
        boolean result;
        this.clean(attr);
        if (attr.getValueList() == null || attr.getValueList().size() == 0) {
            return this.deleteImpl(entityId, attr.getEntitySpecAttrId());
        }
        PreparedStatement ps = this.getUpdatePS(entityId, attr.getEntitySpecAttrId());
        ps.setString(1, attr.getTitle());
        if (ps.executeUpdate() == 0) {
            ps = this.getInsertPS(entityId, attr.getEntitySpecAttrId());
            ps.setString(3, attr.getTitle());
            ps.executeUpdate();
            result = true;
        } else {
            ps = this.entityAttrDao.getSelectOldValuePS();
            ResultSet rs = ps.executeQuery();
            String oldValue = rs.next() ? rs.getString(1) : null;
            rs.close();
            result = !attr.getTitle().equals(oldValue);
        }
        this.updateListValues(entityId, attr);
        return result;
    }

    private void updateListValues(int entityId, EntityAttrMultiList attr) throws SQLException {
        this.deleteListValues(entityId, attr.getEntitySpecAttrId());
        try (PreparedStatement ps = this.con.prepareStatement("INSERT INTO " + this.itemTable + " SET " + this.idName() + "=?, " + this.typeName() + "=?, val=?, custom_value=?");){
            ps.setInt(1, entityId);
            ps.setInt(2, attr.getEntitySpecAttrId());
            for (IdTitle value : attr.getValueList()) {
                ps.setInt(3, value.getId());
                ps.setString(4, value.getTitle());
                ps.executeUpdate();
            }
        }
    }

    @Override
    protected boolean deleteImpl(int entityId, int entitySpecAttrId) throws SQLException {
        boolean result = super.deleteImpl(entityId, entitySpecAttrId);
        if (result) {
            this.deleteListValues(entityId, entitySpecAttrId);
        }
        return result;
    }

    private void deleteListValues(int entityId, int entitySpecAttrId) throws SQLException {
        try (PreparedStatement ps = this.con.prepareStatement("DELETE FROM " + this.itemTable + " WHERE " + this.idName() + "=? AND " + this.typeName() + "=?");){
            ps.setInt(1, entityId);
            ps.setInt(2, entitySpecAttrId);
            ps.executeUpdate();
        }
    }

    private void clean(EntityAttrMultiList a2) throws BGException, SQLException {
        a2.setTitle("");
        if (a2.getValueList() != null && a2.getValueList().size() > 0) {
            Iterator<IdTitle> iter = a2.getValueList().iterator();
            while (iter.hasNext()) {
                IdTitle el = iter.next();
                if (el != null && (!Utils.isBlankString(el.getTitle()) || el.getId() > 0)) continue;
                iter.remove();
            }
            if (a2.getValueList().size() > 0) {
                ArrayList<String> val = new ArrayList<String>(a2.getValueList().size());
                try (ContractParameterManager manager = new ContractParameterManager(this.con);){
                    for (IdTitle v : a2.getValueList()) {
                        val.add(v.getId() > 0 ? manager.getMultiListTitle(v.getId()) : v.getTitle());
                    }
                }
                Collections.sort(val);
                a2.setTitle(Utils.toString(val, ";"));
            }
        }
    }
}

