/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.kernel.entity.server.bean;

import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import ru.bitel.common.TimeUtils;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttr;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrDate;
import ru.bitel.oss.kernel.entity.server.bean.AbstractEntityAttrDao;
import ru.bitel.oss.kernel.entity.server.bean.EntityAttrDefaultDao;

class EntityAttrDateDao
extends EntityAttrDefaultDao<EntityAttrDate> {
    public EntityAttrDateDao(Connection con, AbstractEntityAttrDao<?> entityAttrDao, String dateTable) {
        super(con, entityAttrDao, dateTable);
    }

    @Override
    public EntityAttrDate get(int entityId, int attrSpecId) throws SQLException {
        PreparedStatement ps = this.getSelectPS(entityId, attrSpecId);
        ResultSet rs = ps.executeQuery();
        EntityAttrDate result = rs.next() ? new EntityAttrDate(entityId, attrSpecId, rs.getDate(1)) : null;
        rs.close();
        return result;
    }

    @Override
    public void insert(int entityId, EntityAttr a2) throws SQLException {
        PreparedStatement ps = this.getInsertPS(entityId, a2.getEntitySpecAttrId());
        ps.setDate(3, TimeUtils.convertDateToSqlDate(((EntityAttrDate)a2).getValue()));
        ps.executeUpdate();
    }

    @Override
    protected boolean updateImpl(int entityId, EntityAttrDate attr) throws SQLException {
        PreparedStatement ps = this.getUpdatePS(entityId, attr.getEntitySpecAttrId());
        ps.setDate(1, TimeUtils.convertDateToSqlDate(attr.getValue()));
        if (ps.executeUpdate() == 0) {
            ps = this.getInsertPS(entityId, attr.getEntitySpecAttrId());
            ps.setDate(3, TimeUtils.convertDateToSqlDate(attr.getValue()));
            ps.executeUpdate();
            return true;
        }
        ps = this.entityAttrDao.getSelectOldValuePS();
        ResultSet rs = ps.executeQuery();
        Date oldValue = rs.next() ? rs.getDate(1) : null;
        rs.close();
        return !TimeUtils.dateEqual(attr.getValue(), oldValue);
    }

    @Override
    protected void insertHistory(int cid, EntityAttrDate attr) throws SQLException {
        PreparedStatement ps = this.getInsertHistiryPS();
        ps.setInt(1, cid);
        ps.setInt(2, attr.getEntitySpecAttrId());
        ps.setDate(3, TimeUtils.convertDateToSqlDate(attr.getValue()));
        ps.setTimestamp(4, new Timestamp(System.currentTimeMillis()));
        ps.setInt(5, this.entityAttrDao.userId);
        ps.executeUpdate();
    }
}

