/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.kernel.entity.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttr;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrContract;
import ru.bitel.oss.kernel.entity.server.bean.AbstractEntityAttrDao;
import ru.bitel.oss.kernel.entity.server.bean.EntityAttrDefaultDao;

class EntityAttrContractDao
extends EntityAttrDefaultDao<EntityAttrContract> {
    private String listValueTable = "contract";

    public EntityAttrContractDao(Connection con, AbstractEntityAttrDao<?> entityAttrDao, String listTable) {
        super(con, entityAttrDao, listTable);
    }

    @Override
    protected PreparedStatement getSelectPS(int entityId, int entitySpecAttrId) throws SQLException {
        if (this.selectPS == null) {
            this.selectPS = this.con.prepareStatement("SELECT v." + this.valueName() + ", t.title FROM " + this.table + " as v LEFT JOIN " + this.listValueTable + " as t ON t.id=v." + this.valueName() + " WHERE v." + this.idName() + "=? AND v." + this.typeName() + "=?");
        }
        this.selectPS.setInt(1, entityId);
        this.selectPS.setInt(2, entitySpecAttrId);
        return this.selectPS;
    }

    @Override
    public EntityAttrContract get(int entityId, int attrSpecId) throws SQLException {
        PreparedStatement ps = this.getSelectPS(entityId, attrSpecId);
        ResultSet rs = ps.executeQuery();
        EntityAttrContract result = rs.next() ? new EntityAttrContract(entityId, attrSpecId, rs.getInt(1), rs.getString(2)) : null;
        rs.close();
        return result;
    }

    @Override
    public void insert(int entityId, EntityAttr a2) throws SQLException {
        PreparedStatement ps = this.getInsertPS(entityId, a2.getEntitySpecAttrId());
        ps.setInt(3, ((EntityAttrContract)a2).getValue());
        ps.executeUpdate();
    }

    @Override
    public boolean updateImpl(int entityId, EntityAttrContract attr) throws SQLException {
        PreparedStatement ps = this.getUpdatePS(entityId, attr.getEntitySpecAttrId());
        ps.setInt(1, attr.getValue());
        if (ps.executeUpdate() == 0) {
            ps = this.getInsertPS(entityId, attr.getEntitySpecAttrId());
            ps.setInt(3, attr.getValue());
            ps.executeUpdate();
            return true;
        }
        ps = this.entityAttrDao.getSelectOldValuePS();
        ResultSet rs = ps.executeQuery();
        int oldValue = rs.next() ? rs.getInt(1) : 0;
        rs.close();
        return attr.getValue() != oldValue;
    }

    @Override
    protected void insertHistory(int cid, EntityAttrContract attr) throws SQLException {
        if (this.insertHistoryPS == null) {
            this.insertHistoryPS = this.con.prepareStatement("INSERT INTO " + this.table + "_log SET  " + this.idName() + "=?, " + this.typeName() + "=?, val=?, title=?, dt_change=?, user_id=?");
        }
        this.insertHistoryPS.setInt(1, cid);
        this.insertHistoryPS.setInt(2, attr.getEntitySpecAttrId());
        this.insertHistoryPS.setInt(3, attr != null ? Integer.valueOf(attr.getValue()) : null);
        this.insertHistoryPS.setString(4, attr != null ? attr.toString() : null);
        this.insertHistoryPS.setTimestamp(5, new Timestamp(System.currentTimeMillis()));
        this.insertHistoryPS.setInt(6, this.entityAttrDao.userId);
        this.insertHistoryPS.executeUpdate();
    }
}

