/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.kernel.directories.domain.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Set;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TreeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.dao.AbstractIdDao;
import ru.bitel.oss.kernel.directories.domain.common.bean.Domain;

public class DomainDao
extends AbstractIdDao<Domain>
implements Directory<Domain> {
    public DomainDao(Connection con) {
        super(con, 0, "domain");
    }

    @Override
    protected Domain getFromRS(ResultSet rs) throws SQLException, BGException {
        Domain result = new Domain();
        result.setId(rs.getInt("id"));
        result.setParentId(rs.getInt("parentId"));
        result.setTitle(rs.getString("title"));
        result.setComment(rs.getString("comment"));
        return result;
    }

    @Override
    protected void updateImpl(Domain b2) throws BGException, SQLException {
        PreparedStatement ps;
        if (Utils.isBlankString(b2.getTitle())) {
            throw new BGIllegalArgumentException();
        }
        if (b2.getId() <= 0) {
            ps = this.con.prepareStatement("INSERT INTO " + this.tableName + " (parentId, title, comment) VALUES (?,?,?)", 1);
        } else {
            ps = this.con.prepareStatement("UPDATE " + this.tableName + " SET parentId=?, title=?, comment=? WHERE id=?");
            ps.setInt(4, b2.getId());
        }
        ps.setInt(1, b2.getParentId());
        ps.setString(2, b2.getTitle());
        ps.setString(3, b2.getComment());
        ps.executeUpdate();
        if (b2.getId() <= 0) {
            b2.setId(ServerUtils.lastInsertId(ps));
        }
        ps.close();
    }

    @Override
    public Domain get(String title) throws BGException {
        return (Domain)this.get("title=?", title);
    }

    @Override
    public List<Domain> list() throws BGException {
        return this.list(null, "title", new Object[0]);
    }

    public Domain tree() throws BGException {
        Domain root = new Domain();
        List list = this.list(null, "title", new Object[0]);
        return TreeUtils.tree(list, root);
    }

    public void move(int newParentId, Set<Integer> children) throws BGException {
        if (newParentId < 0 || children == null || children.size() == 0) {
            throw new BGIllegalArgumentException();
        }
        Domain root = this.tree();
        for (Integer id : children) {
            Domain child = this.find(root, id);
            if (this.find(child, newParentId) == null) continue;
            throw new BGMessageException("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043f\u0435\u0440\u0435\u043c\u0435\u0441\u0442\u0438\u0442\u044c \u0434\u043e\u043c\u0435\u043d \u0432 \u0434\u043e\u0447\u0435\u0440\u043d\u0438\u0439 \u0434\u043e\u043c\u0435\u043d.");
        }
        try {
            PreparedStatement ps = this.con.prepareStatement("UPDATE " + this.tableName + " SET parentId=? WHERE id IN (" + Utils.toString(children) + ")");
            ps.setInt(1, newParentId);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException(e);
        }
    }

    private Domain find(Domain option, int id) {
        if (option.getId() == id) {
            return option;
        }
        if (option.getChildren() != null) {
            for (Domain child : option.getChildren()) {
                Domain result = this.find(child, id);
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    @Override
    public int delete(int id) throws BGException {
        List list = this.list("parentId=?", null, id);
        if (list != null && list.size() > 0) {
            throw new BGMessageException("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u0434\u043e\u043c\u0435\u043d, \u0441\u043e\u0434\u0435\u0440\u0436\u0430\u0449\u0438\u0439 \u0434\u043e\u0447\u0435\u0440\u043d\u0438\u0435 \u0434\u043e\u043c\u0435\u043d\u044b.");
        }
        try {
            PreparedStatement ps = this.con.prepareStatement("SELECT id FROM contract WHERE domainId=? LIMIT 1");
            ps.setInt(1, id);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                ps.close();
                throw new BGMessageException("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u0434\u043e\u043c\u0435\u043d, \u043a \u043a\u043e\u0442\u043e\u0440\u043e\u043c\u0443 \u043f\u0440\u0438\u0432\u044f\u0437\u0430\u043d\u044b \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u044b.");
            }
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException(e);
        }
        return super.delete(id);
    }
}

