/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.server.multipart;

import java.io.IOException;
import java.util.ArrayList;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import ru.bitel.common.server.multipart.BufferedServletInputStream;
import ru.bitel.common.server.multipart.FilePart;
import ru.bitel.common.server.multipart.LimitedServletInputStream;
import ru.bitel.common.server.multipart.ParamPart;
import ru.bitel.common.server.multipart.Part;

public class MultipartParser {
    private final HttpServletRequest request;
    private final ServletInputStream servletInputStream;
    private String boundary;
    private FilePart lastFilePart;
    private byte[] buf;

    public MultipartParser(HttpServletRequest request, int maxSize) throws IOException {
        this(request, maxSize, true, true);
    }

    public MultipartParser(HttpServletRequest request, int maxSize, boolean buffer, boolean limitLength) throws IOException {
        this.request = request;
        this.buf = new byte[8192];
        String type = null;
        String type1 = request.getHeader("Content-Type");
        String type2 = request.getContentType();
        if (type1 == null && type2 != null) {
            type = type2;
        } else if (type2 == null && type1 != null) {
            type = type1;
        } else if (type1 != null && type2 != null) {
            String string = type = type1.length() <= type2.length() ? type2 : type1;
        }
        if (type == null || !type.toLowerCase().startsWith("multipart/form-data")) {
            throw new IOException("Posted content type isn't multipart/form-data");
        }
        int length = request.getContentLength();
        if (length > maxSize) {
            throw new IOException("Posted content length of " + length + " exceeds limit of " + maxSize);
        }
        String boundary = this.extractBoundary(type);
        if (boundary == null) {
            throw new IOException("Separation boundary was not specified");
        }
        ServletInputStream servletInputStream = request.getInputStream();
        if (buffer) {
            servletInputStream = new BufferedServletInputStream(servletInputStream);
        }
        if (limitLength) {
            servletInputStream = new LimitedServletInputStream(servletInputStream, length);
        }
        this.servletInputStream = servletInputStream;
        this.boundary = boundary;
        String line = this.readLine();
        if (line == null) {
            throw new IOException("Corrupt form data: premature ending");
        }
        if (!line.startsWith(boundary)) {
            throw new IOException("Corrupt form data: no leading boundary: " + line + " != " + boundary);
        }
    }

    private String extractBoundary(String line) {
        int index = line.lastIndexOf("boundary=");
        if (index == -1) {
            return null;
        }
        String boundary = line.substring(index + 9);
        if (boundary.charAt(0) == '\"') {
            index = boundary.lastIndexOf(34);
            boundary = boundary.substring(1, index);
        }
        boundary = "--" + boundary;
        return boundary;
    }

    private String extractContentType(String line) throws IOException {
        String contentType = null;
        String origline = line;
        if ((line = origline.toLowerCase()).startsWith("content-type")) {
            int start = line.indexOf(" ");
            if (start == -1) {
                throw new IOException("Content type corrupt: " + origline);
            }
            contentType = line.substring(start + 1);
        } else if (line.length() != 0) {
            throw new IOException("Malformed line after disposition: " + origline);
        }
        return contentType;
    }

    private String[] extractDispositionInfo(String line) throws IOException {
        String[] retval = new String[4];
        String origline = line;
        line = origline.toLowerCase();
        int start = line.indexOf("content-disposition: ");
        int end = line.indexOf(";");
        if (start == -1 || end == -1) {
            throw new IOException("Content disposition corrupt: " + origline);
        }
        String disposition = line.substring(start + 21, end);
        if (!disposition.equals("form-data")) {
            throw new IOException("Invalid content disposition: " + disposition);
        }
        start = line.indexOf("name=\"", end);
        end = line.indexOf("\"", start + 7);
        if (start == -1 || end == -1) {
            throw new IOException("Content disposition corrupt: " + origline);
        }
        String name = origline.substring(start + 6, end);
        String filename = null;
        String origname = null;
        start = line.indexOf("filename=\"", end + 2);
        end = line.indexOf("\"", start + 10);
        if (start != -1 && end != -1) {
            origname = filename = origline.substring(start + 10, end);
            int slash = Math.max(filename.lastIndexOf(47), filename.lastIndexOf(92));
            if (slash > -1) {
                filename = filename.substring(slash + 1);
            }
        }
        retval[0] = disposition;
        retval[1] = name;
        retval[2] = filename;
        retval[3] = origname;
        return retval;
    }

    private String readLine() throws IOException {
        int result;
        String encoding = this.request.getCharacterEncoding();
        StringBuffer sbuf = new StringBuffer();
        do {
            if ((result = this.servletInputStream.readLine(this.buf, 0, this.buf.length)) == -1) continue;
            sbuf.append(new String(this.buf, 0, result, encoding));
        } while (result == this.buf.length);
        if (sbuf.length() == 0) {
            return null;
        }
        int len = sbuf.length();
        if (sbuf.charAt(len - 2) == '\r') {
            sbuf.setLength(len - 2);
        } else {
            sbuf.setLength(len - 1);
        }
        return sbuf.toString();
    }

    public Part readNextPart() throws IOException {
        if (this.lastFilePart != null) {
            this.lastFilePart.getInputStream().close();
            this.lastFilePart = null;
        }
        ArrayList<String> headers = new ArrayList<String>();
        String line = this.readLine();
        if (line == null) {
            return null;
        }
        if (line.length() == 0) {
            return null;
        }
        headers.add(line);
        while ((line = this.readLine()) != null && line.length() > 0) {
            headers.add(line);
        }
        if (line == null) {
            return null;
        }
        String name = null;
        String filename = null;
        String origname = null;
        String contentType = "text/plain";
        for (String headerline : headers) {
            String type;
            if (headerline.toLowerCase().startsWith("content-disposition:")) {
                String[] dispInfo = this.extractDispositionInfo(headerline);
                name = dispInfo[1];
                filename = dispInfo[2];
                origname = dispInfo[3];
                continue;
            }
            if (!headerline.toLowerCase().startsWith("content-type:") || (type = this.extractContentType(headerline)) == null) continue;
            contentType = type;
        }
        if (filename == null) {
            return new ParamPart(name, this.servletInputStream, this.boundary);
        }
        if (filename.equals("")) {
            filename = null;
        }
        this.lastFilePart = new FilePart(name, this.servletInputStream, this.boundary, contentType, filename, origname);
        return this.lastFilePart;
    }
}

