/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.logging;

import java.io.IOException;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Locale;
import org.apache.log4j.Logger;
import org.apache.log4j.helpers.NullEnumeration;
import ru.bitel.common.logging.Log4j;

public abstract class LoggingPrintStream
extends PrintStream {
    protected static Logger _logger;
    protected Logger logger = _logger;
    private final PrintStream printStream;

    public LoggingPrintStream(PrintStream printStream) {
        super(printStream);
        this.printStream = printStream;
    }

    protected abstract void log(String var1);

    @Override
    public void print(String s) {
        this.log(s);
    }

    @Override
    public void println(String s) {
        this.log(s);
    }

    @Override
    public boolean checkError() {
        return this.printStream.checkError();
    }

    @Override
    public void close() {
        this.printStream.close();
    }

    public boolean equals(Object obj) {
        return this.printStream.equals(obj);
    }

    @Override
    public void flush() {
        this.printStream.flush();
    }

    @Override
    public PrintStream format(Locale l, String format, Object ... args) {
        return this.printStream.format(l, format, args);
    }

    @Override
    public PrintStream format(String format, Object ... args) {
        return this.printStream.format(format, args);
    }

    public int hashCode() {
        return this.printStream.hashCode();
    }

    @Override
    public void print(boolean b2) {
        this.printStream.print(b2);
    }

    @Override
    public void print(char c) {
        this.printStream.print(c);
    }

    @Override
    public void print(char[] s) {
        this.printStream.print(s);
    }

    @Override
    public void print(double d) {
        this.printStream.print(d);
    }

    @Override
    public void print(float f) {
        this.printStream.print(f);
    }

    @Override
    public void print(int i) {
        this.printStream.print(i);
    }

    @Override
    public void print(long l) {
        this.printStream.print(l);
    }

    @Override
    public void print(Object obj) {
        this.log(String.valueOf(obj));
    }

    @Override
    public PrintStream printf(Locale l, String format, Object ... args) {
        return this.printStream.printf(l, format, args);
    }

    @Override
    public PrintStream printf(String format, Object ... args) {
        return this.printStream.printf(format, args);
    }

    @Override
    public void println() {
        this.log("");
    }

    @Override
    public void println(boolean x) {
        this.log(String.valueOf(x));
    }

    @Override
    public void println(char x) {
        this.log(String.valueOf(x));
    }

    @Override
    public void println(char[] x) {
        this.printStream.println(x);
    }

    @Override
    public void println(double x) {
        this.log(String.valueOf(x));
    }

    @Override
    public void println(float x) {
        this.log(String.valueOf(x));
    }

    @Override
    public void println(int x) {
        this.log(String.valueOf(x));
    }

    @Override
    public void println(long x) {
        this.log(String.valueOf(x));
    }

    @Override
    public void println(Object x) {
        this.log(String.valueOf(x));
    }

    public String toString() {
        return this.printStream.toString();
    }

    @Override
    public void write(byte[] buf, int off, int len) {
        this.printStream.write(buf, off, len);
    }

    @Override
    public void write(byte[] b2) throws IOException {
        this.printStream.write(b2);
    }

    @Override
    public void write(int b2) {
        this.printStream.write(b2);
    }

    public static void assignToOutput() {
        Logger rootLogger = Logger.getRootLogger();
        Enumeration appenders = rootLogger.getAllAppenders();
        if (appenders != null && !(appenders instanceof NullEnumeration)) {
            if (!(System.out instanceof LoggingPrintStream)) {
                System.setOut(new LoggingPrintStream(System.out){

                    @Override
                    protected synchronized void log(String x) {
                        try {
                            this.logger.info((Object)x);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                });
            }
            if (!(System.err instanceof LoggingPrintStream)) {
                System.setErr(new LoggingPrintStream(System.err){

                    @Override
                    protected synchronized void log(String x) {
                        try {
                            this.logger.error((Object)x);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                });
            }
        }
    }

    static {
        Log4j.init();
        _logger = Logger.getLogger(LoggingPrintStream.class);
    }
}

