/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.logging;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Appender;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Category;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.log4j.helpers.AppenderAttachableImpl;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.spi.AppenderAttachable;
import org.apache.log4j.spi.LoggingEvent;
import ru.bitel.common.logging.NestedContext;

public class Log4jAsyncAppender2
extends AppenderSkeleton
implements AppenderAttachable {
    public static final int DEFAULT_BUFFER_SIZE = 2048;
    private final Map<String, DiscardSummary> discardMap = new HashMap<String, DiscardSummary>();
    private int bufferSize = 2048;
    private LinkedBlockingQueue<LoggingEvent> queue = new LinkedBlockingQueue(this.bufferSize);
    ArrayBlockingQueue<LoggingEvent> s;
    AppenderAttachableImpl aai = this.appenders = new AppenderAttachableImpl();
    private final AppenderAttachableImpl appenders;
    private final Thread dispatcher = new Thread(new Dispatcher(this, this.queue, this.discardMap, this.appenders));
    private boolean locationInfo = false;
    private boolean blocking = true;

    public Log4jAsyncAppender2() {
        this.dispatcher.setDaemon(true);
        this.dispatcher.setName("Dispatcher-" + this.dispatcher.getName());
        this.dispatcher.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAppender(Appender newAppender) {
        AppenderAttachableImpl appenderAttachableImpl = this.appenders;
        synchronized (appenderAttachableImpl) {
            this.appenders.addAppender(newAppender);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void append(LoggingEvent event) {
        if (this.dispatcher == null || !this.dispatcher.isAlive() || this.bufferSize <= 0) {
            AppenderAttachableImpl appenderAttachableImpl = this.appenders;
            synchronized (appenderAttachableImpl) {
                this.appenders.appendLoopOnAppenders(event);
            }
            return;
        }
        event.getNDC();
        event.getThreadName();
        event.getMDCCopy();
        String nestedContext = NestedContext.get();
        if (nestedContext != null) {
            event.setProperty("nestedContext", NestedContext.get());
        }
        if (this.locationInfo) {
            event.getLocationInformation();
        }
        try {
            if (this.blocking ? !Thread.interrupted() && Thread.currentThread() != this.dispatcher && this.queue.offer(event, 30L, TimeUnit.MILLISECONDS) : this.queue.offer(event, 10L, TimeUnit.MILLISECONDS)) {
                return;
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        Map<String, DiscardSummary> map = this.discardMap;
        synchronized (map) {
            String loggerName = event.getLoggerName();
            DiscardSummary summary = this.discardMap.get(loggerName);
            if (summary == null) {
                summary = new DiscardSummary(event);
                this.discardMap.put(loggerName, summary);
            } else {
                summary.add(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Log4jAsyncAppender2 log4jAsyncAppender2 = this;
        synchronized (log4jAsyncAppender2) {
            this.closed = true;
        }
        try {
            this.dispatcher.join();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LogLog.error((String)"Got an InterruptedException while waiting for the dispatcher to finish.", (Throwable)e);
        }
        log4jAsyncAppender2 = this.appenders;
        synchronized (log4jAsyncAppender2) {
            Enumeration iter = this.appenders.getAllAppenders();
            if (iter != null) {
                while (iter.hasMoreElements()) {
                    Object next = iter.nextElement();
                    if (!(next instanceof Appender)) continue;
                    ((Appender)next).close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration<?> getAllAppenders() {
        AppenderAttachableImpl appenderAttachableImpl = this.appenders;
        synchronized (appenderAttachableImpl) {
            return this.appenders.getAllAppenders();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Appender getAppender(String name) {
        AppenderAttachableImpl appenderAttachableImpl = this.appenders;
        synchronized (appenderAttachableImpl) {
            return this.appenders.getAppender(name);
        }
    }

    public boolean getLocationInfo() {
        return this.locationInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAttached(Appender appender) {
        AppenderAttachableImpl appenderAttachableImpl = this.appenders;
        synchronized (appenderAttachableImpl) {
            return this.appenders.isAttached(appender);
        }
    }

    public boolean requiresLayout() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllAppenders() {
        AppenderAttachableImpl appenderAttachableImpl = this.appenders;
        synchronized (appenderAttachableImpl) {
            this.appenders.removeAllAppenders();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAppender(Appender appender) {
        AppenderAttachableImpl appenderAttachableImpl = this.appenders;
        synchronized (appenderAttachableImpl) {
            this.appenders.removeAppender(appender);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAppender(String name) {
        AppenderAttachableImpl appenderAttachableImpl = this.appenders;
        synchronized (appenderAttachableImpl) {
            this.appenders.removeAppender(name);
        }
    }

    public void setLocationInfo(boolean flag) {
        this.locationInfo = flag;
    }

    public void setBlocking(boolean value) {
        this.blocking = value;
    }

    public boolean getBlocking() {
        return this.blocking;
    }

    private static class Dispatcher
    implements Runnable {
        private final Log4jAsyncAppender2 parent;
        private final LinkedBlockingQueue<LoggingEvent> queue;
        private final Map<String, DiscardSummary> discardMap;
        private final AppenderAttachableImpl appenders;

        public Dispatcher(Log4jAsyncAppender2 parent, LinkedBlockingQueue<LoggingEvent> queue, Map<String, DiscardSummary> discardMap, AppenderAttachableImpl appenders) {
            this.parent = parent;
            this.queue = queue;
            this.appenders = appenders;
            this.discardMap = discardMap;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean isActive = true;
            try {
                ArrayList<LoggingEvent> events = new ArrayList<LoggingEvent>(this.parent.bufferSize + 128);
                ArrayList<DiscardSummary> list = new ArrayList<DiscardSummary>();
                while (isActive) {
                    Object e;
                    try {
                        e = this.queue.poll(1000L, TimeUnit.MILLISECONDS);
                        if (e != null) {
                            events.add((LoggingEvent)e);
                            this.queue.drainTo(events);
                        }
                        int size = events.size();
                        for (int i = 0; i < size; ++i) {
                            AppenderAttachableImpl appenderAttachableImpl = this.appenders;
                            synchronized (appenderAttachableImpl) {
                                this.appenders.appendLoopOnAppenders((LoggingEvent)events.get(i));
                                continue;
                            }
                        }
                    }
                    finally {
                        events.clear();
                    }
                    try {
                        e = this.discardMap;
                        synchronized (e) {
                            list.addAll(this.discardMap.values());
                            this.discardMap.clear();
                        }
                        isActive = !this.parent.closed;
                        for (int i = 0; i < list.size(); ++i) {
                            AppenderAttachableImpl appenderAttachableImpl = this.appenders;
                            synchronized (appenderAttachableImpl) {
                                this.appenders.appendLoopOnAppenders(((DiscardSummary)list.get(i)).createEvent());
                                continue;
                            }
                        }
                    }
                    finally {
                        list.clear();
                    }
                }
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private static final class DiscardSummary {
        private LoggingEvent maxEvent;
        private int count;

        public DiscardSummary(LoggingEvent event) {
            this.maxEvent = event;
            this.count = 1;
        }

        public void add(LoggingEvent event) {
            if (event.getLevel().toInt() > this.maxEvent.getLevel().toInt()) {
                this.maxEvent = event;
            }
            ++this.count;
        }

        public LoggingEvent createEvent() {
            String msg = MessageFormat.format("Discarded {0} messages due to full event buffer including: {1}", new Integer(this.count), this.maxEvent.getMessage());
            return new LoggingEvent("org.apache.log4j.AsyncAppender.DONT_REPORT_LOCATION", (Category)Logger.getLogger((String)this.maxEvent.getLoggerName()), (Priority)this.maxEvent.getLevel(), (Object)msg, null);
        }
    }
}

