/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.logging;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Writer;
import java.util.zip.GZIPOutputStream;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.helpers.CountingQuietWriter;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.helpers.OptionConverter;
import org.apache.log4j.spi.LoggingEvent;

public class CompressingRollingFileAppender
extends FileAppender {
    protected long maxFileSize = 0xA00000L;
    protected int maxBackupIndex = 1;

    public int getMaxBackupIndex() {
        return this.maxBackupIndex;
    }

    public long getMaximumFileSize() {
        return this.maxFileSize;
    }

    public void setMaxBackupIndex(int maxBackups) {
        this.maxBackupIndex = maxBackups;
    }

    public void setMaxFileSize(String maxFileSize) {
        this.maxFileSize = OptionConverter.toFileSize((String)maxFileSize, (long)(this.maxFileSize + 1L));
    }

    public CompressingRollingFileAppender() {
    }

    public CompressingRollingFileAppender(Layout layout, String filename, boolean append) throws IOException {
        super(layout, filename, append);
    }

    public void activateOptions() {
        super.activateOptions();
        this.setAppend(false);
    }

    public void setAppend(boolean flag) {
        LogLog.warn((String)"Compression rolling appender doesn't support append option(always set to false)");
    }

    protected void rollOver() {
        if (this.maxBackupIndex > 0) {
            File zipFile;
            File currentFile = new File(this.fileName + '.' + this.maxBackupIndex + ".gz");
            if (currentFile.exists()) {
                currentFile.delete();
            }
            for (int i = this.maxBackupIndex - 1; i >= 1; --i) {
                currentFile = new File(this.fileName + "." + i + ".gz");
                if (!currentFile.exists()) continue;
                zipFile = new File(this.fileName + '.' + (i + 1) + ".gz");
                LogLog.debug((String)("Renaming file " + currentFile + " to " + zipFile));
                this.renameWithGzip(currentFile, zipFile);
            }
            zipFile = new File(this.fileName + ".1.gz");
            this.closeFile();
            currentFile = new File(this.fileName);
            LogLog.debug((String)("Renaming file " + currentFile + " to " + zipFile));
            this.renameWithGzip(currentFile, zipFile);
        }
        try {
            this.setFile(this.fileName, false, this.bufferedIO, this.bufferSize);
        }
        catch (IOException e) {
            LogLog.error((String)("setFile(" + this.fileName + ", false) call failed."), (Throwable)e);
        }
    }

    protected void setQWForFiles(Writer writer) {
        this.qw = new CountingQuietWriter(writer, this.errorHandler);
    }

    protected void subAppend(LoggingEvent event) {
        super.subAppend(event);
        if (this.fileName != null && ((CountingQuietWriter)this.qw).getCount() >= this.maxFileSize) {
            this.rollOver();
        }
    }

    private void renameWithGzip(File from, File to) {
        try {
            FileInputStream stream = new FileInputStream(from);
            byte[] content = new byte[stream.available()];
            stream.read(content);
            GZIPOutputStream gzipOutputStream = new GZIPOutputStream(new FileOutputStream(to));
            gzipOutputStream.write(content, 0, content.length);
            gzipOutputStream.finish();
            gzipOutputStream.flush();
            gzipOutputStream.close();
            from.delete();
        }
        catch (IOException e) {
            LogLog.error((String)("Error compress log file [" + from + "] to zip file [" + to + "]"), (Throwable)e);
        }
    }
}

