/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.localize;

import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.log4j.Logger;
import ru.bitel.common.Preferences;

public class Localizer {
    private static final Logger log = Logger.getLogger(Localizer.class);
    private static char decimalformatsymbolsDecimalseparator = (char)46;

    public static void initLocales(Preferences config) {
        log.info((Object)"Init locales");
        try {
            char defaultDecimalformatsymbolsDecimalseparator;
            String defaultlocale;
            String defaulttz = config.get("locale.default.tz", null);
            if (defaulttz != null) {
                log.info((Object)("overwrite tz: " + defaulttz));
                TimeZone.setDefault(TimeZone.getTimeZone(defaulttz));
            }
            if ((defaultlocale = config.get("locale.default.locale", null)) != null) {
                log.info((Object)("overwrite locale: " + defaultlocale));
                Locale.setDefault(new Locale(defaultlocale));
            }
            if ((defaultDecimalformatsymbolsDecimalseparator = config.getChar("locale.default.decimalformatsymbols.decimalseparator", '\u0000')) != '\u0000') {
                log.info((Object)("overwrite decimalformatsymbols.decimalseparator: " + defaultDecimalformatsymbolsDecimalseparator));
                decimalformatsymbolsDecimalseparator = defaultDecimalformatsymbolsDecimalseparator;
            }
        }
        catch (Exception ex) {
            log.error((Object)"error init locales", (Throwable)ex);
        }
    }

    public static DecimalFormatSymbols getDecimalFormatSymbols() {
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        dfs.setDecimalSeparator(decimalformatsymbolsDecimalseparator);
        return dfs;
    }
}

