/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.server.util;

import java.sql.Connection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import ru.bitel.bgbilling.kernel.module.common.bean.User;
import ru.bitel.bgbilling.kernel.module.server.bean.UserManager;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;

public class UserMap {
    private Map<Integer, User> map = new HashMap<Integer, User>();
    private static UserMap userMap = null;

    private UserMap() {
    }

    public static void initUserMap(Setup setup) {
        if (userMap == null) {
            userMap = new UserMap();
        }
        Connection con = setup.getDBConnectionFromPool();
        try {
            UserMap.initUserMap(con);
        }
        finally {
            ServerUtils.closeConnection(con);
        }
    }

    public static void initUserMap(Connection con) {
        if (userMap == null) {
            userMap = new UserMap();
        }
        try (UserManager userManager = new UserManager(con);){
            UserMap.userMap.map = userManager.getUsersMap();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static User getUser(Integer id) {
        User result = null;
        if (userMap != null && (result = UserMap.userMap.map.get(id)) == null) {
            result = new User();
            if (id != null) {
                result.setId(id);
            }
            result.setName("??? (" + id + ")");
            result.setTitle("???");
        }
        return result;
    }

    public static Map<Integer, User> getMap() {
        return userMap != null ? Collections.unmodifiableMap(UserMap.userMap.map) : Collections.emptyMap();
    }

    public static Map<Integer, String> getNameMap() {
        HashMap<Integer, String> nameMap = new HashMap<Integer, String>();
        if (userMap != null) {
            for (Map.Entry<Integer, User> entry : UserMap.userMap.map.entrySet()) {
                nameMap.put(entry.getKey(), entry.getValue().getName());
            }
        }
        return nameMap;
    }
}

