/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.server.util;

import bitel.billing.server.util.Config;
import java.awt.event.ActionEvent;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;
import ru.bitel.bgbilling.kernel.container.web.action.XSLManager;
import ru.bitel.bgbilling.kernel.container.ws.common.Distribution;
import ru.bitel.bgbilling.kernel.container.ws.server.WSClient;
import ru.bitel.bgbilling.kernel.event.EventListener;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.events.system.ModuleConfigModifiedEvent;
import ru.bitel.bgbilling.server.util.DefaultServerSetup;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;

public class Setup
extends DefaultServerSetup {
    private static final Logger log = Logger.getLogger(Setup.class);
    private final ConcurrentHashMap<Integer, Map<Class<?>, Config>> configMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<Integer, ModuleSetup> moduleSetupMap = new ConcurrentHashMap();
    private final Distribution distribution;
    private final WSClient wsClient;
    private Date initDate = new Date();
    private final Preferences bundlePreferences = new Preferences(new HashMap<String, String>(this.data));
    private static final Class<?>[] getConfigClasses = new Class[]{Integer.TYPE, ParameterMap.class, Setup.class};
    protected static Setup instance;

    public Setup(String bundleName) {
        super(bundleName);
        this.initLocales();
        this.initJNDI();
        this.initMQ();
        this.init();
        this.distribution = new Distribution(this);
        this.wsClient = new WSClient(this);
        this.addReloadListener();
    }

    public Preferences getBundlePreferences() {
        return this.bundlePreferences;
    }

    public Date getInitDate() {
        return this.initDate;
    }

    private void addReloadListener() {
        try {
            EventProcessor.getInstance().addListener(new EventListener<ModuleConfigModifiedEvent>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void notify(ModuleConfigModifiedEvent e, EventListenerContext ctx) {
                    log.info((Object)("Reload config, mid = " + e.getModuleId()));
                    Connection con = Setup.this.getDBConnectionFromPool();
                    try {
                        Setup.this.reloadConfig(con, e.getModuleId());
                    }
                    catch (Exception ex) {
                        log.error((Object)ex.getMessage(), (Throwable)ex);
                    }
                    finally {
                        ServerUtils.closeConnection(con);
                    }
                }
            }, ModuleConfigModifiedEvent.class);
        }
        catch (Throwable e) {
            log.error((Object)e.getMessage(), e);
        }
    }

    public Distribution getDistribution() {
        return this.distribution;
    }

    public WSClient getWSClient() {
        return this.wsClient;
    }

    private void init() {
        if (this.initConnectionPool()) {
            Connection con = this.getDBConnectionFromPool();
            this.loadModuleSetup(con, 0, this.data);
            ServerUtils.closeConnection(con);
            this.initTrashPoolsAndCreateTableOptions();
        }
    }

    public final <K extends Config> K getConfig(int mid, Class<K> clazz) {
        Config result;
        Map<Class<?>, Config> map = this.configMap.get(mid);
        if (map == null) {
            map = new ConcurrentHashMap(8);
            this.configMap.put(mid, map);
        }
        if ((result = map.get(clazz)) == null) {
            try {
                Constructor<K> constr = clazz.getConstructor(getConfigClasses);
                if ((clazz.getModifiers() & 1) == 0) {
                    constr.setAccessible(true);
                }
                result = (Config)constr.newInstance(mid, this.getModuleSetup(mid), this);
                map.put(clazz, result);
            }
            catch (InvocationTargetException e) {
                System.err.println("InvocationTargetException caused by:");
                e.getCause().printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return (K)result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModuleSetup getModuleSetup(Integer moduleId) {
        if (moduleId > 0) {
            ModuleSetup moduleSetup = this.moduleSetupMap.get(moduleId);
            if (moduleSetup == null) {
                log.info((Object)("Load config for mid=" + moduleId));
                Connection con = this.getDBConnectionFromPool();
                try {
                    moduleSetup = new ModuleSetup(con, moduleId);
                    this.moduleSetupMap.put(moduleId, moduleSetup);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    ServerUtils.closeConnection(con);
                }
            }
            return moduleSetup;
        }
        return null;
    }

    private synchronized void reloadConfig(Connection con, int mid) {
        if (mid > 0) {
            this.moduleSetupMap.remove(mid);
            this.configMap.remove(mid);
        } else {
            log.info((Object)"Reload kernel config...");
            HashMap<String, String> data = new HashMap<String, String>();
            this.loadBundle(data);
            this.loadModuleSetup(con, 0, data);
            this.updateData(data);
            this.configMap.remove(0);
            this.initDate = new Date();
            this.initTrashPoolsAndCreateTableOptions();
            this.throwActionEvent(new ActionEvent(this, 0, "reload"));
            XSLManager.getInstance().reloadConfig();
        }
    }

    public String getFolderPathParam(String paramName, String defaultValue) {
        return Utils.checkPath(this.get(paramName, defaultValue));
    }

    public String getTempDirPath() {
        return this.get("temp.dir.path", new File("tmp").getAbsolutePath()) + File.separator;
    }

    public String getPathProperty(String what, String def) {
        return Utils.checkPath(System.getProperty(what, this.get(what, def)));
    }

    public static Setup getSetup() {
        return instance;
    }

    public static void setSetup(Setup setup) {
        instance = setup;
    }
}

