/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.wifi.server.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import ru.bitel.bgbilling.kernel.wifi.GlobalConfig;
import ru.bitel.bgbilling.kernel.wifi.server.util.CommandUtil;

public class ARPUtil {
    private static Logger log = Logger.getLogger(ARPUtil.class);
    private static String arpCommand = null;
    public static final char[] HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static void addRecord(String ip, String mac) {
        StringBuffer command = new StringBuffer();
        command.append(arpCommand);
        command.append(" -s ");
        command.append(" " + ip);
        command.append(" " + mac);
        log.debug((Object)command);
        try {
            CommandUtil.runCommand(command.toString());
        }
        catch (IOException e) {
            log.error((Object)("error while ading new entry for arp tables (ip=" + ip + ", mac = " + mac + ")"), (Throwable)e);
        }
    }

    public static void deleteRecord(String ip) {
        StringBuffer command = new StringBuffer();
        command.append(arpCommand);
        command.append(" -d ");
        command.append(" " + ip);
        log.debug((Object)command);
        try {
            CommandUtil.runCommand(command.toString());
        }
        catch (IOException e) {
            log.error((Object)("error while deleting new entry for arp tables (ip=" + ip + ")"), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> getMACs() {
        HashMap<String, String> result = new HashMap<String, String>();
        Process proc = null;
        InputStreamReader reader = null;
        try {
            String command = arpCommand + " -n ";
            proc = Runtime.getRuntime().exec(command);
            InputStream input = proc.getInputStream();
            reader = new InputStreamReader(input);
            int size = 1000;
            char[] bufer = new char[size];
            int count = 1;
            StringBuffer stringBuffer = new StringBuffer();
            while (count > 0) {
                count = reader.read(bufer, 0, size);
                if (count <= 0) continue;
                stringBuffer.append(bufer, 0, count);
            }
            String str = stringBuffer.toString();
            String[] strs = str.split("\\n");
            for (int i = 1; i < strs.length; ++i) {
                String[] subStrs = strs[i].trim().split("\\s+");
                if (subStrs.length < 3 || subStrs.length < 3) continue;
                String ip = subStrs[0];
                String mac = subStrs[2];
                if (mac.indexOf("incom") >= 0) continue;
                result.put(ip, mac);
            }
            input.close();
        }
        catch (IOException e) {
            log.error((Object)"", (Throwable)e);
        }
        finally {
            try {
                if (proc != null) {
                    proc.destroy();
                    reader.close();
                }
            }
            catch (IOException e) {
                log.error((Object)"", (Throwable)e);
            }
        }
        return result;
    }

    public static String getMACForIp(String ip) {
        return ARPUtil.getMACs().get(ip);
    }

    public static String getMAC(byte[] bytes, int len) {
        StringBuilder hex = new StringBuilder();
        if (bytes != null) {
            for (int j = 0; j < len; ++j) {
                hex.append(HEX[(bytes[j] & 0xF0) >> 4]);
                hex.append(HEX[bytes[j] & 0xF]);
                if (j >= len - 1) continue;
                hex.append(":");
            }
        }
        return hex.toString();
    }

    static {
        GlobalConfig cfg = GlobalConfig.getGlobalConfig();
        arpCommand = cfg.getArpCommand();
    }
}

