/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.tariff.tree.server.npay;

import bitel.billing.server.npay.bean.ModuleQuantity;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import ru.bitel.bgbilling.kernel.tariff.tree.server.AbstractTariffRequest;
import ru.bitel.bgbilling.kernel.tariff.tree.server.ModuleServiceTariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.tree.server.TariffTreeNodeHolder;
import ru.bitel.bgbilling.kernel.tariff.tree.server.TreeContext;
import ru.bitel.bgbilling.modules.npay.tariff.server.NPayTariffContext;
import ru.bitel.bgbilling.modules.npay.tariff.server.NPayTariffRequest;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.model.Period;
import ru.bitel.common.worker.ThreadContext;

public class CalculateModeTariffTreeNode
extends ModuleServiceTariffTreeNode<NPayTariffContext, NPayTariffRequest.NPayServiceCost, NPayTariffRequest> {
    public static final int MODE_MONTH = 0;
    public static final int MODE_DAY = 1;
    public static final int MODE_YEAR = 2;
    public static final int MODE_ADVANCE = 3;
    public static final int MODE_QUARTER = 4;
    private final int mode;
    private final int calcType;

    public CalculateModeTariffTreeNode(int id, ParameterMap parameterMap) {
        super(id, parameterMap);
        String modeParam = parameterMap.get("mode", null);
        this.mode = "day".equals(modeParam) ? 1 : ("year".equals(modeParam) ? 2 : ("advance".equals(modeParam) ? 3 : ("quarter".equals(modeParam) ? 4 : 0)));
        this.calcType = parameterMap.getInt("type", 0);
    }

    @Override
    public int execute(Long treeNodeId, Long parentTreeNodeId, NPayTariffRequest req, TariffTreeNodeHolder holder, NPayTariffContext context, TreeContext treeContext, ThreadContext workerContext) {
        List serviceCostList = (List)req.getServiceCost().get(this.serviceId);
        if (serviceCostList == null) {
            return 0;
        }
        switch (this.mode) {
            case 0: {
                int size = serviceCostList.size();
                for (int i = 0; i < size; ++i) {
                    req.serviceCost = (AbstractTariffRequest.ServiceCost)serviceCostList.get(i);
                    this.monthMode(treeNodeId, req, holder, context, treeContext, workerContext);
                }
                break;
            }
            case 1: {
                int size = serviceCostList.size();
                for (int i = 0; i < size; ++i) {
                    req.serviceCost = (AbstractTariffRequest.ServiceCost)serviceCostList.get(i);
                    this.dayMode(treeNodeId, req, holder, context, treeContext, workerContext);
                }
                break;
            }
            case 3: {
                int size = serviceCostList.size();
                for (int i = 0; i < size; ++i) {
                    req.serviceCost = (AbstractTariffRequest.ServiceCost)serviceCostList.get(i);
                    this.advanceMode(treeNodeId, req, holder, context, treeContext, workerContext);
                }
                break;
            }
            case 2: {
                int size = serviceCostList.size();
                for (int i = 0; i < size; ++i) {
                    req.serviceCost = (AbstractTariffRequest.ServiceCost)serviceCostList.get(i);
                    this.yearMode(treeNodeId, req, holder, context, treeContext, workerContext);
                }
                break;
            }
            case 4: {
                int size = serviceCostList.size();
                for (int i = 0; i < size; ++i) {
                    req.serviceCost = (AbstractTariffRequest.ServiceCost)serviceCostList.get(i);
                    this.quarterMode(treeNodeId, req, holder, context, treeContext, workerContext);
                }
                break;
            }
            default: {
                req.addError("Unknown mode");
            }
        }
        return 1;
    }

    public void dayMode(Long treeNodeId, NPayTariffRequest req, TariffTreeNodeHolder holder, NPayTariffContext ctx, TreeContext treeContext, ThreadContext workerContext) {
        Calendar end;
        Map suspendPeriodMapList;
        List<Period> suspendPeriodList;
        Calendar date1 = ((NPayTariffRequest.NPayServiceCost)req.serviceCost).date1;
        Calendar date2 = ((NPayTariffRequest.NPayServiceCost)req.serviceCost).date2;
        Calendar time = req.getTime();
        BigDecimal inCost = ((NPayTariffRequest.NPayServiceCost)req.serviceCost).cost;
        Map pushed = req.acceptedSetPush();
        Calendar day = (Calendar)date1.clone();
        TimeUtils.clear_HOUR_MIN_MIL_SEC(day);
        Calendar dayEnd = (Calendar)date1.clone();
        if (req.isInfoEnabled()) {
            req.addInfo("Day mode: " + ((NPayTariffRequest.NPayServiceCost)req.serviceCost).toString());
        }
        if ((suspendPeriodList = this.getSuspendPeriodList(suspendPeriodMapList = ctx.getSuspendPeriods(req.contractId, ((NPayTariffRequest.NPayServiceCost)req.serviceCost).serviceId))) == null && req.isInfoEnabled()) {
            req.addInfo("Service not suspedable");
        }
        Calendar calendar = end = this.calcType == 1 ? ctx.getCurrentDay() : date2;
        if (TimeUtils.dateBefore(date2, end)) {
            end = date2;
        }
        BigDecimal cost = BigDecimal.ZERO;
        ModuleQuantity quantity = ctx.getModuleQuantity(((NPayTariffRequest.NPayServiceCost)req.serviceCost).serviceId);
        List quantityPeriodList = quantity != null ? quantity.getPeriodQuantity(req.getConnection(), req.contractId, ((NPayTariffRequest.NPayServiceCost)req.serviceCost).date1, ((NPayTariffRequest.NPayServiceCost)req.serviceCost).date2) : null;
        req.cleardayDetailLog();
        while (TimeUtils.dateBeforeOrEq(day, end)) {
            boolean skipDayBySuspend = this.checkDayInStatus(ctx, day, suspendPeriodList);
            if (skipDayBySuspend) {
                if (req.isInfoEnabled()) {
                    req.addInfo("Service " + ((NPayTariffRequest.NPayServiceCost)req.serviceCost).serviceId + " suspended at " + TimeUtils.formatDate(day));
                }
                day.add(6, 1);
                continue;
            }
            dayEnd.setTimeInMillis(day.getTimeInMillis());
            dayEnd.add(5, 1);
            dayEnd.add(14, -1);
            assert (TimeUtils.compare(day, dayEnd, 5) == 0);
            ((NPayTariffRequest.NPayServiceCost)req.serviceCost).date1 = day;
            ((NPayTariffRequest.NPayServiceCost)req.serviceCost).date2 = dayEnd;
            req.setTime(day);
            ((NPayTariffRequest.NPayServiceCost)req.serviceCost).cost = null;
            req.acceptedSetClear();
            super.executeChildren(treeNodeId, (AbstractTariffRequest<?>)req, holder, ctx, treeContext, workerContext);
            if (((NPayTariffRequest.NPayServiceCost)req.serviceCost).cost != null) {
                if (req.isInfoEnabled()) {
                    req.addInfo(TimeUtils.formatDate(day) + "=>" + ((NPayTariffRequest.NPayServiceCost)req.serviceCost).cost);
                }
                if (quantity != null) {
                    BigDecimal quantityVal = this.getDayQuantity(day, quantityPeriodList);
                    if (req.isInfoEnabled()) {
                        req.addInfo("quantity val=" + quantityVal);
                    }
                    ((NPayTariffRequest.NPayServiceCost)req.serviceCost).cost = ((NPayTariffRequest.NPayServiceCost)req.serviceCost).cost.multiply(quantityVal, ctx.mc);
                }
            } else {
                cost = null;
                break;
            }
            req.setDayDetailLog(day.get(5), ((NPayTariffRequest.NPayServiceCost)req.serviceCost).cost);
            cost = cost.add(((NPayTariffRequest.NPayServiceCost)req.serviceCost).cost);
            day.add(5, 1);
        }
        ((NPayTariffRequest.NPayServiceCost)req.serviceCost).date1 = date1;
        ((NPayTariffRequest.NPayServiceCost)req.serviceCost).date2 = date2;
        ((NPayTariffRequest.NPayServiceCost)req.serviceCost).cost = cost;
        req.setTime(time);
        req.acceptedSetPop(pushed);
        if (cost != null) {
            req.addInfo("process cost=" + cost);
            ((NPayTariffRequest.NPayServiceCost)req.serviceCost).cost = cost;
            if (((NPayTariffRequest.NPayServiceCost)req.serviceCost).amount != 1L && ((NPayTariffRequest.NPayServiceCost)req.serviceCost).cost != null) {
                ((NPayTariffRequest.NPayServiceCost)req.serviceCost).cost = ((NPayTariffRequest.NPayServiceCost)req.serviceCost).cost.multiply(BigDecimal.valueOf(((NPayTariffRequest.NPayServiceCost)req.serviceCost).amount), ctx.mc);
            }
            this.addCloseReplaceServices(req, ctx, suspendPeriodMapList);
            req.setCalculateModeLog(1);
        } else {
            req.addInfo("return cost=" + inCost);
            ((NPayTariffRequest.NPayServiceCost)req.serviceCost).cost = inCost;
            req.cleardayDetailLog();
        }
    }

    public void monthMode(Long treeNodeId, NPayTariffRequest req, TariffTreeNodeHolder holder, NPayTariffContext ctx, TreeContext treeContext, ThreadContext workerContext) {
        Map suspendPeriodMapList = ctx.getSuspendPeriods(req.contractId, ((NPayTariffRequest.NPayServiceCost)req.serviceCost).serviceId);
        List<Period> suspendPeriodList = this.getSuspendPeriodList(suspendPeriodMapList);
        Period precalcOpenPeriod = ctx.getPrecalcOpenPeriod();
        long days = this.days(ctx, req, suspendPeriodList, precalcOpenPeriod);
        BigDecimal inCost = ((NPayTariffRequest.NPayServiceCost)req.serviceCost).cost;
        ((NPayTariffRequest.NPayServiceCost)req.serviceCost).accountingPeriodDays = Long.bitCount(days);
        req.setTime(((NPayTariffRequest.NPayServiceCost)req.serviceCost).date2);
        ((NPayTariffRequest.NPayServiceCost)req.serviceCost).cost = null;
        super.executeChildren(treeNodeId, (AbstractTariffRequest<?>)req, holder, ctx, treeContext, workerContext);
        if (((NPayTariffRequest.NPayServiceCost)req.serviceCost).cost != null) {
            ModuleQuantity quantity = ctx.getModuleQuantity(((NPayTariffRequest.NPayServiceCost)req.serviceCost).serviceId);
            if (quantity != null) {
                List quantityPeriodList = quantity.getPeriodQuantity(req.getConnection(), req.contractId, ((NPayTariffRequest.NPayServiceCost)req.serviceCost).date1, ((NPayTariffRequest.NPayServiceCost)req.serviceCost).date2);
                BigDecimal quantityVal = this.getDayQuantity(((NPayTariffRequest.NPayServiceCost)req.serviceCost).date2, quantityPeriodList);
                if (req.isInfoEnabled()) {
                    req.addInfo("quantity val=" + quantityVal);
                }
                ((NPayTariffRequest.NPayServiceCost)req.serviceCost).cost = ((NPayTariffRequest.NPayServiceCost)req.serviceCost).cost.multiply(quantityVal, ctx.mc);
            }
            if (((NPayTariffRequest.NPayServiceCost)req.serviceCost).amount != 1L) {
                ((NPayTariffRequest.NPayServiceCost)req.serviceCost).cost = ((NPayTariffRequest.NPayServiceCost)req.serviceCost).cost.multiply(BigDecimal.valueOf(((NPayTariffRequest.NPayServiceCost)req.serviceCost).amount), ctx.mc);
            }
            this.addCloseReplaceServices(req, ctx, suspendPeriodMapList);
            req.setCalculateModeLog(0);
        } else {
            req.addInfo("return cost=" + inCost);
            ((NPayTariffRequest.NPayServiceCost)req.serviceCost).cost = inCost;
        }
    }

    private List<Period> getSuspendPeriodList(Map<Integer, List<Period>> suspendPeriodMapList) {
        ArrayList<Period> suspendPeriodList = null;
        if (suspendPeriodMapList.size() > 0) {
            suspendPeriodList = new ArrayList<Period>();
            for (List<Period> e : suspendPeriodMapList.values()) {
                suspendPeriodList.addAll(e);
            }
        }
        return suspendPeriodList;
    }

    public void quarterMode(Long treeNodeId, NPayTariffRequest req, TariffTreeNodeHolder holder, NPayTariffContext ctx, TreeContext treeContext, ThreadContext workerContext) {
        int month = ((NPayTariffRequest.NPayServiceCost)req.serviceCost).date1.get(2);
        Calendar prevMonthCalendar = (Calendar)((NPayTariffRequest.NPayServiceCost)req.serviceCost).date1.clone();
        prevMonthCalendar.add(2, -1);
        if (!CalculateModeTariffTreeNode.isFirstInQuarter(month) && !CalculateModeTariffTreeNode.closedOnMonth((NPayTariffRequest.NPayServiceCost)req.serviceCost, prevMonthCalendar)) {
            ((NPayTariffRequest.NPayServiceCost)req.serviceCost).cost = BigDecimal.ZERO;
            return;
        }
        Map suspendPeriodMapList = ctx.getSuspendPeriods(req.contractId, ((NPayTariffRequest.NPayServiceCost)req.serviceCost).serviceId);
        List<Period> suspendPeriodList = this.getSuspendPeriodList(suspendPeriodMapList);
        Period precalcOpenPeriod = ctx.getPrecalcOpenPeriod();
        long days = this.days(ctx, req, suspendPeriodList, precalcOpenPeriod);
        BigDecimal inCost = ((NPayTariffRequest.NPayServiceCost)req.serviceCost).cost;
        ((NPayTariffRequest.NPayServiceCost)req.serviceCost).accountingPeriodDays = Long.bitCount(days);
        req.setTime(((NPayTariffRequest.NPayServiceCost)req.serviceCost).date2);
        ((NPayTariffRequest.NPayServiceCost)req.serviceCost).cost = null;
        super.executeChildren(treeNodeId, (AbstractTariffRequest<?>)req, holder, ctx, treeContext, workerContext);
        if (((NPayTariffRequest.NPayServiceCost)req.serviceCost).cost != null) {
            ModuleQuantity quantity = ctx.getModuleQuantity(((NPayTariffRequest.NPayServiceCost)req.serviceCost).serviceId);
            if (quantity != null) {
                List quantityPeriodList = quantity.getPeriodQuantity(req.getConnection(), req.contractId, ((NPayTariffRequest.NPayServiceCost)req.serviceCost).date1, ((NPayTariffRequest.NPayServiceCost)req.serviceCost).date2);
                BigDecimal quantityVal = this.getDayQuantity(((NPayTariffRequest.NPayServiceCost)req.serviceCost).date2, quantityPeriodList);
                if (req.isInfoEnabled()) {
                    req.addInfo("quantity val=" + quantityVal);
                }
                ((NPayTariffRequest.NPayServiceCost)req.serviceCost).cost = ((NPayTariffRequest.NPayServiceCost)req.serviceCost).cost.multiply(quantityVal, ctx.mc);
            }
            if (((NPayTariffRequest.NPayServiceCost)req.serviceCost).amount != 1L) {
                ((NPayTariffRequest.NPayServiceCost)req.serviceCost).cost = ((NPayTariffRequest.NPayServiceCost)req.serviceCost).cost.multiply(BigDecimal.valueOf(((NPayTariffRequest.NPayServiceCost)req.serviceCost).amount), ctx.mc);
            }
            req.setCalculateModeLog(4);
        } else {
            req.addInfo("return cost=" + inCost);
            ((NPayTariffRequest.NPayServiceCost)req.serviceCost).cost = inCost;
        }
    }

    private static boolean isFirstInQuarter(int month) {
        int[] quarterStartMonths = new int[]{0, 3, 6, 9};
        for (int i = 0; i < quarterStartMonths.length; ++i) {
            if (quarterStartMonths[i] != month) continue;
            return true;
        }
        return false;
    }

    private static boolean closedOnMonth(NPayTariffRequest.NPayServiceCost serviceCost, Calendar month) {
        return serviceCost.serviceEnd != null && serviceCost.serviceEnd.get(2) == month.get(2) && serviceCost.serviceEnd.get(1) == month.get(1);
    }

    public void yearMode(Long treeNodeId, NPayTariffRequest req, TariffTreeNodeHolder holder, NPayTariffContext ctx, TreeContext treeContext, ThreadContext workerContext) {
        if (((NPayTariffRequest.NPayServiceCost)req.serviceCost).serviceStart == null) {
            return;
        }
        if (((NPayTariffRequest.NPayServiceCost)req.serviceCost).serviceStart.get(2) != ((NPayTariffRequest.NPayServiceCost)req.serviceCost).date1.get(2)) {
            ((NPayTariffRequest.NPayServiceCost)req.serviceCost).cost = BigDecimal.ZERO;
            return;
        }
        BigDecimal inCost = ((NPayTariffRequest.NPayServiceCost)req.serviceCost).cost;
        req.setTime(((NPayTariffRequest.NPayServiceCost)req.serviceCost).date2);
        super.executeChildren(treeNodeId, (AbstractTariffRequest<?>)req, holder, ctx, treeContext, workerContext);
        if (((NPayTariffRequest.NPayServiceCost)req.serviceCost).cost != null) {
            if (((NPayTariffRequest.NPayServiceCost)req.serviceCost).amount != 1L) {
                ((NPayTariffRequest.NPayServiceCost)req.serviceCost).cost = ((NPayTariffRequest.NPayServiceCost)req.serviceCost).cost.multiply(BigDecimal.valueOf(((NPayTariffRequest.NPayServiceCost)req.serviceCost).amount), ctx.mc);
            }
            req.setCalculateModeLog(2);
        } else {
            req.addInfo("return cost=" + inCost);
            ((NPayTariffRequest.NPayServiceCost)req.serviceCost).cost = inCost;
        }
    }

    public void advanceMode(Long treeNodeId, NPayTariffRequest req, TariffTreeNodeHolder holder, NPayTariffContext ctx, TreeContext treeContext, ThreadContext workerContext) {
        Calendar date1 = ((NPayTariffRequest.NPayServiceCost)req.serviceCost).date1;
        Calendar date2 = ((NPayTariffRequest.NPayServiceCost)req.serviceCost).date2;
        BigDecimal inCost = ((NPayTariffRequest.NPayServiceCost)req.serviceCost).cost;
        if (req.isInfoEnabled()) {
            req.addInfo("Advance mode: " + ((NPayTariffRequest.NPayServiceCost)req.serviceCost).toString());
        }
        if (((NPayTariffRequest.NPayServiceCost)req.serviceCost).serviceEnd != null && TimeUtils.monthsDelta(((NPayTariffRequest.NPayServiceCost)req.serviceCost).serviceStart, ctx.getCurrentDay()) != 0) {
            ((NPayTariffRequest.NPayServiceCost)req.serviceCost).cost = BigDecimal.ZERO;
            return;
        }
        Map suspendPeriodMapList = ctx.getSuspendPeriods(req.contractId, ((NPayTariffRequest.NPayServiceCost)req.serviceCost).serviceId);
        List<Period> suspendPeriodList = this.getSuspendPeriodList(suspendPeriodMapList);
        if (suspendPeriodList == null && req.isInfoEnabled()) {
            req.addInfo("Service not suspedable");
        }
        req.setTime(((NPayTariffRequest.NPayServiceCost)req.serviceCost).date1);
        ((NPayTariffRequest.NPayServiceCost)req.serviceCost).cost = null;
        super.executeChildren(treeNodeId, (AbstractTariffRequest<?>)req, holder, ctx, treeContext, workerContext);
        if (((NPayTariffRequest.NPayServiceCost)req.serviceCost).cost != null) {
            if (req.isInfoEnabled()) {
                req.addInfo("cost => " + ((NPayTariffRequest.NPayServiceCost)req.serviceCost).cost);
            }
            if (((NPayTariffRequest.NPayServiceCost)req.serviceCost).amount != 1L && ((NPayTariffRequest.NPayServiceCost)req.serviceCost).cost != null) {
                ((NPayTariffRequest.NPayServiceCost)req.serviceCost).cost = ((NPayTariffRequest.NPayServiceCost)req.serviceCost).cost.multiply(BigDecimal.valueOf(((NPayTariffRequest.NPayServiceCost)req.serviceCost).amount), ctx.mc);
            }
            BigDecimal cost = BigDecimal.ZERO;
            Calendar day = (Calendar)date1.clone();
            TimeUtils.clear_HOUR_MIN_MIL_SEC(day);
            Calendar dateEnd = ((NPayTariffRequest.NPayServiceCost)req.serviceCost).serviceEnd;
            if (dateEnd == null) {
                dateEnd = date2;
            }
            while (TimeUtils.dateBeforeOrEq(day, dateEnd)) {
                boolean skipDayBySuspend = this.checkDayInStatus(ctx, day, suspendPeriodList);
                if (skipDayBySuspend) {
                    if (req.isInfoEnabled()) {
                        req.addInfo("Service " + ((NPayTariffRequest.NPayServiceCost)req.serviceCost).serviceId + " suspended at " + TimeUtils.formatDate(day));
                    }
                    day.add(6, 1);
                    continue;
                }
                cost = cost.add(((NPayTariffRequest.NPayServiceCost)req.serviceCost).cost);
                day.add(5, 1);
            }
            ((NPayTariffRequest.NPayServiceCost)req.serviceCost).cost = cost;
            req.setCalculateModeLog(3);
        } else {
            req.addInfo("return cost=" + inCost);
            ((NPayTariffRequest.NPayServiceCost)req.serviceCost).cost = inCost;
        }
    }

    private BigDecimal getDayQuantity(Calendar day, List<Period> periodList) {
        int result = 0;
        for (Period per : periodList) {
            if (per.getDateFromCalendar() != null && !TimeUtils.dateBeforeOrEq(per.getDateFromCalendar(), day) || per.getDateToCalendar() != null && !TimeUtils.dateBeforeOrEq(day, per.getDateToCalendar())) continue;
            ++result;
        }
        return BigDecimal.valueOf(result);
    }

    private long days(NPayTariffContext ctx, NPayTariffRequest req, List<Period> suspendPeriodList, Period precalcOpenPeriod) {
        assert (((NPayTariffRequest.NPayServiceCost)req.serviceCost).date1 != null && ((NPayTariffRequest.NPayServiceCost)req.serviceCost).date2 != null && TimeUtils.monthsDelta(((NPayTariffRequest.NPayServiceCost)req.serviceCost).date1, ((NPayTariffRequest.NPayServiceCost)req.serviceCost).date2) == 0);
        int day1 = ((NPayTariffRequest.NPayServiceCost)req.serviceCost).date1.get(5);
        int result = ((NPayTariffRequest.NPayServiceCost)req.serviceCost).date2.get(5) - day1 + 1;
        long days = 0xFFFFFFFFL >> 32 - result << day1 - 1;
        long daysSuspended = 0L;
        if (suspendPeriodList != null) {
            int size = suspendPeriodList.size();
            for (int i = 0; i < size; ++i) {
                Period p = suspendPeriodList.get(i);
                day1 = p.getDateFromCalendar().get(5);
                result = p.getDateToCalendar().get(5) - day1 + 1;
                daysSuspended |= 0xFFFFFFFFL >> 32 - result << day1 - 1;
            }
        }
        long precalcOpened = 0L;
        if (precalcOpenPeriod != null) {
            day1 = precalcOpenPeriod.getDateFromCalendar().get(5);
            result = precalcOpenPeriod.getDateToCalendar().get(5) - day1 + 1;
            precalcOpened = 0xFFFFFFFFL >> 32 - result << day1 - 1;
        }
        return days &= daysSuspended ^ 0xFFFFFFFFFFFFFFFFL | precalcOpened;
    }

    private boolean checkDayInStatus(NPayTariffContext ctx, Calendar day, List<Period> periodList) {
        boolean skipDay = false;
        if (periodList != null) {
            for (Period period : periodList) {
                if (!TimeUtils.dateInRange(day, period.getDateFromCalendar(), period.getDateToCalendar())) continue;
                skipDay = true;
                break;
            }
            Period precalcOpenPeriod = ctx.getPrecalcOpenPeriod();
            if (skipDay && precalcOpenPeriod != null && TimeUtils.dateInRange(day, precalcOpenPeriod.getDateFromCalendar(), precalcOpenPeriod.getDateToCalendar())) {
                skipDay = false;
            }
        }
        return skipDay;
    }

    private void addCloseReplaceServices(NPayTariffRequest req, NPayTariffContext ctx, Map<Integer, List<Period>> closePeriodList) {
        Period precalcOpenPeriod = ctx.getPrecalcOpenPeriod();
        if (closePeriodList != null) {
            for (Map.Entry<Integer, List<Period>> me : closePeriodList.entrySet()) {
                Integer status = me.getKey();
                for (Period p : me.getValue()) {
                    Calendar date2;
                    int wrapServiceId = ctx.getWrapService(((NPayTariffRequest.NPayServiceCost)req.serviceCost).serviceId, status.intValue());
                    if (wrapServiceId <= 0) continue;
                    Calendar date1 = TimeUtils.dateBefore(p.getDateFromCalendar(), ((NPayTariffRequest.NPayServiceCost)req.serviceCost).date1) ? ((NPayTariffRequest.NPayServiceCost)req.serviceCost).date1 : p.getDateFromCalendar();
                    Calendar calendar = date2 = TimeUtils.dateBefore(p.getDateToCalendar(), ((NPayTariffRequest.NPayServiceCost)req.serviceCost).date2) ? p.getDateToCalendar() : ((NPayTariffRequest.NPayServiceCost)req.serviceCost).date2;
                    if (precalcOpenPeriod != null && TimeUtils.dateBefore(precalcOpenPeriod.getDateFromCalendar(), date2)) {
                        date2 = TimeUtils.getPrevDay(precalcOpenPeriod.getDateFromCalendar());
                    }
                    if (!TimeUtils.dateBeforeOrEq(date1, date2)) continue;
                    NPayTariffRequest.NPayServiceCost serviceCost = new NPayTariffRequest.NPayServiceCost(wrapServiceId, ((NPayTariffRequest.NPayServiceCost)req.serviceCost).serviceStart, ((NPayTariffRequest.NPayServiceCost)req.serviceCost).serviceEnd, date1, date2, ((NPayTariffRequest.NPayServiceCost)req.serviceCost).amount);
                    req.addServiceCost((AbstractTariffRequest.ServiceCost)serviceCost);
                }
            }
        }
    }
}

