/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.script.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.script.common.bean.Revision;
import ru.bitel.bgbilling.kernel.script.common.bean.Script;
import ru.bitel.bgbilling.kernel.script.common.bean.ScriptBackup;
import ru.bitel.bgbilling.kernel.script.common.bean.ScriptLibrary;
import ru.bitel.bgbilling.kernel.script.server.bean.ScriptBackupManager;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.UserMap;
import ru.bitel.common.dao.AbstractIdDao;

public class ScriptLibraryManager
extends AbstractIdDao<ScriptLibrary> {
    public ScriptLibraryManager(Connection con) {
        super(con, 0, "script_lib");
    }

    @Override
    protected void updateImpl(ScriptLibrary lib) throws BGException, SQLException {
        try {
            PreparedStatement ps;
            if (lib.getId() == -1) {
                ps = this.con.prepareStatement("INSERT INTO " + this.tableName + " (name, title, script, user_id) VALUES (?, ?, ?, ?)", 1);
            } else {
                ps = this.con.prepareStatement("UPDATE " + this.tableName + " SET name=?, title=?, script=?, user_id=? WHERE id=?");
                ps.setInt(5, lib.getId());
            }
            ps.setString(1, lib.getName());
            ps.setString(2, lib.getTitle());
            ps.setString(3, lib.getScript());
            ps.setInt(4, lib.getUserId());
            ps.executeUpdate();
            if (lib.getId() == -1) {
                lib.setId(ServerUtils.lastInsertId(ps));
            }
            lib.setTimeRevision(((ScriptLibrary)this.get(lib.getId())).getTimeRevision());
            ps.close();
        }
        catch (SQLException e) {
            if (e.getSQLState() != null && e.getSQLState().startsWith("23")) {
                throw new BGMessageException("\u0411\u0438\u0431\u043b\u0438\u043e\u0442\u0435\u043a\u0430 \u0441 \u0442\u0430\u043a\u0438\u043c \u0438\u043c\u0435\u043d\u0435\u043c \u0443\u0436\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442.");
            }
            throw e;
        }
    }

    public ScriptLibrary getByName(String name) throws BGException {
        try {
            PreparedStatement ps = this.con.prepareStatement("SELECT * FROM " + this.tableName + " WHERE name=?");
            ps.setString(1, name);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                ScriptLibrary result = this.getFromRS(rs);
                rs.close();
                ps.close();
                return result;
            }
            rs.close();
            ps.close();
            return null;
        }
        catch (SQLException e) {
            throw new BGException(e);
        }
    }

    public List<ScriptLibrary> list() throws BGException {
        return super.list(null, "title", new Object[0]);
    }

    public List<ScriptLibrary> pureList() throws BGException {
        ArrayList<ScriptLibrary> result = new ArrayList<ScriptLibrary>();
        try {
            PreparedStatement ps = this.con.prepareStatement("SELECT * FROM " + this.tableName + " ORDER BY title");
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(this.getPureFromRS(rs));
            }
            rs.close();
            ps.close();
            return result;
        }
        catch (SQLException e) {
            this.processException(e);
            return Collections.emptyList();
        }
    }

    @Override
    protected ScriptLibrary getFromRS(ResultSet rs) throws SQLException {
        ScriptLibrary result = new ScriptLibrary();
        result.setId(rs.getInt("id"));
        result.setName(rs.getString("name"));
        result.setTitle(rs.getString("title"));
        result.setScript(rs.getString("script"));
        result.setUserId(rs.getInt("user_id"));
        result.setTimeRevision(rs.getTimestamp("change_time"));
        return result;
    }

    protected ScriptLibrary getPureFromRS(ResultSet rs) throws SQLException {
        ScriptLibrary result = new ScriptLibrary();
        result.setId(rs.getInt("id"));
        result.setName(rs.getString("name"));
        result.setTitle(rs.getString("title"));
        result.setScript("");
        result.setUserId(rs.getInt("user_id"));
        result.setTimeRevision(rs.getTimestamp("change_time"));
        return result;
    }

    public Revision getRevisionProperties(int id) throws BGException {
        try {
            PreparedStatement ps = this.con.prepareStatement("SELECT id, user_id, change_time FROM " + this.tableName + " WHERE id=?");
            ps.setInt(1, id);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                Revision result = new Revision();
                result.setId(rs.getInt("id"));
                result.setUserId(rs.getInt("user_id"));
                result.setUserName(UserMap.getUser(result.getUserId()).getName());
                result.setTimeRevision(rs.getTimestamp("change_time"));
                rs.close();
                ps.close();
                return result;
            }
            rs.close();
            ps.close();
            return null;
        }
        catch (SQLException e) {
            throw new BGException(e);
        }
    }

    public void backup(int scriptId, String comment) throws BGException {
        ScriptBackup backup = new ScriptBackup();
        backup.setScriptBackup((Script)this.get(scriptId), 2);
        backup.setComment(comment);
        backup.setId(-1);
        new ScriptBackupManager(this.con).update(backup);
    }

    public void deleteFull(int scriptId) throws BGException {
        this.delete(scriptId);
        new ScriptBackupManager(this.con).deleteBackups(scriptId, 2);
    }
}

