/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.network.radius.inspectors;

import bitel.billing.server.processor.dialup.DialUpSessionRealtime;
import bitel.billing.server.radius.RadiusSetup;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Map;
import java.util.Observer;
import org.apache.log4j.Logger;
import ru.bitel.bgbilling.kernel.network.radius.inspectors.SNMPNasConnectionCheckObserver;
import ru.bitel.bgbilling.kernel.network.radius.inspectors.SNMPNasConnectionInspector;
import ru.bitel.bgbilling.kernel.network.radius.nas.NasConnection;
import ru.bitel.bgbilling.kernel.network.radius.nas.NasConnectionInspector;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Utils;
import uk.co.westhawk.snmp.pdu.OneGetPdu;
import uk.co.westhawk.snmp.stack.AsnInteger;
import uk.co.westhawk.snmp.stack.AsnObject;
import uk.co.westhawk.snmp.stack.SetPdu;
import uk.co.westhawk.snmp.stack.SnmpContextBasisFace;

public class SNMPNasConnectionInspectorPPPD
extends SNMPNasConnectionInspector {
    private static final Logger log = Logger.getLogger(SNMPNasConnectionInspectorPPPD.class);
    private final String pppdVersion;

    public SNMPNasConnectionInspectorPPPD(RadiusSetup setup, InetAddress nasIPAddress, byte[] secret, Map<String, ? extends NasConnection<?>> connection, ParameterMap params, NasConnectionInspector old) throws IOException {
        super(setup, nasIPAddress, secret, connection, params, old);
        this.pppdVersion = params.get("pppd.version", "2.4.2");
    }

    @Override
    protected void sendCheckRequest(NasConnection<?> connection) {
        DialUpSessionRealtime session = (DialUpSessionRealtime)connection.getSession();
        int ver = this.context.getVersion();
        try {
            OneGetPdu getPdu = new OneGetPdu((SnmpContextBasisFace)this.context);
            getPdu.addOid(this.snmp_oid_check + "." + this.getCuttedDecSessionId(session.getAcctSessionId()));
            getPdu.addObserver((Observer)new SNMPNasConnectionCheckObserver(ver, connection, this.nasIPAddress));
            getPdu.send();
            session.addLogDebug("SNMP check request: oid " + this.snmp_oid_check + "." + this.getCuttedDecSessionId(session.getAcctSessionId()));
        }
        catch (Exception ex) {
            log.error((Object)ex.getMessage(), (Throwable)ex);
            session.addLogError("SNMP check request error  [ SNMP ver. " + ver + ", host=" + this.getHost() + ", msg=" + ex.getMessage() + " ]");
        }
    }

    @Override
    public long sendKillRequest(NasConnection<?> connection) {
        DialUpSessionRealtime session = (DialUpSessionRealtime)connection.getSession();
        try {
            SetPdu setPdu = new SetPdu((SnmpContextBasisFace)this.context);
            setPdu.addOid(this.snmp_oid_kill, (AsnObject)new AsnInteger(Utils.parseInt(this.getCuttedDecSessionId(session.getAcctSessionId()), -1)));
            setPdu.send();
            session.addLogInfo("SNMP reset request:  set " + this.snmp_oid_kill + " i " + this.getCuttedDecSessionId(session.getAcctSessionId()));
        }
        catch (Exception ex) {
            log.error((Object)ex.getMessage(), (Throwable)ex);
            session.addLogError("\u0417\u0430\u043f\u0440\u043e\u0441 \u043d\u0430 \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u0435 [ SNMP ver." + this.context.getVersion() + ", host=" + this.getHost() + ", msg=" + ex.getMessage() + " ]");
        }
        return 0L;
    }

    protected String getCuttedDecSessionId(String hexSessionId) {
        String result = "0";
        if (hexSessionId != null) {
            int length = hexSessionId.length();
            if (this.pppdVersion.equals("2.4.2")) {
                if (length > 4) {
                    hexSessionId = hexSessionId.substring(length - 4);
                }
            } else if (this.pppdVersion.equals("2.4.3") && length > 6) {
                hexSessionId = hexSessionId.substring(length - 6, length - 2);
            }
            result = this.getDecSessionId(hexSessionId);
        }
        return result;
    }

    @Deprecated
    protected String getCuttedDecSessionID(String hexSessionId) {
        return this.getCuttedDecSessionId(hexSessionId);
    }
}

