/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.network.flow;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import org.apache.log4j.Logger;
import ru.bitel.bgbilling.kernel.network.flow.FlowArray;
import ru.bitel.bgbilling.kernel.network.flow.NetFlow9Record;
import ru.bitel.bgbilling.kernel.network.flow.NetFlow9Template;
import ru.bitel.bgbilling.kernel.network.flow.Netflow9Processor;

public class NetFlow9Array
extends FlowArray<NetFlow9Record>
implements Netflow9Processor {
    private static final Logger log = Logger.getLogger(NetFlow9Array.class);

    public NetFlow9Array(int size) {
        super(NetFlow9Array.create(size));
    }

    private static final List<NetFlow9Record> create(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException(String.valueOf(size));
        }
        ArrayList<NetFlow9Record> recordList = new ArrayList<NetFlow9Record>(size);
        for (int i = 0; i < size; ++i) {
            recordList.add(new NetFlow9Record());
        }
        return recordList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean parsePacket(ByteBuffer readBuffer, long millis, ConcurrentMap<Integer, NetFlow9Template> templates) {
        int bufferPosition = readBuffer.position();
        try {
            this.size = 0;
            int version = readBuffer.getShort(0) & 0xFFFF;
            int count = readBuffer.getShort(2) & 0xFFFF;
            if (version != 9) {
                log.error((Object)("Incorrect NetFlow version: " + version));
                boolean bl = false;
                return bl;
            }
            int packetLimit = readBuffer.limit();
            if (log.isTraceEnabled()) {
                log.trace((Object)("NetFlow9 packet, count: " + count + "; limit: " + packetLimit));
            }
            int offset = 20;
            int i = 0;
            while (offset < packetLimit) {
                NetFlow9Template template;
                int templateId;
                readBuffer.position(offset);
                int flowSetId = readBuffer.getShort(offset) & 0xFFFF;
                int flowSetLength = readBuffer.getShort(offset + 2) & 0xFFFF;
                int flowSetLimit = offset + flowSetLength;
                if (log.isTraceEnabled()) {
                    log.trace((Object)("FlowSet id: " + flowSetId + "; offset: " + offset + "; length: " + flowSetLength + "; limit: " + flowSetLimit));
                }
                if (flowSetId > 255) {
                    log.trace((Object)"Data flowset.");
                    templateId = flowSetId;
                    template = (NetFlow9Template)templates.get(templateId);
                    if (template != null) {
                        offset += 4;
                        if (log.isTraceEnabled()) {
                            log.trace((Object)("Template data length: " + template.dataLength));
                        }
                        while (offset + template.dataLength <= flowSetLimit) {
                            if (template.flowLog) {
                                readBuffer.position(offset);
                                NetFlow9Record record = ((NetFlow9Record[])this.array)[this.size];
                                record.fillData(readBuffer, template);
                                record.milliseconds = millis;
                                if (log.isTraceEnabled()) {
                                    log.trace((Object)("Record: " + this.size + "; offset: " + offset + "\n" + record));
                                }
                                ++this.size;
                            } else if (log.isTraceEnabled()) {
                                log.trace((Object)"Not flow record");
                            }
                            offset += template.dataLength;
                        }
                    }
                } else if (flowSetId == 0) {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)"Template flowset!");
                    }
                    offset += 4;
                    while (offset < flowSetLimit) {
                        templateId = readBuffer.getShort(offset) & 0xFFFF;
                        template = new NetFlow9Template();
                        readBuffer.position(offset);
                        template.parse(readBuffer);
                        templates.put(templateId, template);
                        offset += template.length;
                    }
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("Offset: " + offset));
                    }
                }
                offset = flowSetLimit;
                ++i;
            }
        }
        finally {
            readBuffer.position(bufferPosition);
        }
        return true;
    }

    public final int next(ByteBuffer readBuffer, ConcurrentMap<Integer, NetFlow9Template> templates) throws Exception {
        this.size = 0;
        return NetFlow9Array.next(readBuffer, templates, this);
    }

    @Override
    public void process(ByteBuffer readBuffer, int offset, long millis, NetFlow9Template template) {
        if (!template.flowLog) {
            return;
        }
        readBuffer.position(offset);
        NetFlow9Record record = ((NetFlow9Record[])this.array)[this.size];
        record.fillData(readBuffer, template);
        record.milliseconds = millis;
        if (log.isTraceEnabled()) {
            log.trace((Object)("Record: " + this.size + "; offset: " + offset + "\n" + record));
        }
        ++this.size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int next(ByteBuffer readBuffer, ConcurrentMap<Integer, NetFlow9Template> templates, Netflow9Processor processor) throws Exception {
        int offset = readBuffer.position();
        int limit = readBuffer.limit() - 1;
        if (log.isTraceEnabled()) {
            log.trace((Object)("Chunk: length = " + readBuffer.getInt(0) + "; id = " + readBuffer.getInt(4)));
            log.trace((Object)("ReadBuffer: offset = " + offset + "; limit = " + limit));
        }
        try {
            while (offset < limit - 20) {
                long millis = readBuffer.getLong(offset);
                int packetLength = readBuffer.getInt(offset + 12);
                int packetEnd = (offset += 16) + packetLength;
                int version = readBuffer.getShort(offset) & 0xFFFF;
                int count = readBuffer.getShort(offset + 2) & 0xFFFF;
                if (version != 9) {
                    log.error((Object)("Incorrect NetFlow version: " + version));
                }
                if (log.isTraceEnabled()) {
                    log.trace((Object)("NetFlow9 packet, count: " + count));
                }
                offset += 20;
                while (offset < packetEnd) {
                    NetFlow9Template template;
                    int templateId;
                    readBuffer.position(offset);
                    int flowSetId = readBuffer.getShort(offset) & 0xFFFF;
                    int flowSetLength = readBuffer.getShort(offset + 2) & 0xFFFF;
                    int flowSetEnd = offset + flowSetLength;
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("FlowSet id: " + flowSetId + "; offset: " + offset + "; length: " + flowSetLength + "; end: " + flowSetEnd));
                    }
                    if (flowSetId > 255) {
                        log.trace((Object)"Data flowset.");
                        templateId = flowSetId;
                        template = (NetFlow9Template)templates.get(templateId);
                        if (template != null) {
                            offset += 4;
                            if (log.isTraceEnabled()) {
                                log.trace((Object)("Template data length: " + template.dataLength));
                            }
                            int flowSetLimit = flowSetEnd - template.dataLength;
                            while (offset <= flowSetLimit) {
                                processor.process(readBuffer, offset, millis, template);
                                offset += template.dataLength;
                            }
                        }
                    } else if (flowSetId == 0) {
                        if (log.isTraceEnabled()) {
                            log.trace((Object)"Template flowset!");
                        }
                        readBuffer.position(offset);
                        offset += 4;
                        while (offset < flowSetEnd) {
                            templateId = readBuffer.getShort(offset) & 0xFFFF;
                            template = new NetFlow9Template();
                            readBuffer.position(offset);
                            template.parse(readBuffer);
                            templates.put(templateId, template);
                            offset += template.length;
                        }
                        if (log.isTraceEnabled()) {
                            log.trace((Object)("Offset: " + offset));
                        }
                    }
                    offset = flowSetEnd;
                }
                offset = packetEnd;
            }
        }
        finally {
            if (offset >= readBuffer.limit()) {
                offset = readBuffer.limit();
            }
            readBuffer.position(offset);
        }
        return offset;
    }
}

