/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.network.dhcp;

import java.nio.ByteBuffer;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.network.dhcp.DhcpListener;
import ru.bitel.bgbilling.kernel.network.dhcp.DhcpProcessor;
import ru.bitel.bgbilling.kernel.network.dhcp.datalog.DhcpDataLogWriter;
import ru.bitel.bgbilling.kernel.network.dhcp.datalog.hourly.DhcpHourlyDataLogEntry;
import ru.bitel.bgbilling.kernel.network.dhcp.datalog.hourly.DhcpHourlyDataLogger;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.model.Idable;

public class DhcpListenerWorkerContext
extends ServerContext {
    private static final Logger logger = Logger.getLogger(DhcpListenerWorkerContext.class);
    protected final DhcpListener listener;
    protected final DhcpProcessor<Idable> processor;
    protected final DhcpHourlyDataLogger dataLogger;
    protected long currentHourPart = Long.MIN_VALUE;
    protected ConcurrentHashMap<Integer, DhcpHourlyDataLogEntry> hourEntryMap;
    protected final WeakHashMap<DhcpHourlyDataLogEntry, DhcpDataLogWriter> writerMap = new WeakHashMap();

    public DhcpListenerWorkerContext(Setup setup, int moduleId, DhcpListener listener, DhcpProcessor<Idable> processor, DhcpHourlyDataLogger dataLogger) {
        super(setup, moduleId, -1);
        this.listener = listener;
        this.processor = processor;
        this.dataLogger = dataLogger;
    }

    public final void writeRecord(Idable device, int[] positions, ByteBuffer data, long now) {
        if (this.dataLogger == null) {
            return;
        }
        Long hourPart = this.dataLogger.getHourPart(now);
        if (hourPart != this.currentHourPart) {
            this.hourEntryMap = this.dataLogger.getForHourPart(hourPart);
            this.currentHourPart = hourPart;
        }
        long currentHour = now / 3600000L * 3600000L;
        DhcpDataLogWriter writer = this.dataLogger.getWriter(this.hourEntryMap, this.writerMap, currentHour, device);
        try {
            writer.writeRecord(data, now, positions);
        }
        catch (Exception e) {
            logger.error((Object)"IOException", (Throwable)e);
        }
    }

    public DhcpListener getListener() {
        return this.listener;
    }

    public DhcpProcessor<Idable> getProcessor() {
        return this.processor;
    }
}

