/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.loader.server.utils;

import bitel.billing.server.contract.bean.BalanceUtils;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Calendar;
import java.util.Date;
import org.apache.log4j.Logger;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Charge;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Payment;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.ChargeDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.PaymentDao;
import ru.bitel.bgbilling.kernel.contract.loader.server.bean.LoaderUtil;
import ru.bitel.bgbilling.kernel.contract.loader.server.utils.LoaderBase;
import ru.bitel.bgbilling.kernel.contract.param.common.bean.ContractParameterPrefType;
import ru.bitel.common.TimeUtils;

public class LoaderBalanceUpdateUtil
extends LoaderBase
implements LoaderUtil {
    private Logger log = Logger.getLogger((String)LoaderBalanceUpdateUtil.class.getName());

    @Override
    public String execute(String data, String config) throws BGException {
        JSONObject configJsonObject = new JSONObject(config);
        int parameterId = configJsonObject.optInt("parameterId", 0);
        Calendar cal = TimeUtils.parseCalendar(configJsonObject.optString("date"), "dd.MM.yyyy");
        int chargeTypeId = configJsonObject.optInt("chargeTypeId");
        int paymentTypeId = configJsonObject.optInt("paymentTypeId");
        Date now = new Date();
        String tableName = ContractParameterPrefType.TYPE_TEXT.getTableName();
        try (ChargeDao chargeDao = new ChargeDao(this.con);
             PaymentDao paymentDao = new PaymentDao(this.con);
             BalanceUtils balanceUtils = new BalanceUtils(this.con);){
            cal.set(5, 1);
            Date date = cal.getTime();
            int parameterIndex = 1;
            PreparedStatement psSelect = this.con.prepareStatement("SELECT * FROM " + tableName + " WHERE pid=?");
            psSelect.setInt(parameterIndex, parameterId);
            ResultSet resultSet = psSelect.executeQuery();
            while (resultSet.next()) {
                int result;
                int contractId = resultSet.getInt("cid");
                String val = resultSet.getString("val");
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("contractId = " + contractId));
                    this.log.debug((Object)("inVal = " + val));
                }
                val = val.trim().replace(" ", "").replace(',', '.');
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("outVal = " + val));
                }
                BigDecimal sum = new BigDecimal(val);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("contractId = " + contractId));
                    this.log.debug((Object)("sum = " + sum.toPlainString()));
                }
                if ((result = sum.compareTo(BigDecimal.ZERO)) == -1) {
                    Charge charge = new Charge(-1, 0, contractId, chargeTypeId, date, "", sum.negate(), now);
                    chargeDao.update(charge);
                    balanceUtils.updateBalance(date, contractId);
                    continue;
                }
                if (result != 1) continue;
                Payment payment = new Payment(-1, 0, contractId, paymentTypeId, date, "", sum, now);
                paymentDao.update(payment);
                balanceUtils.updateBalance(date, contractId);
            }
            resultSet.close();
            psSelect.close();
        }
        catch (Exception e) {
            this.log.error((Object)e);
            throw new BGException(e);
        }
        return null;
    }
}

