/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.api.server.service;

import bitel.billing.server.contract.bean.Contract;
import bitel.billing.server.contract.bean.ContractManager;
import bitel.billing.server.contract.bean.ContractStatus;
import bitel.billing.server.contract.bean.ContractStatusManager;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.jws.WebService;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.contract.api.common.service.ContractStatusService;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractStatusDao;
import ru.bitel.bgbilling.kernel.contract.runtime.ContractRuntimeMap;
import ru.bitel.bgbilling.kernel.contract.status.common.bean.Status;
import ru.bitel.bgbilling.kernel.contract.status.server.ServerStatusUtil;
import ru.bitel.bgbilling.kernel.contract.status.server.StatusCache;
import ru.bitel.bgbilling.kernel.contract.status.server.WebStatusChangeRules;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.events.GetContractStatusChangeDatesEvent;
import ru.bitel.bgbilling.server.util.ClosedDateChecker;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.model.MapHolder;

@WebService(endpointInterface="ru.bitel.bgbilling.kernel.contract.api.common.service.ContractStatusService")
public class ContractStatusServiceImpl
extends AbstractService
implements ContractStatusService {
    @Override
    public List<Status> statusList() throws BGException {
        return StatusCache.getInstance().getStatusList();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractStatus> contractStatusList(int contractId, Date date) throws BGException {
        try (ContractStatusDao contractStatusDao = new ContractStatusDao(this.getConnection());){
            List<ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractStatus> list = contractStatusDao.list(contractId, date);
            return list;
        }
        catch (Exception ex) {
            throw new BGException(ex);
        }
    }

    @Override
    public ContractStatusService.ContractStatusChangeParameters contractStatusChangeParametersGet(int contractId) throws BGException {
        Date curdate = new Date();
        WebStatusChangeRules changeRules = StatusCache.getInstance().getWebStatusChangeRules();
        Set<Integer> changeableStatusSet = changeRules.getChangeableStatusIds();
        int status = ContractRuntimeMap.getInstance().getContractRuntime(this.getConnectionSet(), (Integer)contractId).getStatus();
        GetContractStatusChangeDatesEvent dateListEvent = new GetContractStatusChangeDatesEvent(this.userId, contractId, status, curdate);
        dateListEvent = EventProcessor.getInstance().request(dateListEvent);
        List<Date> changeDateList = dateListEvent.getDateList();
        Calendar changeFrom = TimeUtils.convertDateToCalendar(changeRules.getFromStatusChangeDate(status));
        if (changeDateList != null) {
            ArrayList<Date> _changeDateList = new ArrayList<Date>();
            for (Date date : changeDateList) {
                _changeDateList.add(TimeUtils.clear_HOUR_MIN_MIL_SEC(date));
            }
            changeDateList = _changeDateList;
        }
        ContractStatusService.ContractStatusChangeParameters result = new ContractStatusService.ContractStatusChangeParameters();
        result.setChangeableStatuses(changeableStatusSet);
        if (changeDateList != null) {
            if (!changeDateList.isEmpty()) {
                result.setDateList(changeDateList);
            }
        } else {
            result.setDate(changeFrom != null ? changeFrom.getTime() : null);
        }
        boolean hasFutureChange = false;
        boolean hasManyFutureChanges = false;
        boolean canCancel = false;
        ContractStatusDao contractStatusDao = new ContractStatusDao(this.getConnection());
        for (ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractStatus contractStatus : contractStatusDao.list(contractId, null)) {
            if (!TimeUtils.dateBefore(curdate, contractStatus.getDateFrom())) continue;
            if (hasFutureChange) {
                canCancel = false;
                hasManyFutureChanges = true;
                break;
            }
            hasFutureChange = true;
            if (!changeableStatusSet.contains(contractStatus.getStatus())) continue;
            canCancel = true;
        }
        contractStatusDao.close();
        result.setHasFutureChange(hasFutureChange);
        result.setHasManyFutureChanges(hasManyFutureChanges);
        result.setCanCancel(canCancel);
        return result;
    }

    @Override
    public MapHolder<String, String> contractStatusChange(int contractId, ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractStatus contractStatus, boolean customer, boolean confirmChecked) throws BGException {
        if (contractStatus == null || contractStatus.getStatus() < 0) {
            throw new BGIllegalArgumentException("contractStatus");
        }
        if (contractStatus.getContractId() <= 0 || contractStatus.getContractId() != contractId) {
            throw new BGIllegalArgumentException("contractId");
        }
        if (contractStatus.getDateFrom() == null) {
            throw new BGMessageException("\u041d\u0435 \u0437\u0430\u0434\u0430\u043d\u0430 \u0434\u0430\u0442\u0430.", "contractStatusChange.dateFrom");
        }
        if (contractStatus.getDateTo() != null && !TimeUtils.dateBeforeOrEq(contractStatus.getDateFrom(), contractStatus.getDateTo())) {
            throw new BGMessageException("\u0423\u043a\u0430\u0437\u0430\u043d \u043d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u043f\u0435\u0440\u0438\u043e\u0434", "contractStatusChange.wrongPeriod");
        }
        HashMap<String, String> result = new HashMap<String, String>();
        if (!ServerStatusUtil.checkStatusChange(contractId, contractStatus, confirmChecked, result)) {
            return new MapHolder<String, String>(result);
        }
        if (!customer) {
            Calendar closedDate = null;
            closedDate = ClosedDateChecker.getClosePeriodDateIfChecking("ActionContractStatusChange", 0, this.userId);
            if (closedDate != null) {
                ClosedDateChecker.checkDatesForUpdate(closedDate, null, null, contractStatus.getDateFrom(), contractStatus.getDateTo());
            }
            ContractStatusManager statusManager = new ContractStatusManager(this.getConnection());
            contractStatus.setId(0);
            statusManager.changeStatus(new ContractStatus(contractStatus), this.userId);
            statusManager.recycle();
            result.put("statusId", String.valueOf(contractStatus.getId()));
            return new MapHolder<String, String>(result);
        }
        return this.contractStatusChangeByCustomer(contractStatus);
    }

    private MapHolder<String, String> contractStatusChangeByCustomer(ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractStatus contractStatus) throws BGException {
        if (contractStatus.getDateTo() != null) {
            throw new BGMessageException("\u0414\u0430\u043d\u043d\u044b\u0439 \u043f\u0435\u0440\u0435\u0445\u043e\u0434 \u0437\u0430\u043f\u0440\u0435\u0449\u0451\u043d.", "contractStatusChange.forbidden");
        }
        WebStatusChangeRules changeRules = StatusCache.getInstance().getWebStatusChangeRules();
        ContractManager contractManager = new ContractManager(this.getConnection());
        Contract contract = contractManager.getContractById(contractStatus.getContractId());
        contractManager.close();
        int currentStatus = contract.getStatus();
        Date curdate = new Date();
        ContractStatusService.ContractStatusChangeParameters changeParams = this.contractStatusChangeParametersGet(contractStatus.getContractId());
        if (TimeUtils.dateEqual(contractStatus.getDateFrom(), curdate) && currentStatus == contractStatus.getStatus()) {
            contractStatus.setDateTo(null);
            if (!changeParams.isCanCancel()) {
                if (changeParams.isHasFutureChange()) {
                    throw new BGMessageException("\u0417\u0430\u043f\u043b\u0430\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0430 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0430 \u043d\u0435\u043f\u0435\u0440\u0435\u043a\u0440\u044b\u0432\u0430\u0435\u043c\u043e\u0433\u043e \u0441\u0442\u0430\u0442\u0443\u0441\u0430.", "contractStatusChangeCancel.blockedByFutureChange");
                }
                if (changeParams.isHasManyFutureChanges()) {
                    throw new BGMessageException("\u0417\u0430\u043f\u043b\u0430\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0430 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0430 \u043d\u0435\u043f\u0435\u0440\u0435\u043a\u0440\u044b\u0432\u0430\u0435\u043c\u043e\u0433\u043e \u0441\u0442\u0430\u0442\u0443\u0441\u0430.", "contractStatusChangeCancel.blockedByFutureChange");
                }
                throw new BGMessageException("\u0422\u0435\u043a\u0443\u0449\u0438\u0439 \u0441\u0442\u0430\u0442\u0443\u0441 \u0441\u043e\u0432\u043f\u0430\u0434\u0430\u0435\u0442 \u0441\u043e \u0441\u043c\u0435\u043d\u044f\u0435\u043c\u044b\u043c.", "contractStatusChangeCancel.notFound");
            }
        } else {
            if (!changeRules.isStatusChangeAllow(currentStatus, contractStatus.getStatus())) {
                throw new BGMessageException("\u0414\u0430\u043d\u043d\u044b\u0439 \u043f\u0435\u0440\u0435\u0445\u043e\u0434 \u0437\u0430\u043f\u0440\u0435\u0449\u0451\u043d.", "contractStatusChange.forbidden");
            }
            if (changeParams.isHasFutureChange()) {
                throw new BGMessageException("\u0421\u043c\u0435\u043d\u0430 \u0441\u0442\u0430\u0442\u0443\u0441\u0430 \u0443\u0436\u0435 \u043f\u0440\u0438\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442.", "contractStatusChange.hasFutureChange");
            }
            if (changeParams.getDateList() != null && changeParams.getDateList().size() > 0) {
                if (!changeParams.getDateList().contains(contractStatus.getDateFrom())) {
                    throw new BGMessageException("\u041f\u0435\u0440\u0435\u0445\u043e\u0434 \u0441 \u0434\u0430\u043d\u043d\u043e\u0439 \u0434\u0430\u0442\u044b \u0437\u0430\u043f\u0440\u0435\u0449\u0451\u043d.", "contractStatusChange.dateFrom.forbidden");
                }
            } else if (changeParams.getDate() != null) {
                if (!TimeUtils.dateBeforeOrEq(changeParams.getDate(), contractStatus.getDateFrom())) {
                    throw new BGMessageException("\u041f\u0435\u0440\u0435\u0445\u043e\u0434 \u0441 \u0434\u0430\u043d\u043d\u043e\u0439 \u0434\u0430\u0442\u044b \u0437\u0430\u043f\u0440\u0435\u0449\u0451\u043d.", "contractStatusChange.dateFrom.forbidden");
                }
            } else {
                throw new BGMessageException("\u041f\u0435\u0440\u0435\u0445\u043e\u0434 \u0441 \u0434\u0430\u043d\u043d\u043e\u0439 \u0434\u0430\u0442\u044b \u0437\u0430\u043f\u0440\u0435\u0449\u0451\u043d.", "contractStatusChange.dateFrom.forbidden");
            }
        }
        Calendar closedDate = null;
        closedDate = ClosedDateChecker.getClosePeriodDateIfChecking("ActionContractStatus", 0, -1);
        if (closedDate != null) {
            ClosedDateChecker.checkDatesForUpdate(closedDate, null, null, contractStatus.getDateFrom(), contractStatus.getDateTo());
        }
        ContractStatusManager statusManager = new ContractStatusManager(this.getConnection());
        contractStatus.setId(0);
        statusManager.changeStatus(new ContractStatus(contractStatus), -1);
        statusManager.recycle();
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("statusId", String.valueOf(contractStatus.getId()));
        return new MapHolder<String, String>(result);
    }

    @Override
    public List<Status> getStatusList(boolean onlyManual) throws BGException, BGMessageException {
        List<Status> statusList = null;
        statusList = onlyManual ? StatusCache.getInstance().getManualStatusList() : StatusCache.getInstance().getStatusList();
        return statusList;
    }
}

