/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.api.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractTariff;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.dao.AbstractIdDao;
import ru.bitel.common.model.Period;

public class ContractTariffDao
extends AbstractIdDao<ContractTariff> {
    public ContractTariffDao(Connection con) {
        super(con, 0, "contract_tariff");
    }

    @Override
    protected ContractTariff getFromRS(ResultSet rs) throws SQLException, BGException {
        ContractTariff result = new ContractTariff();
        result.setId(rs.getInt("id"));
        result.setContractId(rs.getInt("cid"));
        result.setPeriod(new Period(TimeUtils.convertSqlDateToDate(rs.getDate("date1")), TimeUtils.convertSqlDateToDate(rs.getDate("date2"))));
        result.setTariffPlanId(rs.getInt("tpid"));
        result.setTariffGroupId(rs.getInt("tariff_group_id"));
        result.setComment(rs.getString("comment"));
        result.setPosition(rs.getInt("pos"));
        result.setEntityMid(rs.getInt("emid"));
        result.setEntityId(rs.getInt("eid"));
        result.setReplacedFromContractTariffId(rs.getInt("replaced_from"));
        return result;
    }

    @Override
    protected void updateImpl(ContractTariff contractTariff) throws BGException, SQLException {
        boolean insert = contractTariff.getId() < 1;
        String query = (insert ? "INSERT INTO " : "UPDATE ") + this.tableName + " SET cid=?, date1=?, date2=?, tpid=?, comment=?, pos=?, emid=?, eid=?, replaced_from=?, tariff_group_id=?" + (insert ? "" : " WHERE id=?");
        PreparedStatement ps = this.con.prepareStatement(query, 1);
        int parameterIndex = 1;
        ps.setInt(parameterIndex++, contractTariff.getContractId());
        ps.setDate(parameterIndex++, TimeUtils.convertDateToSqlDate(contractTariff.getPeriod().getDateFrom()));
        ps.setDate(parameterIndex++, TimeUtils.convertDateToSqlDate(contractTariff.getPeriod().getDateTo()));
        ps.setInt(parameterIndex++, contractTariff.getTariffPlanId());
        ps.setString(parameterIndex++, contractTariff.getComment());
        ps.setInt(parameterIndex++, contractTariff.getPosition());
        ps.setInt(parameterIndex++, contractTariff.getEntityMid());
        ps.setInt(parameterIndex++, contractTariff.getEntityId());
        ps.setInt(parameterIndex++, contractTariff.getReplacedFromContractTariffId());
        ps.setInt(parameterIndex++, contractTariff.getTariffGroupId());
        if (!insert) {
            ps.setInt(parameterIndex++, contractTariff.getId());
        }
        ps.executeUpdate();
        if (insert) {
            contractTariff.setId(ServerUtils.lastInsertId(ps));
        }
        ps.close();
    }

    public List<ContractTariff> list(int cid, Date date) throws BGException {
        return this.list(cid, date, 0, 0);
    }

    public List<ContractTariff> list(int cid, Date date, int emid, int eid) throws BGException {
        ArrayList<ContractTariff> result = new ArrayList<ContractTariff>();
        try {
            String query = "SELECT * FROM " + this.tableName + " WHERE cid=? AND " + (emid >= 0 ? "emid=" + emid + " AND eid=" + eid : "emid=0 AND eid=0") + " AND ( ? IS NULL OR (( date1 IS NULL OR date1<=? ) AND ( date2 IS NULL OR date2>=? )) ) ORDER BY date1";
            PreparedStatement ps = this.con.prepareStatement(query);
            java.sql.Date sqlDate = TimeUtils.convertDateToSqlDate(date);
            ps.setInt(1, cid);
            ps.setDate(2, sqlDate);
            ps.setDate(3, sqlDate);
            ps.setDate(4, sqlDate);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(this.getFromRS(rs));
            }
            rs.close();
            ps.close();
        }
        catch (Exception ex) {
            throw new BGException(ex);
        }
        return result;
    }

    public ContractTariff getFirst(int cid, Date date) throws BGException {
        ContractTariff result = null;
        List<ContractTariff> list = this.list(cid, date);
        if (list.size() > 0) {
            result = list.get(0);
        }
        return result;
    }

    public boolean checkDoubleTariffForContract(int cid, int tpid, Calendar date1, Calendar date2) {
        try {
            String query = "SELECT * FROM " + this.tableName + " WHERE cid=? AND tpid=? AND (date1 IS NULL OR ? IS NULL OR date1<=?) AND (date2 IS NULL OR ? IS NULL OR ?<=date2)";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, cid);
            ps.setInt(2, tpid);
            ps.setDate(3, TimeUtils.convertCalendarToSqlDate(date2));
            ps.setDate(4, TimeUtils.convertCalendarToSqlDate(date2));
            ps.setDate(5, TimeUtils.convertCalendarToSqlDate(date1));
            ps.setDate(6, TimeUtils.convertCalendarToSqlDate(date1));
            ResultSet rs = ps.executeQuery();
            boolean result = rs.next();
            ps.close();
            return result;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    @Override
    public void update(ContractTariff b2) throws BGException {
        super.update(b2);
    }
}

