/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.container.ws.server;

import bitel.billing.server.admin.bgsecure.bean.UserLoginModule;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.util.VersionUtil;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.util.StdDateFormat;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.jws.WebParam;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginException;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.ws.Holder;
import org.apache.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.container.security.server.ModuleAction;
import ru.bitel.bgbilling.kernel.container.service.server.ServiceInfo;
import ru.bitel.bgbilling.kernel.container.ws.server.JaxWsHandler;
import ru.bitel.bgbilling.kernel.container.ws.server.ModuleKey;
import ru.bitel.bgbilling.kernel.module.common.bean.User;
import ru.bitel.common.Utils;
import ru.bitel.common.worker.ThreadContext;

public class JsonWsHandler
extends JaxWsHandler {
    private static final Logger log = Logger.getLogger(JsonWsHandler.class);
    public static final String URL_PREFIX = "/json";
    private static final int URL_PREFIX_LENGTH = "/json".length();
    protected static final ObjectMapper mapper = new ObjectMapper();

    public JsonWsHandler(ServletContext context) throws BGException {
        super(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean handle(HttpServletRequest request, HttpServletResponse response) {
        ModuleKey moduleKey = ModuleKey.getModuleKey(request.getPathInfo().substring(URL_PREFIX_LENGTH));
        if (moduleKey != null) {
            try {
                String requestBody = new String(Utils.readByBlock((InputStream)request.getInputStream()), "UTF-8");
                JsonNode root = mapper.readTree(requestBody);
                JsonResponse jsonResponse = new JsonResponse();
                try {
                    String method;
                    Integer userId;
                    long time = System.currentTimeMillis();
                    HttpSession httpSession = request.getSession(false);
                    Subject subject = httpSession != null ? (Subject)httpSession.getAttribute("subject") : null;
                    Integer n = userId = httpSession != null ? (Integer)httpSession.getAttribute("user_id") : null;
                    if (subject == null) {
                        String user = "";
                        String pswd = "";
                        JsonNode userNode = root.get("user");
                        if (userNode == null) {
                            throw new LoginException("\u041d\u0435 \u043f\u0435\u0440\u0435\u0434\u0430\u043d \u044d\u043b\u0435\u043c\u0435\u043d\u0442 user");
                        }
                        user = (String)mapper.convertValue((Object)userNode.get("user"), String.class);
                        pswd = (String)mapper.convertValue((Object)userNode.get("pswd"), String.class);
                        ((ObjectNode)userNode).put("pswd", "********");
                        if (Utils.isBlankString(user) || Utils.isBlankString(pswd)) {
                            throw new LoginException("\u041d\u0435 \u043f\u0435\u0440\u0435\u0434\u0430\u043d\u044b \u0430\u0442\u0440\u0438\u0431\u0443\u0442\u044b 'user' \u043b\u0438\u0431\u043e 'pswd'");
                        }
                        subject = this.login(user, pswd, httpSession);
                        userId = UserLoginModule.getUser(subject).getId();
                    }
                    if (Utils.isBlankString(method = root.get("method").asText())) {
                        throw new BGException("\u041f\u043e\u043b\u0435 'method' \u043d\u0435 \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u043e");
                    }
                    Class<?> implementorClass = this.findEndpointClass(moduleKey);
                    if (implementorClass == null) {
                        throw new BGException("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0441\u0435\u0440\u0432\u0438\u0441: " + moduleKey.module + ":" + moduleKey.service);
                    }
                    Method mIface = this.getMethodByName(this.findInterfaceClass(moduleKey.service, implementorClass), method);
                    Method mImpl = this.getMethodImpl(implementorClass, mIface);
                    JsonNode params = root.get("params");
                    Args args = this.fillArgs(params, root, mIface, mImpl);
                    Integer contractId = null;
                    try {
                        contractId = (Integer)mapper.convertValue((Object)params.get("cid"), Integer.class);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (contractId == null) {
                        contractId = (Integer)mapper.convertValue((Object)params.get("contractId"), Integer.class);
                    }
                    if (contractId == null) {
                        contractId = 0;
                    }
                    String[] midRef = new String[]{String.valueOf(moduleKey.moduleId)};
                    ModuleAction moduleAction = this.permissionChecker.findAction(midRef, moduleKey.service, method, args.namedArgs);
                    if (this.requestCheckAuthorization && userId != 1) {
                        this.permissionChecker.checkActionAllow(userId, String.valueOf(moduleKey.moduleId), moduleAction, moduleKey.service, method, contractId, args.namedArgs);
                    }
                    this.logRequest(request, userId, contractId, midRef, moduleAction, moduleKey.service, method, root);
                    ServiceInfo<?> helper = ServiceInfo.getServiceHelper(implementorClass);
                    Object parent = ThreadContext.get();
                    ServerContext ctx = null;
                    try {
                        ctx = new ServerContext(this.setup, moduleKey.moduleId, userId);
                        ctx.init();
                        ThreadContext.set(ctx);
                        Object result = helper.invoke(ctx, this.setup, implementorClass.newInstance(), mImpl, args.args, moduleKey.moduleId, userId);
                        jsonResponse.setDataReturn(result);
                        for (Map.Entry me : args.returnArgs.entrySet()) {
                            jsonResponse.setData((String)me.getKey(), ((Holder)me.getValue()).value);
                        }
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("executing " + implementorClass.getName() + "." + mImpl.getName() + "; time => " + (System.currentTimeMillis() - time) + " ms."));
                        }
                    }
                    finally {
                        if (ctx != null) {
                            ctx.destroy();
                        }
                        ThreadContext.set(parent);
                    }
                }
                catch (InvocationTargetException e) {
                    Throwable cause = e.getCause();
                    if (cause instanceof BGException) {
                        jsonResponse.setError(cause.getClass().getName(), cause.getMessage(), ((BGException)cause).getTag());
                    } else {
                        jsonResponse.setError(cause.getClass().getName(), cause.getMessage());
                    }
                    if (!(cause instanceof BGMessageException)) {
                        log.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
                catch (Throwable e) {
                    jsonResponse.setError(e.getClass().getName(), e.getMessage());
                    log.error((Object)e.getMessage(), e);
                }
                finally {
                    mapper.writeValue((OutputStream)response.getOutputStream(), (Object)jsonResponse);
                }
            }
            catch (IOException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            return true;
        }
        return false;
    }

    private Subject login(String userName, String userPswd, HttpSession session) throws LoginException {
        Subject subject = UserLoginModule.auth(this.loginContextName, userName, userPswd);
        User user = UserLoginModule.getUser(subject);
        if (session != null) {
            session.setAttribute("user_id", (Object)user.getId());
            session.setAttribute("subject", (Object)subject);
        }
        return subject;
    }

    protected Args fillArgs(JsonNode params, JsonNode root, Method mIface, Method mImpl) {
        Type[] parameterTypes = mImpl.getGenericParameterTypes();
        int paramListLength = parameterTypes.length;
        Object[] args = new Object[paramListLength];
        HashMap<String, Object> map = new HashMap<String, Object>(paramListLength);
        HashMap<String, Holder> returnMap = new HashMap<String, Holder>();
        Parameter[] parameters = mIface.getParameters();
        Annotation[][] paramsAnnotations = mIface.getParameterAnnotations();
        for (int i = 0; i < paramListLength; ++i) {
            WebParam wp = null;
            Type type = parameterTypes[i];
            String paramName = null;
            Annotation[] paramAnnotations = paramsAnnotations[i];
            if (paramAnnotations.length == 1) {
                wp = (WebParam)paramAnnotations[0];
                paramName = wp.name();
            } else {
                paramName = parameters[i].getName();
            }
            JsonNode paramValue = params.get(paramName);
            if (wp != null && (wp.mode() == WebParam.Mode.INOUT || wp.mode() == WebParam.Mode.OUT)) {
                Type t = ((ParameterizedType)type).getActualTypeArguments()[0];
                Class clazz = t instanceof ParameterizedType ? (Class)((ParameterizedType)t).getRawType() : (Class)t;
                Object value = mapper.convertValue((Object)paramValue, clazz);
                Holder holder = new Holder(value);
                args[i] = holder;
                returnMap.put(paramName, holder);
                continue;
            }
            if (paramValue == null) continue;
            Object javaType = null;
            if (type instanceof ParameterizedType) {
                ParameterizedType pType = (ParameterizedType)type;
                Class rawType = (Class)pType.getRawType();
                Type[] actualTypes = pType.getActualTypeArguments();
                int size = actualTypes.length;
                Class[] actualTypeArgClasses = new Class[size];
                for (int c = 0; c < size; ++c) {
                    actualTypeArgClasses[c] = (Class)actualTypes[c];
                }
                javaType = mapper.getTypeFactory().constructParametricType(rawType, actualTypeArgClasses);
            } else {
                Class clazz = (Class)type;
                javaType = clazz.isArray() ? mapper.getTypeFactory().constructArrayType(clazz.getComponentType()) : mapper.getTypeFactory().constructType((Type)clazz);
            }
            args[i] = mapper.convertValue((Object)paramValue, javaType);
            map.put(paramName, args[i]);
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)(paramName + " (" + i + ") => " + javaType + " => " + args[i]));
        }
        return new Args(args, map, returnMap);
    }

    static {
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.setDateFormat((DateFormat)((Object)new BitelJsonDateFormat()));
        final Version VERSION = VersionUtil.parseVersion((String)"2.4.1", (String)"com.fasterxml.jackson.module", (String)"jackson-module-bitel-jaxb-annotations");
        AnnotationIntrospector introspector = new AnnotationIntrospector(){

            public Version version() {
                return VERSION;
            }

            public boolean hasIgnoreMarker(AnnotatedMember m) {
                return m.getAnnotation(XmlTransient.class) != null;
            }

            public PropertyName findNameForSerialization(Annotated a2) {
                XmlAttribute pann = (XmlAttribute)a2.getAnnotation(XmlAttribute.class);
                if (pann != null) {
                    if (Utils.notBlankString(pann.name()) && !"##default".equals(pann.name())) {
                        return new PropertyName(pann.name());
                    }
                    return PropertyName.USE_DEFAULT;
                }
                XmlElement el = (XmlElement)a2.getAnnotation(XmlElement.class);
                XmlElements els = (XmlElements)a2.getAnnotation(XmlElements.class);
                if (el != null || els != null) {
                    return PropertyName.USE_DEFAULT;
                }
                return null;
            }

            public PropertyName findNameForDeserialization(Annotated a2) {
                return this.findNameForSerialization(a2);
            }
        };
        mapper.setAnnotationIntrospector(AnnotationIntrospector.pair((AnnotationIntrospector)new JacksonAnnotationIntrospector(), (AnnotationIntrospector)introspector));
    }

    protected static final class Args {
        private final Object[] args;
        private final Map<String, Object> namedArgs;
        private final Map<String, Holder<Object>> returnArgs;

        private Args(Object[] args, Map<String, Object> namedArgs, Map<String, Holder<Object>> returnArgs) {
            this.args = args;
            this.namedArgs = namedArgs;
            this.returnArgs = returnArgs;
        }
    }

    private static class BitelJsonDateFormat
    extends StdDateFormat {
        private static final String BITEL_FORMAT = "yyyy-MM-dd'T'HH:mm:ssXXX";

        public BitelJsonDateFormat() {
            this.setTimeZone(TimeZone.getDefault());
        }

        private BitelJsonDateFormat(TimeZone tz, Locale loc) {
            super(tz, loc);
        }

        protected Date parseAsISO8601(String dateStr, ParsePosition pos) {
            Date result = new SimpleDateFormat(BITEL_FORMAT).parse(dateStr, pos);
            if (result == null) {
                try {
                    return super.parseAsISO8601(dateStr, pos);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
            }
            return result;
        }

        public StringBuffer format(Date date, StringBuffer toAppendTo, FieldPosition fieldPosition) {
            return new SimpleDateFormat(BITEL_FORMAT).format(date, toAppendTo, fieldPosition);
        }

        public BitelJsonDateFormat clone() {
            return new BitelJsonDateFormat(this._timezone, this._locale);
        }
    }

    public static class JsonResponse {
        public static final String STATUS_OK = "ok";
        public static final String STATUS_ERROR = "error";
        private String status = "ok";
        private String exception;
        private String message = "";
        private String tag = null;
        private Map<String, Object> data = new HashMap<String, Object>();

        public String getStatus() {
            return this.status;
        }

        public void setError(String exception, String error) {
            this.status = STATUS_ERROR;
            this.exception = exception;
            this.message = error;
        }

        public void setError(String exception, String error, String tag) {
            this.status = STATUS_ERROR;
            this.exception = exception;
            this.message = error;
            this.tag = tag;
        }

        public String getMessage() {
            return this.message;
        }

        public String getTag() {
            return this.tag;
        }

        public String getException() {
            return this.exception;
        }

        public Map<String, Object> getData() {
            return this.data;
        }

        public void setDataReturn(Object data) {
            this.data.put("return", data);
        }

        public void setData(String key, Object data) {
            this.data.put(key, data);
        }
    }
}

