/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.container.service.server;

import java.sql.Connection;
import ru.bitel.bgbilling.kernel.container.managed.ContainerContext;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.sql.ConnectionSet;
import ru.bitel.common.worker.ThreadContext;

public abstract class AbstractService {
    protected ServerContext context;
    protected int moduleId;
    protected int userId;
    ConnectionSet connectionSet;
    Setup setup;
    ParameterMap moduleSetup;

    private AbstractService(Setup setup, ParameterMap moduleSetup, ConnectionSet connectionSet, int moduleId, int userId) {
        this.setup = setup;
        this.moduleId = moduleId;
        this.connectionSet = connectionSet;
        this.moduleSetup = moduleSetup == null && moduleId > 0 ? setup.getModuleSetup(moduleId) : moduleSetup;
        this.userId = userId;
    }

    private AbstractService(ConnectionSet connectionSet, int moduleId) {
        ContainerContext cc = (ContainerContext)ThreadContext.get();
        this.moduleId = moduleId;
        this.userId = cc.getUserId();
        this.connectionSet = connectionSet;
        this.setup = cc.getSetup();
        this.moduleSetup = cc.getModuleSetup();
    }

    public AbstractService() {
    }

    protected Setup getSetup() {
        return this.setup;
    }

    protected ParameterMap getModuleSetup() {
        if (this.moduleSetup == null && this.moduleId > 0) {
            this.moduleSetup = this.getSetup().getModuleSetup(this.moduleId);
        }
        return this.moduleSetup;
    }

    protected void resetModuleSetup() {
        this.moduleSetup = null;
    }

    protected Connection getConnection() {
        return this.connectionSet.getConnection();
    }

    protected Connection getSlaveConnection() {
        return this.connectionSet.getSlaveConnection();
    }

    protected Connection getTrashConnection(String tableName, int defaultType) {
        return this.connectionSet.getTrashConnection(tableName, defaultType);
    }

    protected ConnectionSet getConnectionSet() {
        return this.connectionSet;
    }
}

