/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.bgsecure.server.bean;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.bgsecure.common.bean.ActionLogEntry;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.bgbilling.server.util.UserMap;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.dao.AbstractIdDao;

public class BGActionLogManager
extends AbstractIdDao<ActionLogEntry> {
    private static final String TABLE = "server_current_actions";

    public BGActionLogManager() {
        super(Setup.getSetup().getDBTrashConnectionFromPool(TABLE, 0), 0, TABLE);
    }

    public boolean isConnectionActive() {
        return ServerUtils.tableExists(this.con, TABLE);
    }

    @Override
    protected ActionLogEntry getFromRS(ResultSet rs) throws SQLException, BGException {
        ActionLogEntry qu = new ActionLogEntry();
        qu.setId(rs.getInt("id"));
        qu.setAction(rs.getString("action"));
        qu.setQuery(rs.getString("query"));
        qu.setUserId(rs.getInt("uid"));
        qu.setModuleId(rs.getInt("mid"));
        qu.setModuleTitle(rs.getString("m_title"));
        return qu;
    }

    @Override
    protected void updateImpl(ActionLogEntry qlm) throws BGException, SQLException {
        if (qlm.getId() > 0) {
            return;
        }
        String query = "INSERT INTO " + this.tableName + " (action, query, uid, u_name, m_title, dtime ) VALUES(?, ?, ?, ?, ?, ?)";
        PreparedStatement ps = this.con.prepareStatement(query);
        ps.setString(1, qlm.getAction());
        ps.setString(2, qlm.getQuery());
        ps.setInt(3, qlm.getUserId());
        ps.setString(4, UserMap.getUser(qlm.getUserId()).getName());
        ps.setString(5, qlm.getModuleTitle());
        ps.setTimestamp(6, TimeUtils.convertDateToTimestamp(qlm.getDatetime()));
        ps.executeUpdate();
        qlm.setId(ServerUtils.lastInsertId(this.con));
        ps.close();
    }

    public void closeConnection() {
        ServerUtils.closeConnection(this.con);
    }
}

