/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.auth;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.List;
import ru.bitel.bgbilling.kernel.auth.ModuleUser;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.server.util.Setup;

public class ModuleAuth
implements bitel.billing.server.ModuleAuth {
    @Override
    public ModuleUser findModuleUserByLogin(String login, int moduleId, int authMode, Connection con) {
        ModuleUser moduleUser = null;
        if (login != null && login.trim().length() > 0 && moduleId > -1) {
            try {
                List<Contract> contracts;
                Integer pid;
                String query = null;
                if (authMode == 1) {
                    query = "SELECT id, pswd FROM contract WHERE title=? LIMIT 1";
                    PreparedStatement ps = con.prepareStatement(query);
                    ps.setString(1, login);
                    ResultSet rs = ps.executeQuery();
                    if (rs.next()) {
                        moduleUser = new ModuleUser();
                        moduleUser.setLogin(login);
                        moduleUser.setPassword(rs.getString(2));
                        moduleUser.setContractId(rs.getInt(1));
                        moduleUser.setContractTitle(login);
                    }
                    rs.close();
                    ps.close();
                } else if (authMode == 2 && (pid = Integer.valueOf(Setup.getSetup().getInt("web.auth.contract.text.parameter", 0))) > 0 && (contracts = new ContractDao(con, 0).getContractForTextlikeParamValue(pid, login)) != null && !contracts.isEmpty()) {
                    Contract contract = contracts.get(0);
                    moduleUser = new ModuleUser();
                    moduleUser.setLogin(login);
                    moduleUser.setPassword(contract.getPassword());
                    moduleUser.setContractId(contract.getId());
                    moduleUser.setContractTitle(login);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return moduleUser;
    }
}

