/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.util.telnet.old;

import bitel.billing.server.util.telnet.old.TimeIntervalFormatException;
import java.io.Serializable;
import java.util.StringTokenizer;

public class TimeInterval
implements Serializable {
    private static final long _MILLISECOND = 1L;
    private static final long _SECOND = 1000L;
    private static final long _MINUTE = 60000L;
    private static final long _HOUR = 3600000L;
    private static final long _DAY = 86400000L;
    private static final long _WEEK = 604800000L;
    private static final long[] values = new long[]{1L, 1000L, 60000L, 3600000L, 86400000L, 604800000L};
    private static final int MILLISECOND_INDEX = 0;
    private static final int SECOND_INDEX = 1;
    private static final int MINUTE_INDEX = 2;
    private static final int HOUR_INDEX = 3;
    private static final int DAY_INDEX = 4;
    private static final int WEEK_INDEX = 5;
    private static final String[][] desc = new String[][]{{"millisecond", "msec", "ms"}, {"second", "sec", "ss"}, {"minute", "min", "m", "mm"}, {"hour", "hr", "h", "hh"}, {"day", "d", "dd"}, {"week", "wk", "ww"}};
    public static final long MILLISECOND = values[0];
    public static final long SECOND = values[1];
    public static final long MINUTE = values[2];
    public static final long HOUR = values[3];
    public static final long DAY = values[4];
    public static final long WEEK = values[5];
    public static final String[] MILLISECOND_STR = desc[0];
    public static final String[] SECOND_STR = desc[1];
    public static final String[] MINUTE_STR = desc[2];
    public static final String[] HOUR_STR = desc[3];
    public static final String[] DAY_STR = desc[4];
    public static final String[] WEEK_STR = desc[5];
    public long milliseconds;
    public long seconds;
    public long weeks;
    public long days;
    public long hours;
    public long minutes;

    public TimeInterval() {
        this(0L, 0L, 0L, 0L, 0L, 0L);
    }

    public TimeInterval(long l) {
        this.weeks = l / WEEK;
        this.days = l % WEEK / DAY;
        this.hours = l % WEEK % DAY / HOUR;
        this.minutes = l % WEEK % DAY % HOUR / MINUTE;
        this.seconds = l % WEEK % DAY % HOUR % MINUTE / SECOND;
        this.milliseconds = l % WEEK % DAY % HOUR % MINUTE % SECOND / MILLISECOND;
    }

    private static long[] splitTime(long l) {
        long[] values = new long[]{l / WEEK, l % WEEK / DAY, l % WEEK % DAY / HOUR, l % WEEK % DAY % HOUR / MINUTE, l % WEEK % DAY % HOUR % MINUTE / SECOND, l % WEEK % DAY % HOUR % MINUTE % SECOND / MILLISECOND};
        return values;
    }

    public TimeInterval(long weeks, long days, long hours, long minutes, long seconds, long milliseconds) {
        this.weeks = weeks;
        this.days = days;
        this.hours = hours;
        this.minutes = minutes;
        this.seconds = seconds;
        this.milliseconds = milliseconds;
    }

    public TimeInterval(String s) throws TimeIntervalFormatException {
        TimeInterval timeinterval = TimeInterval.parse(s);
        this.weeks = timeinterval.weeks;
        this.days = timeinterval.days;
        this.hours = timeinterval.hours;
        this.minutes = timeinterval.minutes;
        this.seconds = timeinterval.seconds;
        this.milliseconds = timeinterval.milliseconds;
    }

    private static long addElementValue(TimeInterval timeinterval, String s) throws TimeIntervalFormatException {
        s.toLowerCase();
        for (int i = 0; i < desc.length; ++i) {
            for (int j = 0; j < desc[i].length; ++j) {
                if (!s.endsWith(desc[i][j]) && !s.endsWith(desc[i][j] + "s")) continue;
                s = s.substring(0, s.lastIndexOf(desc[i][j]));
                try {
                    long l = Long.parseLong(s);
                    switch (i) {
                        case 0: {
                            timeinterval.milliseconds += l;
                            break;
                        }
                        case 1: {
                            timeinterval.seconds += l;
                            break;
                        }
                        case 2: {
                            timeinterval.minutes += l;
                            break;
                        }
                        case 3: {
                            timeinterval.hours += l;
                            break;
                        }
                        case 4: {
                            timeinterval.days += l;
                            break;
                        }
                        case 5: {
                            timeinterval.weeks += l;
                        }
                    }
                    return values[i] * l;
                }
                catch (NumberFormatException _ex) {
                    throw new TimeIntervalFormatException();
                }
            }
        }
        throw new TimeIntervalFormatException(s);
    }

    public long getTime() {
        return WEEK * this.weeks + DAY * this.days + HOUR * this.hours + MINUTE * this.minutes + SECOND * this.seconds + MILLISECOND * this.milliseconds;
    }

    private final String makeDescr() {
        return TimeInterval.makeDescr(this.weeks, this.days, this.hours, this.minutes, this.seconds, this.milliseconds);
    }

    private static String makeDescr(long[] values) {
        return TimeInterval.makeDescr(values[0], values[1], values[2], values[3], values[4], values[5]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String makeDescr(long weeks, long days, long hours, long minutes, long seconds, long milliseconds) {
        StringBuffer stringbuffer;
        StringBuffer stringBuffer = stringbuffer = new StringBuffer();
        synchronized (stringBuffer) {
            if (weeks != 0L) {
                stringbuffer.append(weeks);
                stringbuffer.append(" week");
                if (weeks > 1L) {
                    stringbuffer.append("s");
                }
                if (days != 0L || hours != 0L || minutes != 0L) {
                    stringbuffer.append(",");
                }
            }
            if (days != 0L) {
                if (weeks != 0L) {
                    stringbuffer.append(" ");
                }
                stringbuffer.append(days);
                stringbuffer.append(" day");
                if (days > 1L) {
                    stringbuffer.append("s");
                }
                if (hours != 0L || minutes != 0L) {
                    stringbuffer.append(",");
                }
            }
            if (hours != 0L) {
                if (days != 0L) {
                    stringbuffer.append(" ");
                }
                stringbuffer.append(hours);
                stringbuffer.append(" hour");
                if (hours > 1L) {
                    stringbuffer.append("s");
                }
                if (minutes != 0L) {
                    stringbuffer.append(",");
                }
            }
            if (minutes != 0L) {
                if (hours != 0L) {
                    stringbuffer.append(" ");
                }
                stringbuffer.append(minutes);
                stringbuffer.append(" minute");
                if (minutes > 1L) {
                    stringbuffer.append("s");
                }
            }
            if (seconds != 0L) {
                if (minutes != 0L) {
                    stringbuffer.append(" ");
                }
                stringbuffer.append(seconds);
                stringbuffer.append(" second");
                if (seconds > 1L) {
                    stringbuffer.append("s");
                }
            }
            if (milliseconds != 0L) {
                if (seconds != 0L) {
                    stringbuffer.append(" ");
                }
                stringbuffer.append(milliseconds);
                stringbuffer.append(" millisecond");
                if (milliseconds > 1L) {
                    stringbuffer.append("s");
                }
            }
            if (stringbuffer.length() == 0) {
                return "0 milliseconds";
            }
            return stringbuffer.toString();
        }
    }

    public static TimeInterval parse(String s) throws TimeIntervalFormatException {
        StringTokenizer stringtokenizer = new StringTokenizer(s, " +,");
        TimeInterval timeinterval = new TimeInterval();
        String s1 = "";
        while (stringtokenizer.hasMoreElements()) {
            s1 = s1 + stringtokenizer.nextToken();
            try {
                Double.parseDouble(s1);
            }
            catch (NumberFormatException e) {
                TimeInterval.addElementValue(timeinterval, s1);
                s1 = "";
            }
        }
        return timeinterval;
    }

    public static String describe(long interval) {
        return TimeInterval.makeDescr(TimeInterval.splitTime(interval));
    }

    public boolean longer(TimeInterval timeinterval) {
        return this.getTime() > timeinterval.getTime();
    }

    public boolean shorter(TimeInterval timeinterval) {
        return this.getTime() < timeinterval.getTime();
    }

    public String toString() {
        return this.makeDescr();
    }

    public boolean equals(Object obj) {
        if (obj instanceof TimeInterval) {
            TimeInterval t = (TimeInterval)obj;
            return this.getTime() == t.getTime();
        }
        return false;
    }

    public int hashCode() {
        return String.valueOf(this.getTime()).hashCode();
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            System.out.println("Please provide a timeinterval descriptor or a milliseconds value");
        } else {
            if (args[0].endsWith("ms")) {
                args[0] = args[0].substring(0, args[0].length() - 2);
            }
            try {
                System.out.println(args[0] + "ms: \"" + new TimeInterval(Long.parseLong(args[0])).toString() + "\"");
            }
            catch (NumberFormatException e) {
                System.out.println(TimeInterval.parse(args[0]).getTime() + "ms");
            }
        }
    }
}

