/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.util.manager;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.HashMap;
import java.util.Map;
import ru.bitel.bgbilling.common.BGException;

public abstract class SocketManager {
    protected String host = "127.0.0.1";
    protected int port = 0;

    public void executeCommand(String[] args) {
        this.analizeArgs(this.parseParams(args));
    }

    private Map<String, String> parseParams(String[] args) {
        HashMap<String, String> result = new HashMap<String, String>();
        String param = null;
        if (args != null && args.length > 0) {
            try {
                for (int i = 0; i < args.length; ++i) {
                    param = args[i];
                    if (param.startsWith("-help") || param.startsWith("-?")) {
                        result.put("help", "");
                        continue;
                    }
                    if (param.startsWith("-h")) {
                        result.put("host", param.substring(2, param.length()));
                        continue;
                    }
                    if (param.startsWith("-p")) {
                        result.put("port", param.substring(2, param.length()));
                        continue;
                    }
                    if (param.startsWith("-e")) {
                        String command = param.substring(2, param.length());
                        result.put("command", command);
                        continue;
                    }
                    result.put("error", "unknown parameter: " + param);
                    break;
                }
            }
            catch (Exception ex) {
                result.put("error", ex.getLocalizedMessage());
                ex.printStackTrace();
            }
        }
        return result;
    }

    private void analizeArgs(Map<String, String> args) {
        try {
            if (args.size() == 0) {
                System.out.println(this.getHelpMessage());
            } else if (args.containsKey("error")) {
                System.out.println("Params parse ERROR: " + args.get("error"));
            } else if (args.containsKey("help")) {
                System.out.println(this.getHelpMessage());
            } else {
                if (args.containsKey("host")) {
                    this.host = args.get("host");
                }
                if (args.containsKey("port")) {
                    this.port = Integer.parseInt(args.get("port"));
                }
                if (args.containsKey("command")) {
                    String command = args.get("command");
                    if (command.equals("start")) {
                        if (this.checkPort()) {
                            this.startApplication();
                        }
                    } else {
                        System.out.println("Sending '" + command + "' on " + this.host + ":" + this.port);
                        String result = this.sendCommand(command);
                        System.out.println("Result: " + result);
                    }
                }
            }
        }
        catch (Exception ex) {
            System.out.println("ERROR: " + ex.getLocalizedMessage());
            ex.printStackTrace();
        }
    }

    private boolean checkPort() {
        boolean result = true;
        System.out.println("Checking port " + this.port + "...");
        try {
            ServerSocket s = new ServerSocket(this.port);
            s.close();
        }
        catch (Exception ex) {
            result = false;
        }
        if (!result) {
            System.out.println("Port is already busy.");
        } else {
            System.out.println("Port is free starting the applicalion...");
        }
        return result;
    }

    private String sendCommand(String command) {
        String result = "";
        Socket socket = null;
        try {
            InetAddress addr = InetAddress.getByName(this.host);
            socket = new Socket(addr, this.port);
            BufferedReader in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            PrintWriter out = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter(socket.getOutputStream())), true);
            out.println(command);
            result = in.readLine().replace('$', '\n');
            socket.close();
        }
        catch (Exception ex) {
            result = "Port " + this.port + " is empty.";
        }
        return result;
    }

    protected abstract String getHelpMessage();

    protected abstract void startApplication() throws BGException;
}

