/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.util.diff;

import bitel.billing.server.util.diff.Difference;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.TreeMap;

public class Diff {
    protected Object[] a;
    protected Object[] b;
    protected List<Difference> diffs = new ArrayList<Difference>();
    private Difference pending;
    private Comparator<Object> comparator;
    private TreeMap<Integer, Integer> thresh;

    public Diff(Object[] a2, Object[] b2, Comparator<Object> comp) {
        this.a = a2;
        this.b = b2;
        this.comparator = comp;
        this.thresh = null;
    }

    public Diff(Object[] a2, Object[] b2) {
        this(a2, b2, null);
    }

    public Diff(Collection<Object> a2, Collection<Object> b2, Comparator<Object> comp) {
        this(a2.toArray(), b2.toArray(), comp);
    }

    public Diff(Collection<Object> a2, Collection<Object> b2) {
        this(a2, b2, null);
    }

    public List<Difference> diff() {
        this.traverseSequences();
        if (this.pending != null) {
            this.diffs.add(this.pending);
        }
        return this.diffs;
    }

    protected void traverseSequences() {
        int ai;
        Integer[] matches = this.getLongestCommonSubsequences();
        int lastA = this.a.length - 1;
        int lastB = this.b.length - 1;
        int bi = 0;
        int lastMatch = matches.length - 1;
        for (ai = 0; ai <= lastMatch; ++ai) {
            Integer bLine = matches[ai];
            if (bLine == null) {
                this.onANotB(ai, bi);
                continue;
            }
            while (bi < bLine) {
                this.onBNotA(ai, bi++);
            }
            this.onMatch(ai, bi++);
        }
        boolean calledFinishA = false;
        boolean calledFinishB = false;
        while (ai <= lastA || bi <= lastB) {
            if (ai == lastA + 1 && bi <= lastB) {
                if (!calledFinishA && this.callFinishedA()) {
                    this.finishedA(lastA);
                    calledFinishA = true;
                } else {
                    while (bi <= lastB) {
                        this.onBNotA(ai, bi++);
                    }
                }
            }
            if (bi == lastB + 1 && ai <= lastA) {
                if (!calledFinishB && this.callFinishedB()) {
                    this.finishedB(lastB);
                    calledFinishB = true;
                } else {
                    while (ai <= lastA) {
                        this.onANotB(ai++, bi);
                    }
                }
            }
            if (ai <= lastA) {
                this.onANotB(ai++, bi);
            }
            if (bi > lastB) continue;
            this.onBNotA(ai, bi++);
        }
    }

    protected boolean callFinishedA() {
        return false;
    }

    protected boolean callFinishedB() {
        return false;
    }

    protected void finishedA(int lastA) {
    }

    protected void finishedB(int lastB) {
    }

    protected void onANotB(int ai, int bi) {
        if (this.pending == null) {
            this.pending = new Difference(ai, ai, bi, -1);
        } else {
            this.pending.setDeleted(ai);
        }
    }

    protected void onBNotA(int ai, int bi) {
        if (this.pending == null) {
            this.pending = new Difference(ai, -1, bi, bi);
        } else {
            this.pending.setAdded(bi);
        }
    }

    protected void onMatch(int ai, int bi) {
        if (this.pending != null) {
            this.diffs.add(this.pending);
            this.pending = null;
        }
    }

    protected boolean equals(Object x, Object y) {
        return this.comparator == null ? x.equals(y) : this.comparator.compare(x, y) == 0;
    }

    public Integer[] getLongestCommonSubsequences() {
        List positions;
        int aStart = 0;
        int aEnd = this.a.length - 1;
        int bStart = 0;
        int bEnd = this.b.length - 1;
        TreeMap<Integer, Integer> matches = new TreeMap<Integer, Integer>();
        while (aStart <= aEnd && bStart <= bEnd && this.equals(this.a[aStart], this.b[bStart])) {
            matches.put(new Integer(aStart++), new Integer(bStart++));
        }
        while (aStart <= aEnd && bStart <= bEnd && this.equals(this.a[aEnd], this.b[bEnd])) {
            matches.put(new Integer(aEnd--), new Integer(bEnd--));
        }
        AbstractMap bMatches = null;
        bMatches = this.comparator == null ? (this.a.length > 0 && this.a[0] instanceof Comparable ? new TreeMap() : new HashMap()) : new TreeMap(this.comparator);
        for (int bi = bStart; bi <= bEnd; ++bi) {
            Object element = this.b[bi];
            Object key = element;
            positions = (ArrayList<Integer>)bMatches.get(key);
            if (positions == null) {
                positions = new ArrayList<Integer>();
                bMatches.put(key, positions);
            }
            positions.add(new Integer(bi));
        }
        this.thresh = new TreeMap();
        HashMap<Integer, Object[]> links = new HashMap<Integer, Object[]>();
        for (int i = aStart; i <= aEnd; ++i) {
            Object aElement = this.a[i];
            positions = (List)bMatches.get(aElement);
            if (positions == null) continue;
            Integer k = new Integer(0);
            ListIterator pit = positions.listIterator(positions.size());
            while (pit.hasPrevious()) {
                Integer j = (Integer)pit.previous();
                k = this.insert(j, k);
                if (k == null) continue;
                Object value = k > 0 ? links.get(new Integer(k - 1)) : null;
                links.put(k, new Object[]{value, new Integer(i), j});
            }
        }
        if (this.thresh.size() > 0) {
            Integer ti = this.thresh.lastKey();
            Object[] link = (Object[])links.get(ti);
            while (link != null) {
                Integer x = (Integer)link[1];
                Integer y = (Integer)link[2];
                matches.put(x, y);
                link = (Object[])link[0];
            }
        }
        return Diff.toArray(matches);
    }

    protected static Integer[] toArray(TreeMap<Integer, Integer> map) {
        int size = map.size() == 0 ? 0 : 1 + map.lastKey();
        Integer[] ary = new Integer[size];
        for (Integer idx : map.keySet()) {
            ary[idx.intValue()] = map.get(idx);
        }
        return ary;
    }

    protected static boolean isNonzero(Integer i) {
        return i != null && i != 0;
    }

    protected boolean isGreaterThan(Integer index, Integer val) {
        Integer lhs = this.thresh.get(index);
        return lhs != null && val != null && lhs.compareTo(val) > 0;
    }

    protected boolean isLessThan(Integer index, Integer val) {
        Integer lhs = this.thresh.get(index);
        return lhs != null && (val == null || lhs.compareTo(val) < 0);
    }

    protected Integer getLastValue() {
        return this.thresh.get(this.thresh.lastKey());
    }

    protected void append(Integer value) {
        Integer addIdx = null;
        if (this.thresh.size() == 0) {
            addIdx = new Integer(0);
        } else {
            Integer lastKey = this.thresh.lastKey();
            addIdx = new Integer(lastKey + 1);
        }
        this.thresh.put(addIdx, value);
    }

    protected Integer insert(Integer j, Integer k) {
        if (Diff.isNonzero(k) && this.isGreaterThan(k, j) && this.isLessThan(new Integer(k - 1), j)) {
            this.thresh.put(k, j);
        } else {
            int hi = -1;
            if (Diff.isNonzero(k)) {
                hi = k;
            } else if (this.thresh.size() > 0) {
                hi = this.thresh.lastKey();
            }
            if (hi == -1 || j.compareTo(this.getLastValue()) > 0) {
                this.append(j);
                k = new Integer(hi + 1);
            } else {
                int lo = 0;
                while (lo <= hi) {
                    int index = (hi + lo) / 2;
                    Integer val = this.thresh.get(new Integer(index));
                    int cmp = j.compareTo(val);
                    if (cmp == 0) {
                        return null;
                    }
                    if (cmp > 0) {
                        lo = index + 1;
                        continue;
                    }
                    hi = index - 1;
                }
                this.thresh.put(new Integer(lo), j);
                k = new Integer(lo);
            }
        }
        return k;
    }
}

