/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.util;

import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.apache.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGRuntimeException;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;

public class MailMsg {
    protected static final Logger log = Logger.getLogger(MailMsg.class);
    private String encoding;
    private MimeMessage msg;

    public MailMsg(Preferences setup) throws BGException {
        String fromAddress = setup.get("mail.from.email", null);
        String fromName = setup.get("mail.from.name", "BGBilling server");
        this.encoding = setup.get("mail.encoding", "UTF-8");
        String user = setup.get("mail.smtp.user", null);
        String pswd = setup.get("mail.smtp.pswd", null);
        if (fromAddress != null) {
            Session session = null;
            Properties props = new Properties();
            props.setProperty("mail.smtp.host", setup.get("mail.smtp.host", null));
            props.setProperty("mail.smtp.port", setup.get("mail.smtp.port", "25"));
            props.setProperty("mail.smtp.localhost", setup.get("mail.smtp.localhost", ""));
            props.setProperty("mail.debug", String.valueOf(setup.getBoolean("mail.debug", false)));
            for (Map.Entry<String, String> entry : setup.sub("mail.properties.").entrySet()) {
                props.put(entry.getKey(), entry.getValue());
            }
            Authenticator authenticator = null;
            if (Utils.notBlankString(user) && Utils.notBlankString(pswd)) {
                authenticator = new Authenticator(user, pswd);
                props.setProperty("mail.smtp.auth", "true");
                props.setProperty("mail.smtp.submitter", authenticator.getPasswordAuthentication().getUserName());
            }
            session = Session.getInstance((Properties)props, authenticator);
            this.msg = new MimeMessage(session);
            try {
                this.msg.setFrom((Address)new InternetAddress(fromAddress, fromName, this.encoding));
                this.msg.setSentDate(new Date());
            }
            catch (Exception ex) {
                log.error((Object)"error init MailMsg", (Throwable)ex);
            }
        } else {
            log.error((Object)"Not set parameter: mail.from.email");
            throw new BGException("Not set parameter: mail.from.email");
        }
    }

    public void sendMessage(String recipients, String subject, String text) throws BGException {
        MimeMultipart multipart = new MimeMultipart();
        try {
            MimeBodyPart mimeBodyPart = new MimeBodyPart();
            mimeBodyPart.setText(text, this.encoding);
            multipart.addBodyPart((BodyPart)mimeBodyPart);
        }
        catch (MessagingException e) {
            throw new BGException("error send message", e);
        }
        this.sendMessage(recipients, subject, (Multipart)multipart);
    }

    public void sendMessage(String recipients, String subject, Multipart mp) throws BGException {
        StringTokenizer st = new StringTokenizer(recipients, ";,\n\r");
        while (st.hasMoreTokens()) {
            String mail = st.nextToken().trim();
            try {
                log.debug((Object)("message send to " + mail + "..."));
                InternetAddress[] addresses = InternetAddress.parse((String)mail);
                if (addresses.length <= 0) continue;
                this.msg.setSubject(subject, this.encoding);
                this.msg.setContent(mp);
                this.encodingPersonal(addresses);
                this.msg.setRecipients(Message.RecipientType.TO, (Address[])addresses);
                Transport.send((Message)this.msg);
            }
            catch (Exception e) {
                throw new BGException("error send message to " + mail, e);
            }
        }
    }

    private void encodingPersonal(InternetAddress[] addresses) {
        if (addresses != null) {
            for (InternetAddress address : addresses) {
                try {
                    address.setPersonal(address.getPersonal(), "utf-8");
                }
                catch (UnsupportedEncodingException uee) {
                    throw new BGRuntimeException("error encoding personal", uee);
                }
            }
        }
    }

    private static class Authenticator
    extends javax.mail.Authenticator {
        private PasswordAuthentication authentication;

        public Authenticator(String user, String password) {
            this.authentication = new PasswordAuthentication(user, password);
        }

        protected PasswordAuthentication getPasswordAuthentication() {
            return this.authentication;
        }
    }
}

