/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.tariff.voice.action;

import bitel.billing.server.tariff.voice.action.base.ActionBase;
import bitel.billing.server.tariff.voice.bean.GeographicCode;
import bitel.billing.server.tariff.voice.bean.GeographicCodeManager;
import java.sql.SQLException;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;

public class ActionGeographicCode
extends ActionBase {
    @Override
    public void doAction() throws SQLException, BGException {
        if (this.mid <= 0) {
            throw new BGIllegalArgumentException();
        }
        GeographicCodeManager man = new GeographicCodeManager(this.con, this.mid);
        if (this.getParameter("tree") != null) {
            GeographicCode code = man.getRootCode(true);
            this.build(code, this.rootNode, this.rootNode.getOwnerDocument());
        } else {
            List<GeographicCode> codeList = man.getGeographicCodeList();
            Element table = this.createElement(this.rootNode, "table");
            Element data = this.createElement(table, "data");
            for (GeographicCode code : codeList) {
                Element row = this.createElement(data, "row");
                row.setAttribute("code", code.getCode());
                row.setAttribute("title", code.getDest());
                row.setAttribute("dest_id", String.valueOf(code.getDestId()));
                row.setAttribute("start_level", String.valueOf(code.getStartLevel()));
                row.setAttribute("end_level", String.valueOf(code.getEndLevel()));
            }
        }
    }

    private void build(GeographicCode code, Element parent, Document doc) {
        List<GeographicCode> list;
        Element curr = doc.createElement("n");
        parent.appendChild(curr);
        curr.setAttribute("c", code.getCode());
        curr.setAttribute("t", code.getDest());
        curr.setAttribute("d", String.valueOf(code.getDestId()));
        if (code.getStartLevel() > 0) {
            curr.setAttribute("sl", String.valueOf(code.getStartLevel()));
        }
        if (code.getEndLevel() > 0) {
            curr.setAttribute("el", String.valueOf(code.getEndLevel()));
        }
        if ((list = code.getSubList()) != null) {
            for (GeographicCode c : list) {
                this.build(c, curr, doc);
            }
        }
    }
}

