/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.tariff;

import java.util.Calendar;
import java.util.StringTokenizer;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class TimeLimits {
    private int _minute = 0;
    private int _hour = 0;
    private int _month = 0;
    private int _dayOfMonth = 0;
    private int _dayOfWeek = 0;

    public TimeLimits(String data) {
        StringTokenizer st = new StringTokenizer(data, "_");
        while (st.hasMoreTokens()) {
            String key = st.nextToken();
            if (!st.hasMoreTokens()) continue;
            String value = st.nextToken();
            if (key.equals("minute")) {
                this._minute = Utils.parseInt(value, 0);
                continue;
            }
            if (key.equals("hour")) {
                this._hour = Utils.parseInt(value, 0);
                continue;
            }
            if (key.equals("month")) {
                this._month = Utils.parseInt(value, 0);
                continue;
            }
            if (key.equals("dayOfMonth")) {
                this._dayOfMonth = Utils.parseInt(value, 0);
                continue;
            }
            if (!key.equals("dayOfWeek")) continue;
            this._dayOfWeek = Utils.parseInt(value, 0);
        }
    }

    public boolean checkDate(Calendar date) {
        if (!TimeUtils.checkMasks(date, this._hour, this._dayOfWeek, this._month, this._dayOfMonth)) {
            return false;
        }
        return this._minute <= 0 || (this._minute & 1 << date.get(12)) != 0;
    }
}

