/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.load;

import bitel.billing.server.load.DBLoadOut;
import bitel.billing.server.load.LoadIn;
import bitel.billing.server.load.LoadOut;
import bitel.billing.server.load.ZipLoadIn;
import bitel.billing.server.load.bean.Source;
import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.Calendar;
import org.apache.log4j.Logger;
import ru.bitel.bgbilling.server.util.DefaultServerSetup;

public abstract class BaseLoader {
    protected DefaultServerSetup setup;
    protected Source source;
    protected Calendar hour;
    protected int taskId;
    protected PreparedStatement psInsertLogData;
    protected static Logger logger = Logger.getLogger((String)"dataloader");
    protected LoadOut loadOut;
    protected int recordCount;

    public void init(DefaultServerSetup setup, Source source, Calendar hour, int taskId) {
        this.setup = setup;
        this.source = source;
        this.hour = hour;
        this.taskId = taskId;
    }

    public DefaultServerSetup getSetup() {
        return this.setup;
    }

    public Source getSource() {
        return this.source;
    }

    public Calendar getHour() {
        return this.hour;
    }

    public int getTaskId() {
        return this.taskId;
    }

    public void setLoadOut(LoadOut loadOut) {
        this.loadOut = loadOut;
    }

    public int getRecordCount() {
        return this.recordCount;
    }

    public abstract ZipLoadIn getZipLoadIn(File var1);

    public abstract DBLoadOut getDBLoadOut();

    public abstract void doLoad(Connection var1, LoadIn var2) throws Exception;

    @Deprecated
    public void finishLoad(Connection con, boolean addProcessTask, long time, long size) {
        this.finishLoad(con, addProcessTask, addProcessTask, time, size);
    }

    public void finishLoad(Connection con, boolean addProcessTask, boolean addProcessTask2, long time, long size) {
        this.loadOut.finishLoad();
        if (time <= 0L) {
            time = this.loadOut.getFileTime();
        }
        if (size <= 0L) {
            size = this.loadOut.getFileSize();
        }
        this.loadOut.insertSourceData(con, size, time);
        if (addProcessTask) {
            this.loadOut.addProcessTask(con, addProcessTask2);
        }
    }
}

