/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.contract.tariff.action;

import bitel.billing.server.contract.bean.PersonalTariff;
import bitel.billing.server.contract.bean.PersonalTariffManager;
import bitel.billing.server.contract.tariff.action.base.ActionBase;
import java.sql.SQLException;
import java.util.Calendar;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.kernel.event.events.PersonalTariffUpdateEvent;
import ru.bitel.bgbilling.kernel.tariff.server.event.ContractTariffChangedEvent;
import ru.bitel.bgbilling.server.util.ClosedDateChecker;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class ActionUpdatePersonalTariff
extends ActionBase {
    @Override
    public void doAction() throws SQLException, BGException {
        PersonalTariff tariff;
        int id = this.getIntParameter("id", -1);
        int pos = this.getIntParameter("pos", 0);
        String title = this.getParameter("title");
        Calendar date1 = TimeUtils.convertDateToCalendar(this.getDateParameter("date1"));
        Calendar date2 = TimeUtils.convertDateToCalendar(this.getDateParameter("date2"));
        String titleWeb = this.getParameter("title_web");
        String config = this.getParameter("config");
        if (id < 0 || this.cid <= 0 || Utils.isBlankString(title)) {
            throw new BGIllegalArgumentException();
        }
        PersonalTariffManager manager = new PersonalTariffManager(this.con);
        Calendar closedDate = null;
        closedDate = ClosedDateChecker.getClosePeriodDateIfChecking("ActionUpdatePersonalTariff", this.mid, this.userId);
        if (closedDate != null) {
            tariff = manager.getPersonalTariff(id);
            Calendar oldDate1 = null;
            Calendar oldDate2 = null;
            if (tariff != null) {
                oldDate1 = tariff.getDate1();
                oldDate2 = tariff.getDate2();
            }
            ClosedDateChecker.checkDatesForUpdate(closedDate, oldDate1, oldDate2, date1, date2);
        }
        tariff = new PersonalTariff();
        tariff.setId(id);
        tariff.setContractId(this.cid);
        tariff.setTitle(title);
        tariff.setDate1(date1);
        tariff.setDate2(date2);
        tariff.setPos(pos);
        tariff.setTitleWeb(titleWeb);
        tariff.setUseTitleInWeb(titleWeb == null);
        tariff.setConfig(config);
        manager.updatePersonalTariff(tariff);
        this.context.publishAfterCommit(new ContractTariffChangedEvent(this.cid));
        this.context.publishAfterCommit(new PersonalTariffUpdateEvent(this.userId, this.cid, tariff.getId()));
    }
}

