/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.contract.status.action;

import bitel.billing.server.contract.bean.ContractStatus;
import bitel.billing.server.contract.bean.ContractStatusManager;
import bitel.billing.server.contract.status.action.base.ActionBase;
import java.sql.SQLException;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.kernel.contract.status.server.StatusCache;
import ru.bitel.common.TimeUtils;

public class ActionContractStatusTable
extends ActionBase {
    @Override
    public void doAction() throws SQLException, BGException {
        if (this.cid <= 0) {
            throw new BGIllegalArgumentException();
        }
        Element table = this.createElement(this.rootNode, "table");
        Element data = this.createElement(table, "data");
        ContractStatusManager statusManager = new ContractStatusManager(this.con);
        for (ContractStatus status : statusManager.getStatusList(this.cid)) {
            Element row = this.createElement(data, "row");
            row.setAttribute("id", String.valueOf(status.getId()));
            row.setAttribute("period", TimeUtils.formatPeriod(status.getDateFrom(), status.getDateTo()));
            row.setAttribute("status", StatusCache.getInstance().getStatusTitle(status.getStatus()));
            row.setAttribute("comment", status.getComment());
        }
    }
}

