/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.contract.bean;

import bitel.billing.server.contract.bean.PersonalTariff;
import bitel.billing.server.tariff.TariffTreeBuilder;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;

public class PersonalTariffManager {
    private static final String TABLE_NAME = "contract_tree_link";
    private Connection con;

    public PersonalTariffManager(Connection con) {
        this.con = con;
    }

    public List<PersonalTariff> getPersonalTariffList(int cid) {
        ArrayList<PersonalTariff> result = new ArrayList<PersonalTariff>();
        try {
            String query = "SELECT * FROM contract_tree_link WHERE cid=? ORDER BY pos, date1";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, cid);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(this.getFromRs(rs));
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    @Deprecated
    public List<PersonalTariff> getPersonalTariffList(int cid, Calendar time) {
        return this.getPersonalTariffList(cid, TimeUtils.convertCalendarToDate(time));
    }

    public List<PersonalTariff> getPersonalTariffList(int cid, Date time) {
        ArrayList<PersonalTariff> result = new ArrayList<PersonalTariff>();
        try {
            String query = "SELECT * FROM contract_tree_link WHERE cid=?  AND (date1 IS NULL OR date1<=?)  AND (date2 IS NULL OR date2>=?) ORDER BY pos, date1";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, cid);
            ps.setDate(2, TimeUtils.convertDateToSqlDate(time));
            ps.setDate(3, TimeUtils.convertDateToSqlDate(time));
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(this.getFromRs(rs));
            }
            rs.close();
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public List<PersonalTariff> getPersonalTariffList(int cid, Date date1, Date date2) {
        ArrayList<PersonalTariff> result = new ArrayList<PersonalTariff>();
        try {
            String query = "SELECT * FROM contract_tree_link WHERE cid=?  AND (date1 IS NULL OR date1<=?)  AND (date2 IS NULL OR date2>=?) ORDER BY pos, date1";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, cid);
            ps.setDate(2, TimeUtils.convertDateToSqlDate(date2));
            ps.setDate(3, TimeUtils.convertDateToSqlDate(date1));
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(this.getFromRs(rs));
            }
            rs.close();
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public void updatePersonalTariff(PersonalTariff tariff) {
        try {
            String query = null;
            PreparedStatement ps = null;
            if (tariff.getId() <= 0) {
                tariff.setTreeId(new TariffTreeBuilder(this.con).createTree());
                query = "INSERT INTO contract_tree_link SET date1=?, date2=?, title=?, pos=?, title_web=?, config=?,cid=?, tree_id=?";
                ps = this.con.prepareStatement(query, 1);
                ps.setInt(7, tariff.getContractId());
                ps.setInt(8, tariff.getTreeId());
            } else {
                query = "UPDATE contract_tree_link SET date1=?, date2=?, title=?, pos=?,title_web=?, config=? WHERE id=?";
                ps = this.con.prepareStatement(query);
                ps.setInt(7, tariff.getId());
            }
            ps.setDate(1, TimeUtils.convertCalendarToSqlDate(tariff.getDate1()));
            ps.setDate(2, TimeUtils.convertCalendarToSqlDate(tariff.getDate2()));
            ps.setString(3, tariff.getTitle());
            ps.setInt(4, tariff.getPos());
            ps.setString(5, tariff.isUseTitleInWeb() ? null : tariff.getTitleWeb());
            ps.setString(6, tariff.getConfig());
            ps.executeUpdate();
            if (tariff.getId() <= 0) {
                tariff.setId(ServerUtils.lastInsertId(ps));
            }
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void deletePersonalTariff(int id) {
        try {
            String query = "DELETE FROM contract_tree_link WHERE id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, id);
            ps.executeUpdate();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public PersonalTariff getPersonalTariff(int id) {
        PersonalTariff result = null;
        try {
            String query = "SELECT * FROM contract_tree_link WHERE id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, id);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                result = this.getFromRs(rs);
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    private PersonalTariff getFromRs(ResultSet rs) throws SQLException {
        PersonalTariff result = new PersonalTariff();
        result.setId(rs.getInt("id"));
        result.setTitle(rs.getString("title"));
        result.setDate1(TimeUtils.convertDateToCalendar(rs.getDate("date1")));
        result.setDate2(TimeUtils.convertDateToCalendar(rs.getDate("date2")));
        result.setTreeId(rs.getInt("tree_id"));
        result.setPos(rs.getInt("pos"));
        String titleWeb = rs.getString("title_web");
        result.setUseTitleInWeb(titleWeb == null);
        result.setTitleWeb(titleWeb == null ? result.getTitle() : titleWeb);
        result.setConfig(rs.getString("config"));
        return result;
    }

    public Set<Integer> getParentTreeTariffIds(int contractId, Date date) {
        HashSet<Integer> result = new HashSet<Integer>();
        try {
            PreparedStatement ps = this.con.prepareStatement("SELECT tariff_plan.id FROM contract_tree_link LEFT JOIN module_tariff_tree ON module_tariff_tree.tree_id=contract_tree_link.tree_id LEFT JOIN tariff_plan ON tariff_plan.tree_id=module_tariff_tree.parent_tree WHERE contract_tree_link.cid=? AND tariff_plan.id IS NOT NULL AND (? IS NULL OR (( date1 IS NULL OR date1<=? ) AND ( date2 IS NULL OR date2>=? )))");
            java.sql.Date sqlDate = TimeUtils.convertDateToSqlDate(date);
            ps.setInt(1, contractId);
            ps.setDate(2, sqlDate);
            ps.setDate(3, sqlDate);
            ps.setDate(4, sqlDate);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(rs.getInt(1));
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return result;
    }
}

