/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.contract.action.web;

import bitel.billing.server.contract.bean.Contract;
import bitel.billing.server.contract.bean.ContractManager;
import bitel.billing.server.contract.bean.ContractStatus;
import bitel.billing.server.contract.bean.ContractStatusManager;
import bitel.billing.server.contract.status.action.base.ActionBase;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.contract.status.server.StatusCache;
import ru.bitel.bgbilling.kernel.contract.status.server.WebStatusChangeRules;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.events.GetContractStatusChangeDatesEvent;
import ru.bitel.bgbilling.server.util.ClosedDateChecker;
import ru.bitel.common.TimeUtils;

public class ActionContractStatus
extends ActionBase {
    private static final int CANCHANGE_DISABLED = 1;
    private static final int CANCHANGE_DISABLED_BADSTATUS = 2;
    private static final int CANCHANGE_DO = 3;
    private static final int CANCHANGE_CANCEL_ALLOW = 4;
    private static final int CANCHANGE_CANCEL_DENY = 5;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doAction() throws SQLException, BGException {
        int n;
        int n2;
        int n3;
        Boolean canCancel;
        Element date;
        Element item;
        Calendar changeTo;
        if (this.cid <= 0) {
            throw new BGIllegalArgumentException();
        }
        ContractStatusManager statusManager = new ContractStatusManager(this.con);
        ContractManager contractManager = new ContractManager(this.con);
        Contract contract = contractManager.getContractById(this.cid);
        int statusint = contract.getStatus();
        this.rootNode.setAttribute("statusstr", StatusCache.getInstance().getStatusTitle(statusint));
        this.rootNode.setAttribute("statusint", String.valueOf(statusint));
        Date curdate = new Date();
        WebStatusChangeRules changeRules = StatusCache.getInstance().getWebStatusChangeRules();
        Set<Integer> changeableStatusSet = changeRules.getChangeableStatusIds();
        GetContractStatusChangeDatesEvent dateListEvent = new GetContractStatusChangeDatesEvent((int)this.userId, this.cid, statusint, curdate);
        dateListEvent = EventProcessor.getInstance().request(dateListEvent);
        List<Date> changeDateList = dateListEvent.getDateList();
        List<Date> changeDateToList = dateListEvent.getDateToList();
        Calendar changeFrom = TimeUtils.convertDateToCalendar(changeRules.getFromStatusChangeDate(statusint));
        Calendar calendar = changeTo = changeFrom != null ? TimeUtils.plusPeriod(changeFrom, 2, 1) : null;
        if (changeDateList != null) {
            ArrayList<Date> _changeDateList = new ArrayList<Date>();
            for (Date date2 : changeDateList) {
                _changeDateList.add(TimeUtils.clear_HOUR_MIN_MIL_SEC(date2));
            }
            changeDateList = _changeDateList;
        }
        if (changeDateToList != null) {
            ArrayList<Date> _changeDateToList = new ArrayList<Date>();
            for (Date date3 : changeDateToList) {
                _changeDateToList.add(TimeUtils.clear_HOUR_MIN_MIL_SEC(date3));
            }
            changeDateToList = _changeDateToList;
        }
        if (changeDateList != null) {
            if (!changeDateList.isEmpty()) {
                Element dateListEl = this.createElement(this.rootNode, "date_list");
                for (Date date4 : changeDateList) {
                    item = this.createElement(dateListEl, "item");
                    item.setAttribute("value", TimeUtils.format(date4, "dd.MM.yyyy"));
                }
            }
        } else {
            date = this.createElement(this.rootNode, "date");
            if (changeFrom != null) {
                date.setAttribute("day", String.valueOf(changeFrom.get(5)));
                date.setAttribute("month", String.valueOf(changeFrom.get(2) + 1));
                date.setAttribute("year", String.valueOf(changeFrom.get(1)));
            }
        }
        if (changeDateToList != null) {
            if (!changeDateToList.isEmpty()) {
                Element dateListToEl = this.createElement(this.rootNode, "date_list_to");
                for (Date date5 : changeDateToList) {
                    item = this.createElement(dateListToEl, "item");
                    item.setAttribute("value", TimeUtils.format(date5, "dd.MM.yyyy"));
                }
            }
        } else {
            date = this.createElement(this.rootNode, "to_date");
            if (changeTo != null) {
                date.setAttribute("to_day", String.valueOf(changeTo.get(5)));
                date.setAttribute("to_month", String.valueOf(changeTo.get(2) + 1));
                date.setAttribute("to_year", String.valueOf(changeTo.get(1)));
            }
        }
        try {
            if ("Change".equals(this.getParameter("command"))) {
                this.ActionContractStatusChangeDoAction(contract, changeRules, TimeUtils.convertCalendarToDate(changeFrom), changeDateList, changeDateToList);
            }
            if ("Cancel".equals(this.getParameter("command"))) {
                this.ActionContractStatusCancelAction(contract, curdate, changeRules, changeableStatusSet);
            }
            canCancel = null;
        }
        catch (Throwable throwable) {
            Boolean canCancel2 = null;
            Element table = this.createElement(this.rootNode, "statuses");
            for (ContractStatus status : statusManager.getStatusList(this.cid)) {
                Element row = this.createElement(table, "status");
                row.setAttribute("period", TimeUtils.formatPeriod(status.getDateFrom(), status.getDateTo()));
                row.setAttribute("status", StatusCache.getInstance().getStatusTitle(status.getStatus()));
                row.setAttribute("comment", status.getComment());
                if (!TimeUtils.dateBefore(curdate, status.getDateFrom())) continue;
                row.setAttribute("future", "1");
                if (canCancel2 == Boolean.FALSE) continue;
                canCancel2 = changeableStatusSet.contains(status.getStatus());
            }
            int canchange = 3;
            if (changeDateList != null && changeDateList.isEmpty()) {
                canchange = 1;
            }
            if (canchange == 3 && !changeableStatusSet.contains(statusint)) {
                canchange = 2;
            }
            if (canchange == 3 && canCancel2 != null) {
                canchange = canCancel2 != false ? 4 : 5;
            }
            this.rootNode.setAttribute("canchange", String.valueOf(canchange));
            throw throwable;
        }
        Element table = this.createElement(this.rootNode, "statuses");
        for (ContractStatus status : statusManager.getStatusList(this.cid)) {
            Element row = this.createElement(table, "status");
            row.setAttribute("period", TimeUtils.formatPeriod(status.getDateFrom(), status.getDateTo()));
            row.setAttribute("status", StatusCache.getInstance().getStatusTitle(status.getStatus()));
            row.setAttribute("comment", status.getComment());
            if (!TimeUtils.dateBefore(curdate, status.getDateFrom())) continue;
            row.setAttribute("future", "1");
            if (canCancel == Boolean.FALSE) continue;
            canCancel = changeableStatusSet.contains(status.getStatus());
        }
        int n4 = 3;
        if (changeDateList != null && changeDateList.isEmpty()) {
            n3 = 1;
        }
        if (n3 == 3 && !changeableStatusSet.contains(statusint)) {
            n2 = 2;
        }
        if (n2 == 3 && canCancel != null) {
            n = canCancel != false ? 4 : 5;
        }
        this.rootNode.setAttribute("canchange", String.valueOf(n));
    }

    public void ActionContractStatusChangeDoAction(Contract contract, WebStatusChangeRules changeRules, Date fromDate, List<Date> dateList, List<Date> dateToList) throws SQLException, BGException {
        Calendar dateCal;
        int year;
        int month;
        int day;
        int newStatus = this.getIntParameter("status", -1);
        Date date2 = null;
        String comment = "\u0418\u0437\u043c\u0435\u043d\u0435\u043d\u043e \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u0435\u043c";
        Date date1 = this.getDateParameter("from_date");
        if (date1 == null) {
            day = this.getIntParameter("day", 0);
            month = this.getIntParameter("month", 0);
            year = this.getIntParameter("year", 0);
            if (day > 0 && month > 0 && year > 0) {
                dateCal = Calendar.getInstance();
                dateCal.set(year, month - 1, day);
                date1 = dateCal.getTime();
            }
        }
        if ((date2 = this.getDateParameter("to_date")) == null) {
            day = this.getIntParameter("to_day", 0);
            month = this.getIntParameter("to_month", 0);
            year = this.getIntParameter("to_year", 0);
            if (day > 0 && month > 0 && year > 0) {
                dateCal = Calendar.getInstance();
                dateCal.set(year, month - 1, day);
                date2 = dateCal.getTime();
            }
        }
        this.checkPeriod(date1, date2);
        if (this.cid <= 0 || newStatus < 0) {
            throw new BGIllegalArgumentException();
        }
        if (date1 == null) {
            throw new BGMessageException("\u041d\u0435 \u0437\u0430\u0434\u0430\u043d\u0430 \u0434\u0430\u0442\u0430 \u043d\u0430\u0447\u0430\u043b\u0430 \u0441\u0442\u0430\u0442\u0443\u0441\u0430.");
        }
        int currentStatus = contract.getStatus();
        if (!changeRules.isStatusChangeAllow(currentStatus, newStatus)) {
            throw new BGMessageException("\u0414\u0430\u043d\u043d\u044b\u0439 \u043f\u0435\u0440\u0435\u0445\u043e\u0434 \u0437\u0430\u043f\u0440\u0435\u0449\u0451\u043d.");
        }
        if (dateList != null && !dateList.contains(date1) || fromDate != null && !TimeUtils.dateBeforeOrEq(fromDate, date1)) {
            throw new BGMessageException("\u041f\u0435\u0440\u0435\u0445\u043e\u0434 \u0441 \u0434\u0430\u043d\u043d\u043e\u0439 \u0434\u0430\u0442\u044b \u0437\u0430\u043f\u0440\u0435\u0449\u0451\u043d.");
        }
        if (dateToList != null && !dateToList.contains(date2)) {
            throw new BGMessageException("\u041f\u0435\u0440\u0435\u0445\u043e\u0434 \u0414\u041e \u0434\u0430\u043d\u043d\u043e\u0439 \u0434\u0430\u0442\u044b \u0437\u0430\u043f\u0440\u0435\u0449\u0451\u043d.");
        }
        ContractStatus status = new ContractStatus();
        status.setContractId(this.cid);
        status.setStatus(newStatus);
        status.setDateFrom(date1);
        status.setDateTo(date2);
        status.setComment(comment);
        Calendar closedDate = null;
        closedDate = ClosedDateChecker.getClosePeriodDateIfChecking("ActionContractStatus", this.mid, this.userId);
        if (closedDate != null) {
            ClosedDateChecker.checkDatesForUpdate(closedDate, null, null, date1, date2);
        }
        ContractStatusManager statusManager = new ContractStatusManager(this.con);
        statusManager.changeStatus(status.clone(), -1);
    }

    public void ActionContractStatusCancelAction(Contract contract, Date curdate, WebStatusChangeRules changeRules, Set<Integer> changeableStatusSet) throws SQLException, BGException {
        boolean canCancel = false;
        ContractStatusManager statusManager = new ContractStatusManager(this.con);
        for (ContractStatus status : statusManager.getStatusList(this.cid)) {
            if (!TimeUtils.dateBefore(curdate, status.getDateFrom())) continue;
            if (!changeableStatusSet.contains(status.getStatus())) {
                throw new BGMessageException("\u0417\u0430\u043f\u043b\u0430\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0430 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0430 \u043d\u0435\u043f\u0435\u0440\u0435\u043a\u0440\u044b\u0432\u0430\u0435\u043c\u043e\u0433\u043e \u0441\u0442\u0430\u0442\u0443\u0441\u0430.");
            }
            canCancel = true;
        }
        if (!canCancel) {
            throw new BGMessageException("\u041d\u0435\u0447\u0435\u0433\u043e \u043e\u0442\u043c\u0435\u043d\u044f\u0442\u044c.");
        }
        int newStatus = contract.getStatus();
        Date date2 = null;
        String comment = "\u0418\u0437\u043c\u0435\u043d\u0435\u043d\u043e \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u0435\u043c (\u043e\u0442\u043c\u0435\u043d\u0430 \u0441\u043c\u0435\u043d\u044b \u0441\u0442\u0430\u0442\u0443\u0441\u0430)";
        ContractStatus status = new ContractStatus();
        status.setContractId(this.cid);
        status.setStatus(newStatus);
        status.setDateFrom(curdate);
        status.setDateTo(date2);
        status.setComment(comment);
        Calendar closedDate = null;
        closedDate = ClosedDateChecker.getClosePeriodDateIfChecking("ActionContractStatus", this.mid, this.userId);
        if (closedDate != null) {
            ClosedDateChecker.checkDatesForUpdate(closedDate, null, null, curdate, date2);
        }
        statusManager.changeStatus(status.clone(), -1);
    }
}

