/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.contract.action.web;

import bitel.billing.server.contract.action.base.ActionBase;
import bitel.billing.server.contract.bean.PersonalTariff;
import bitel.billing.server.contract.bean.PersonalTariffManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractTariff;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractTariffGroup;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractTariffDao;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractTariffGroupDao;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.events.CancelTariffEvent;
import ru.bitel.bgbilling.kernel.event.events.ChangeTariffByTaskEvent;
import ru.bitel.bgbilling.kernel.event.events.ContractTariffDeleteEvent;
import ru.bitel.bgbilling.kernel.event.events.ContractTariffUpdateEvent;
import ru.bitel.bgbilling.kernel.event.events.GetChangeTariffDatesEvent;
import ru.bitel.bgbilling.kernel.event.events.GetTariffListEvent;
import ru.bitel.bgbilling.kernel.tariff.common.bean.TariffGroup;
import ru.bitel.bgbilling.kernel.tariff.common.bean.TariffGroupTariff;
import ru.bitel.bgbilling.kernel.tariff.common.bean.TariffPlan;
import ru.bitel.bgbilling.kernel.tariff.server.bean.TariffGroupDao;
import ru.bitel.bgbilling.kernel.tariff.server.bean.TariffPlanDao;
import ru.bitel.bgbilling.kernel.tariff.server.event.ContractTariffChangedEvent;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Sorter;

public class ActionChangeTariff
extends ActionBase {
    private TariffPlanDao tariffPlanDao = null;
    private TariffGroupDao tariffGroupDao = null;
    private ContractTariffGroupDao contractTariffGroupDao = null;
    private Map<Integer, TariffPlan> tariffMap = null;
    private List<ContractTariff> contractTariffList = null;
    private List<PersonalTariff> personalTariffList = null;
    private int step = 0;
    int fromTariffId = -1;
    int toTariffId = -1;
    String toTariffTitle = null;

    @Override
    public void doAction() throws SQLException, BGException {
        this.tariffPlanDao = new TariffPlanDao(this.con);
        this.tariffGroupDao = new TariffGroupDao(this.con);
        this.contractTariffGroupDao = new ContractTariffGroupDao(this.con);
        this.tariffMap = this.tariffPlanDao.getTariffPlanMap();
        try (ContractTariffDao contractTariffDao = new ContractTariffDao(this.con);){
            this.fromTariffId = this.getIntParameter("from_tariff", -1);
            this.toTariffId = this.getIntParameter("to_tariff", -1);
            this.step = this.getIntParameter("step", 0);
            String command = this.getParameter("command", "");
            if ("change".equals(command)) {
                if (this.step == 0) {
                    if (this.toTariffId == -1) {
                        this.dataMap.put("error", "The tariff has not been chosen");
                        throw new BGException("\u041d\u0435 \u0431\u044b\u043b \u0432\u044b\u0431\u0440\u0430\u043d \u0442\u0430\u0440\u0438\u0444");
                    }
                    TariffPlan tariffPlan = this.tariffMap.get(this.toTariffId);
                    if (tariffPlan != null) {
                        this.toTariffTitle = tariffPlan.isUseTitleInWeb() ? tariffPlan.getTitle() : tariffPlan.getTitleWeb();
                    }
                    this.step = 1;
                } else {
                    this.changeTariff(contractTariffDao);
                    this.step = 0;
                }
            } else if ("cancel".equals(command)) {
                this.cancelChangeTariif(contractTariffDao);
            }
            this.contractTariffList = contractTariffDao.list(this.cid, null);
            this.personalTariffList = new PersonalTariffManager(this.con).getPersonalTariffList(this.cid);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage());
            throw new BGMessageException(e.getMessage());
        }
        this.setData();
    }

    private void cancelChangeTariif(ContractTariffDao contractTariffDao) throws BGException {
        int contractTariffId = this.getIntParameter("contractTariffId", -1);
        ContractTariff contractTariff = (ContractTariff)contractTariffDao.get(contractTariffId);
        if (contractTariff == null) {
            this.dataMap.put("error", "\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u0437\u0430\u043f\u0438\u0441\u044c \u043e \u0442\u0430\u0440\u0438\u0444\u0435 (contractTariffId=" + contractTariffId + ")");
            throw new BGException("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u0437\u0430\u043f\u0438\u0441\u044c \u043e \u0442\u0430\u0440\u0438\u0444\u0435 (contractTariffId=" + contractTariffId + ")");
        }
        if (contractTariff.getContractId() != this.cid) {
            this.dataMap.put("error", "\u042d\u0442\u043e \u043d\u0435 \u0432\u0430\u0448 \u0442\u0430\u0440\u0438\u0444");
            throw new BGException("\u042d\u0442\u043e \u043d\u0435 \u0432\u0430\u0448 \u0442\u0430\u0440\u0438\u0444");
        }
        if (contractTariff.getReplacedFromContractTariffId() <= 0) {
            this.dataMap.put("error", "\u041d\u0435\u0442 \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u0438 \u043d\u0430 \u0447\u0442\u043e \u043e\u0442\u043c\u0435\u043d\u044f\u0442\u044c");
            throw new BGException("\u041d\u0435\u0442 \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u0438 \u043d\u0430 \u0447\u0442\u043e \u043e\u0442\u043c\u0435\u043d\u044f\u0442\u044c");
        }
        ContractTariff contractTariffPrevious = (ContractTariff)contractTariffDao.get(contractTariff.getReplacedFromContractTariffId());
        if (contractTariffPrevious == null) {
            this.dataMap.put("error", "\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u0437\u0430\u043f\u0438\u0441\u044c \u043e \u043f\u0440\u0435\u0434\u044b\u0434\u0443\u0449\u0435\u043c \u0442\u0430\u0440\u0438\u0444\u0435 (contractTariffId=" + contractTariff.getReplacedFromContractTariffId() + ")");
            throw new BGException("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u0437\u0430\u043f\u0438\u0441\u044c \u043e \u043f\u0440\u0435\u0434\u044b\u0434\u0443\u0449\u0435\u043c \u0442\u0430\u0440\u0438\u0444\u0435 (contractTariffId=" + contractTariff.getReplacedFromContractTariffId() + ")");
        }
        CancelTariffEvent event = new CancelTariffEvent((int)this.userId, this.cid, contractTariff, contractTariffPrevious);
        event = EventProcessor.getInstance().request(event);
        if (Utils.notBlankString(event.getError())) {
            this.dataMap.put("error", event.getError());
            throw new BGException(event.getError());
        }
        if (Utils.notBlankString(event.getMessage())) {
            this.setMsg(event.getMessage());
            this.dataMap.put("message", event.getMessage());
        }
        if (!event.isProcessed()) {
            contractTariffPrevious.getPeriod().setDateTo(null);
            contractTariffDao.update(contractTariffPrevious);
            contractTariffDao.delete(contractTariff.getId());
        }
        this.context.publishAfterCommit(new ContractTariffChangedEvent(this.cid));
        this.context.publishAfterCommit(new ContractTariffUpdateEvent((int)this.userId, this.cid, contractTariffPrevious, false));
        this.context.publishAfterCommit(new ContractTariffDeleteEvent(this.userId, this.cid, contractTariff.getId()));
    }

    private void changeTariff(ContractTariffDao contractTariffDao) throws BGException {
        boolean changeAllow;
        TariffGroup tariffGroup;
        ContractTariffGroup contractTariffGroup;
        Calendar fromDate = TimeUtils.convertDateToCalendar(this.getDateParameter("from_date"));
        if (this.toTariffId == -1) {
            this.dataMap.put("error", "The tariff has not been chosen");
            throw new BGException("\u041d\u0435 \u0431\u044b\u043b \u0432\u044b\u0431\u0440\u0430\u043d \u0442\u0430\u0440\u0438\u0444");
        }
        TariffPlan toTariff = this.tariffMap.get(this.toTariffId);
        if (toTariff == null) {
            this.dataMap.put("error", "Not found tariff with id=" + this.toTariffId);
            throw new BGException("Not found tariff with id=" + this.toTariffId);
        }
        if (!toTariff.isUsed()) {
            this.dataMap.put("error", "Tariff not using");
            throw new BGException("Tariff not using");
        }
        ContractTariff contractTariff = (ContractTariff)contractTariffDao.get(this.fromTariffId);
        if (contractTariff == null || contractTariff.getContractId() != this.cid) {
            this.dataMap.put("error", "Not found tariff with id=" + this.fromTariffId);
            throw new BGException("Not found tariff with id=" + this.fromTariffId);
        }
        int tariffGroupId = contractTariff.getTariffGroupId();
        if (tariffGroupId < 0 && (contractTariffGroup = (ContractTariffGroup)this.contractTariffGroupDao.get(this.cid)) != null) {
            tariffGroupId = contractTariffGroup.getTariffGroupId();
        }
        if ((tariffGroup = (TariffGroup)this.tariffGroupDao.get(tariffGroupId)) == null) {
            this.dataMap.put("error", "Not found tariff group with id=" + tariffGroupId);
            throw new BGException("Not found tariff group with id=" + tariffGroupId);
        }
        if (!this.tariffGroupGetPlanIdList(tariffGroup).contains(this.toTariffId)) {
            this.dataMap.put("error", "Tariff not in group");
            throw new BGException("Tariff not in group");
        }
        GregorianCalendar now = new GregorianCalendar();
        TariffGroupTariff tariffGroupTariff = ActionChangeTariff.getTariffGroupTariff(tariffGroup, this.toTariffId);
        if (!TimeUtils.dateInRange(now.getTime(), tariffGroupTariff.getDate1(), tariffGroupTariff.getDate2())) {
            this.dataMap.put("error", "Tariff period in group invalid");
            throw new BGException("Tariff period  in group invalid");
        }
        if (fromDate == null) {
            this.dataMap.put("error", "From date not defined");
            throw new BGException("From date not defined");
        }
        ContractTariff fromContractTariff = this.getFromTariff(contractTariffDao, fromDate);
        GetChangeTariffDatesEvent dateListEvent = new GetChangeTariffDatesEvent(this.userId, this.cid, tariffGroup, new Date(), fromContractTariff.getTariffPlanId(), this.toTariffId);
        dateListEvent = EventProcessor.getInstance().request(dateListEvent);
        int transferMode = tariffGroup.getTransferMode();
        boolean bl = changeAllow = transferMode == 1 || transferMode == 4 && TimeUtils.dateBefore(new GregorianCalendar(), fromDate) || transferMode == 3 && fromDate.get(5) == 1 || transferMode == 2 && fromDate.get(7) == 2;
        if (dateListEvent.getDateList() != null) {
            Date date;
            changeAllow = false;
            Iterator<Date> iterator = dateListEvent.getDateList().iterator();
            while (iterator.hasNext() && !(changeAllow = TimeUtils.dateEqual(fromDate, TimeUtils.convertDateToCalendar(date = iterator.next())))) {
            }
        }
        if (changeAllow) {
            ChangeTariffByTaskEvent event = new ChangeTariffByTaskEvent(this.userId, this.cid, tariffGroup, fromContractTariff, toTariff, fromDate.getTime());
            event = EventProcessor.getInstance().request(event);
            if (Utils.notBlankString(event.getError())) {
                this.dataMap.put("error", event.getError());
                throw new BGMessageException(event.getError());
            }
            if (Utils.notBlankString(event.getMessage())) {
                this.setMsg(event.getMessage());
                this.dataMap.put("message", event.getMessage());
            }
            ContractTariff newTariff = null;
            if (!event.isProcessed() && fromContractTariff != null) {
                fromContractTariff.getPeriod().setDateTo(TimeUtils.getPrevDay(fromDate).getTime());
                if (TimeUtils.dateBefore(fromContractTariff.getPeriod().getDateTo(), fromContractTariff.getPeriod().getDateFrom())) {
                    contractTariffDao.delete(fromContractTariff.getId());
                } else {
                    contractTariffDao.update(fromContractTariff);
                }
                newTariff = new ContractTariff();
                newTariff.setContractId(this.cid);
                newTariff.getPeriod().setDateFrom(fromDate.getTime());
                newTariff.setComment("\u0421\u043c\u0435\u043d\u0430 \u0442\u0430\u0440\u0438\u0444\u0430 \u0447\u0435\u0440\u0435\u0437 Web");
                newTariff.setPosition(tariffGroup.getPos());
                newTariff.setTariffGroupId(fromContractTariff.getTariffGroupId());
                newTariff.setTariffPlanId(this.toTariffId);
                newTariff.setReplacedFromContractTariffId(fromContractTariff.getId());
                contractTariffDao.update(newTariff);
            }
            this.context.publishAfterCommit(new ContractTariffChangedEvent(this.cid));
            if (newTariff != null) {
                this.context.publishAfterCommit(new ContractTariffUpdateEvent((int)this.userId, this.cid, newTariff, true));
            }
        } else {
            log.error((Object)("Change tariff not allow from date " + TimeUtils.formatDate(fromDate)));
        }
    }

    private ContractTariff getFromTariff(ContractTariffDao contractTariffDao, Calendar fromDate) throws BGException {
        ContractTariff fromContractTariff = null;
        List<ContractTariff> onDateTariffList = contractTariffDao.list(this.cid, fromDate.getTime());
        for (ContractTariff contractTariff : onDateTariffList) {
            TariffGroup tariffGroup;
            ContractTariffGroup contractTariffGroup;
            if (contractTariff.getId() != this.fromTariffId) continue;
            int tariffGroupId = contractTariff.getTariffGroupId();
            if (tariffGroupId < 0 && (contractTariffGroup = (ContractTariffGroup)this.contractTariffGroupDao.get(this.cid)) != null) {
                tariffGroupId = contractTariffGroup.getTariffGroupId();
            }
            if ((tariffGroup = (TariffGroup)this.tariffGroupDao.get(tariffGroupId)) == null || contractTariff.getTariffPlanId() == this.toTariffId) continue;
            if (contractTariff.getPeriod().getDateTo() == null) {
                fromContractTariff = contractTariff;
                break;
            }
            this.dataMap.put("error", "Contract already have not closed tariff from this group");
            throw new BGException("Contract already have not closed tariff from this group");
        }
        return fromContractTariff;
    }

    private List<Integer> tariffGroupGetPlanIdList(TariffGroup tariffGroup) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        List<TariffGroupTariff> listTGT = tariffGroup.getPlanList();
        if (listTGT != null) {
            for (TariffGroupTariff tariffGroupTariff : listTGT) {
                result.add(tariffGroupTariff.getId());
            }
        }
        return result;
    }

    private static TariffGroupTariff getTariffGroupTariff(TariffGroup tariffGroup, int tariffId) throws BGException {
        List<TariffGroupTariff> listTGT = tariffGroup.getPlanList();
        if (listTGT != null) {
            for (TariffGroupTariff tariffGroupTariff : listTGT) {
                if (tariffGroupTariff.getId() != tariffId) continue;
                return tariffGroupTariff;
            }
        }
        throw new BGException("no tariff-id=" + tariffId + " in tariff group");
    }

    @Override
    protected void setDataForXslt() throws BGException {
        Element history = this.createElement(this.rootNode, "history");
        this.rootNode.setAttribute("step", String.valueOf(this.step));
        this.rootNode.setAttribute("to_tariff_title", this.toTariffTitle);
        this.rootNode.setAttribute("to_tariff", String.valueOf(this.toTariffId));
        Sorter<ContractTariff, PersonalTariff, Date> sorter = new Sorter<ContractTariff, PersonalTariff, Date>(this.contractTariffList, this.personalTariffList, true){

            @Override
            public Date getSecondValue(PersonalTariff personalTariff) {
                return personalTariff.getDate1().getTime();
            }

            @Override
            public Date getFirstValue(ContractTariff contractTariff) {
                return contractTariff.getPeriod().getDateFrom();
            }
        };
        while (sorter.hasNext()) {
            TariffGroup tariffGroup;
            ContractTariffGroup contractTariffGroup;
            int tariffPlanID;
            TariffPlan plan;
            Element row = this.createElement(history, "row");
            Date date1 = null;
            Date date2 = null;
            String type = null;
            Object next = sorter.getNext();
            if (next instanceof PersonalTariff) {
                date1 = TimeUtils.convertCalendarToDate(((PersonalTariff)next).getDate1());
                date2 = TimeUtils.convertCalendarToDate(((PersonalTariff)next).getDate2());
                row.setAttribute("tariff", ((PersonalTariff)next).getTitle());
                type = "1";
            } else if (next instanceof ContractTariff) {
                date1 = ((ContractTariff)next).getPeriod().getDateFrom();
                date2 = ((ContractTariff)next).getPeriod().getDateTo();
                type = "0";
            }
            row.setAttribute("type", type);
            row.setAttribute("date1", TimeUtils.format(date1, "dd.MM.yyyy"));
            row.setAttribute("date2", TimeUtils.format(date2, "dd.MM.yyyy"));
            Date now = new Date();
            boolean active = TimeUtils.dateBeforeOrEq(date1, now) && (date2 == null || TimeUtils.dateBeforeOrEq(now, date2));
            row.setAttribute("active", active ? "1" : "0");
            if (next instanceof PersonalTariff) continue;
            ContractTariff contractTariff = (ContractTariff)next;
            row.setAttribute("comment", contractTariff.getComment());
            boolean canCancel = contractTariff.getReplacedFromContractTariffId() > 0 && TimeUtils.dateBefore(now, contractTariff.getPeriod().getDateFrom());
            row.setAttribute("canCancel", canCancel ? "1" : "0");
            row.setAttribute("contractTariffId", String.valueOf(contractTariff.getId()));
            row.setAttribute("tariffId", String.valueOf(contractTariff.getTariffPlanId()));
            if (canCancel) {
                try (ContractTariffDao contractTariffDao = new ContractTariffDao(this.con);){
                    ContractTariff ct = (ContractTariff)contractTariffDao.get(contractTariff.getReplacedFromContractTariffId());
                    TariffPlan previousTariff = (TariffPlan)this.tariffPlanDao.get(ct.getTariffPlanId());
                    row.setAttribute("previousTariffTitle", previousTariff.isUseTitleInWeb() ? previousTariff.getTitle() : previousTariff.getTitleWeb());
                }
                catch (Exception e) {
                    log.error((Object)"error", (Throwable)e);
                }
            }
            if ((plan = this.tariffMap.get(tariffPlanID = contractTariff.getTariffPlanId())) == null) continue;
            row.setAttribute("tariff", plan.isUseTitleInWeb() ? plan.getTitle() : plan.getTitleWeb());
            if (contractTariff.getPeriod().getDateTo() != null || contractTariff.getPeriod().getDateFrom() != null && TimeUtils.dateBefore(now, contractTariff.getPeriod().getDateFrom())) continue;
            int tariffGroupId = contractTariff.getTariffGroupId();
            if (tariffGroupId < 0 && (contractTariffGroup = (ContractTariffGroup)this.contractTariffGroupDao.get(this.cid)) != null) {
                tariffGroupId = contractTariffGroup.getTariffGroupId();
            }
            if (tariffGroupId < 1 || (tariffGroup = (TariffGroup)this.tariffGroupDao.get(tariffGroupId)) == null) continue;
            int transferMode = tariffGroup.getTransferMode();
            List<Object> changeTariffList = new ArrayList();
            List<Object> changeTariffDate = new ArrayList();
            List<TariffGroupTariff> tariffList = tariffGroup.getPlanList();
            for (TariffGroupTariff tariffGroupTariff : tariffList) {
                TariffPlan toPlan = this.tariffMap.get(tariffGroupTariff.getId());
                if (toPlan == null || plan.getId() == toPlan.getId() || !toPlan.isUsed() || !TimeUtils.dateInRange(now, tariffGroupTariff.getDate1(), tariffGroupTariff.getDate2())) continue;
                changeTariffList.add(toPlan);
            }
            GetTariffListEvent tariffListEvent = new GetTariffListEvent(this.cid, contractTariff, tariffGroup, (int)this.userId);
            tariffListEvent = EventProcessor.getInstance().request(tariffListEvent);
            List<TariffPlan> tariffListFromEvent = tariffListEvent.getTariffList();
            if (tariffListFromEvent != null) {
                changeTariffList = tariffListFromEvent;
            }
            if (changeTariffList.size() == 0) continue;
            if (this.step == 1 && contractTariff.getId() == this.fromTariffId) {
                this.rootNode.setAttribute("from_tariff", String.valueOf(contractTariff.getTariffPlanId()));
                GetChangeTariffDatesEvent event = new GetChangeTariffDatesEvent(this.userId, this.cid, tariffGroup, new Date(), contractTariff.getTariffPlanId(), this.toTariffId);
                event = EventProcessor.getInstance().request(event);
                if (event.getDateList() != null) {
                    changeTariffDate = event.getDateList();
                } else {
                    GregorianCalendar calendar = new GregorianCalendar();
                    if (transferMode != 1) {
                        if (transferMode == 4) {
                            ((Calendar)calendar).add(6, 1);
                        } else if (transferMode == 2) {
                            ((Calendar)calendar).add(3, 1);
                            calendar.set(7, 2);
                        } else {
                            ((Calendar)calendar).add(2, 1);
                            calendar.set(5, 1);
                        }
                    }
                    Calendar calendar2 = (Calendar)((Calendar)calendar).clone();
                    calendar2.add(6, tariffGroup.getDaysForward());
                    while (calendar.before(calendar2)) {
                        changeTariffDate.add(calendar.getTime());
                        if (transferMode == 1 || transferMode == 4) {
                            ((Calendar)calendar).add(6, 1);
                            continue;
                        }
                        if (transferMode == 2) {
                            ((Calendar)calendar).add(3, 1);
                            continue;
                        }
                        ((Calendar)calendar).add(2, 1);
                    }
                }
                if (changeTariffDate.size() == 0) continue;
            }
            row.setAttribute("group", String.valueOf(tariffGroup.getId()));
            Element tariffListEl = this.createElement(row, "tariff_list");
            for (TariffPlan tariffPlan : changeTariffList) {
                Element element = this.createElement(tariffListEl, "item");
                element.setAttribute("id", String.valueOf(tariffPlan.getId()));
                element.setAttribute("title", tariffPlan.isUseTitleInWeb() ? tariffPlan.getTitle() : tariffPlan.getTitleWeb());
            }
            Element dateListEl = this.createElement(row, "date_list");
            for (Date date : changeTariffDate) {
                Element item = this.createElement(dateListEl, "item");
                item.setAttribute("value", TimeUtils.format(date, "dd.MM.yyyy"));
            }
        }
    }

    @Override
    protected void setDataToRequest() throws BGException {
        ArrayList list = new ArrayList();
        for (ContractTariff contractPlan : this.contractTariffList) {
            TariffGroup group;
            HashMap<String, Object> tarifPlanMap = new HashMap<String, Object>();
            list.add(tarifPlanMap);
            tarifPlanMap.put("date1", TimeUtils.format(contractPlan.getPeriod().getDateFrom(), "dd.MM.yyyy"));
            tarifPlanMap.put("date2", TimeUtils.format(contractPlan.getPeriod().getDateTo(), "dd.MM.yyyy"));
            GregorianCalendar now = new GregorianCalendar();
            boolean active = TimeUtils.dateBeforeOrEq(contractPlan.getPeriod().getDateFrom(), now.getTime()) && (contractPlan.getPeriod().getDateFrom() == null || TimeUtils.dateBeforeOrEq(now.getTime(), contractPlan.getPeriod().getDateTo()));
            tarifPlanMap.put("active", active ? "1" : "0");
            tarifPlanMap.put("comment", contractPlan.getComment());
            int tariffPlanID = contractPlan.getTariffPlanId();
            TariffPlan tariffPlan = this.tariffMap.get(tariffPlanID);
            if (tariffPlan == null) continue;
            tarifPlanMap.put("tariff", tariffPlan.getTitle());
            if (contractPlan.getPeriod().getDateTo() != null || contractPlan.getPeriod().getDateFrom() != null && TimeUtils.dateBefore(now.getTime(), contractPlan.getPeriod().getDateFrom()) || (group = (TariffGroup)this.tariffGroupDao.get(tariffPlanID)) == null) continue;
            int transferMode = group.getTransferMode();
            List<TariffPlan> changeTariffList = new ArrayList<TariffPlan>();
            List<Object> changeTariffDate = new ArrayList();
            List<TariffPlan> tariffList = this.tariffPlanDao.list(this.tariffGroupGetPlanIdList(group));
            for (TariffPlan toPlan : tariffList) {
                if (tariffPlan.getId() == toPlan.getId() || !toPlan.isUsed()) continue;
                changeTariffList.add(toPlan);
            }
            GetTariffListEvent tariffListEvent = new GetTariffListEvent(this.cid, contractPlan, group, (int)this.userId);
            tariffListEvent = EventProcessor.getInstance().request(tariffListEvent);
            List<TariffPlan> tariffListFromEvent = tariffListEvent.getTariffList();
            if (tariffListFromEvent != null) {
                changeTariffList = tariffListFromEvent;
            }
            if (changeTariffList.size() == 0) continue;
            GetChangeTariffDatesEvent event = new GetChangeTariffDatesEvent(this.userId, this.cid, group, new Date(), contractPlan.getTariffPlanId(), this.toTariffId);
            event = EventProcessor.getInstance().request(event);
            if (event.getDateList() != null) {
                changeTariffDate = event.getDateList();
            } else {
                if (transferMode != 1) {
                    if (transferMode == 4) {
                        ((Calendar)now).add(6, 1);
                    } else if (transferMode == 2) {
                        ((Calendar)now).add(3, 1);
                        now.set(7, 2);
                    } else {
                        ((Calendar)now).add(2, 1);
                        now.set(5, 1);
                    }
                }
                Calendar limitDate = (Calendar)((Calendar)now).clone();
                limitDate.add(6, group.getDaysForward());
                while (now.before(limitDate)) {
                    changeTariffDate.add(now.getTime());
                    if (transferMode == 1 || transferMode == 4) {
                        ((Calendar)now).add(6, 1);
                        continue;
                    }
                    if (transferMode == 2) {
                        ((Calendar)now).add(3, 1);
                        continue;
                    }
                    ((Calendar)now).add(2, 1);
                }
            }
            if (changeTariffDate.size() == 0) continue;
            tarifPlanMap.put("group", String.valueOf(group.getId()));
            tarifPlanMap.put("tariff_list", changeTariffList);
            tarifPlanMap.put("date_list", changeTariffDate);
        }
        this.dataMap.put("tariffList", list);
    }
}

