/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.contract.action;

import bitel.billing.server.contract.action.base.ActionBase;
import bitel.billing.server.contract.bean.ContractParameterManager;
import bitel.billing.server.contract.bean.ParameterHistoryEntry;
import java.sql.SQLException;
import java.util.List;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.kernel.container.security.server.PermissionChecker;
import ru.bitel.common.TimeUtils;

public class ActionGetParameterHistory
extends ActionBase {
    @Override
    public void doAction() throws SQLException, BGException, BGException {
        int pid = this.getIntParameter("pid", -1);
        if (this.cid <= 0 || pid <= 0) {
            throw new BGIllegalArgumentException();
        }
        ContractParameterManager man = new ContractParameterManager(this.con);
        List<ParameterHistoryEntry> history = man.getParameterHistory(this.cid, pid);
        Element table = this.createElement(this.rootNode, "table");
        Element data = this.createElement(table, "data");
        for (ParameterHistoryEntry entry : history) {
            Element row = this.createElement(data, "row");
            boolean parameterAllowed = PermissionChecker.checkReadContractParameter(pid, (int)this.userId);
            row.setAttribute("value", parameterAllowed ? (entry.getValue() == null ? "\u0423\u0414\u0410\u041b\u0415\u041d\u041e" : entry.getValue()) : "<\u0421\u041a\u0420\u042b\u0422\u041e>");
            row.setAttribute("who", entry.getUser());
            row.setAttribute("when", TimeUtils.format(entry.getDate(), "dd.MM.yyyy HH:mm:ss"));
        }
    }
}

