/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.contract.action;

import bitel.billing.server.ApplicationModule;
import bitel.billing.server.contract.action.base.ActionBase;
import bitel.billing.server.contract.bean.ContractGroup;
import bitel.billing.server.contract.bean.ContractGroupManager;
import bitel.billing.server.contract.bean.ContractModuleManager;
import bitel.billing.server.contract.bean.PersonalTariff;
import bitel.billing.server.contract.bean.PersonalTariffManager;
import bitel.billing.server.util.Config;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.security.server.ModuleAction;
import ru.bitel.bgbilling.kernel.container.security.server.PermissionChecker;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.ContractBalance;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.BalanceDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.ChargeDao;
import ru.bitel.bgbilling.kernel.contract.plugin.PluginTreeNodeInterface;
import ru.bitel.bgbilling.kernel.contract.status.server.StatusCache;
import ru.bitel.bgbilling.kernel.module.common.bean.BGModule;
import ru.bitel.bgbilling.kernel.plugin.common.BGPlugInElement;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginManagerServer;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginServer;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class ActionContractInfo
extends ActionBase {
    @Override
    public void doAction() throws SQLException, BGException {
        boolean chekPermission;
        HashMap<String, String> mapRequest = new HashMap<String, String>();
        int cid = this.getIntParameter("cid", -1);
        if (cid < 0) {
            cid = this.getIntParameter("id", -1);
        }
        if (cid < 0) {
            return;
        }
        long gr = 0L;
        GregorianCalendar now = new GregorianCalendar();
        Calendar calFrom = TimeUtils.getStartMonth(now);
        Calendar calTo = (Calendar)calFrom.clone();
        calTo.add(2, 1);
        calTo.add(14, -1);
        ContractDao contractDao = new ContractDao(this.con, this.userId);
        Contract contract = (Contract)contractDao.get(cid);
        contractDao.close();
        Element contractElement = this.createElement(this.rootNode, "contract");
        if (contract != null) {
            gr = contract.getGroups();
            contractElement.setAttribute("gr", String.valueOf(contract.getGroups()));
            contractElement.setAttribute("domainId", String.valueOf(contract.getDomainId()));
            contractElement.setAttribute("title", contract.getTitle());
            contractElement.setAttribute("limit", Utils.formatBigDecimalSumm(contract.getBalanceLimit()));
            contractElement.setAttribute("mode", String.valueOf(contract.getBalanceMode()));
            contractElement.setAttribute("comment", contract.getComment());
            contractElement.setAttribute("date1", TimeUtils.formatDate(contract.getDateFrom()));
            contractElement.setAttribute("date2", TimeUtils.formatDate(contract.getDateTo()));
            contractElement.setAttribute("fc", String.valueOf(contract.getPersonType()));
            contractElement.setAttribute("del", String.valueOf(contract.isHidden() ? 1 : 0));
            contractElement.setAttribute("status", StatusCache.getInstance().getStatusTitle(contract.getStatus()));
            if (contract.getSuperCid() == 0) {
                contractElement.setAttribute("hierarchy", "independent");
            } else if (contract.getSuperCid() == -1) {
                contractElement.setAttribute("hierarchy", "super");
                String query = "SELECT sub_mode FROM contract WHERE scid=?";
                PreparedStatement ps = this.con.prepareStatement(query);
                ps.setInt(1, cid);
                ResultSet rs = ps.executeQuery();
                int dep = 0;
                int indep = 0;
                while (rs.next()) {
                    int mode = rs.getInt(1);
                    if (mode == 0) {
                        ++dep;
                        continue;
                    }
                    ++indep;
                }
                rs.close();
                ps.close();
                contractElement.setAttribute("hierarchyDep", String.valueOf(dep));
                contractElement.setAttribute("hierarchyIndep", String.valueOf(indep));
            } else if (contract.getBalanceSubMode() == 0) {
                contractElement.setAttribute("hierarchy", "depend_sub");
            } else if (contract.getBalanceSubMode() == 1) {
                contractElement.setAttribute("hierarchy", "independ_sub");
            }
        }
        int objectCountAll = 0;
        int objectCountActive = 0;
        PreparedStatement ps = this.con.prepareStatement("SELECT ( isNUll(date1) OR not date1>now() ) AND ( isNull(date2) OR not date2<now() ) FROM object WHERE cid=?");
        ps.setInt(1, cid);
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            if (rs.getBoolean(1)) {
                ++objectCountActive;
            }
            ++objectCountAll;
        }
        contractElement.setAttribute("objects", objectCountActive + "/" + objectCountAll);
        rs.close();
        ps.close();
        ps = this.con.prepareStatement("SELECT count( * ) FROM contract_comment WHERE cid=?");
        ps.setInt(1, cid);
        rs = ps.executeQuery();
        while (rs.next()) {
            contractElement.setAttribute("comments", rs.getString(1));
        }
        rs.close();
        ps.close();
        Element info = this.createElement(this.rootNode, "info");
        Element groups = this.createElement(info, "groups");
        for (ContractGroup contractGroup : new ContractGroupManager(this.con).getGroupList(gr)) {
            this.addListItem((Node)groups, contractGroup.getId(), contractGroup.getTitle());
        }
        Element tariff = this.createElement(info, "tariff");
        mapRequest.clear();
        mapRequest.put("action", "PersonalTariffTable");
        mapRequest.put("module", "contract.tariff");
        ModuleAction action = PermissionChecker.getInstance().findAction(new String[]{"0"}, mapRequest);
        boolean bl = chekPermission = Setup.getSetup().getInt("bgsecure.check", 1) == 0;
        if (chekPermission || action == null || PermissionChecker.getInstance().checkActionAllow(mapRequest, "0", action, (int)this.userId, cid) == null) {
            for (PersonalTariff personalTariff : new PersonalTariffManager(this.con).getPersonalTariffList(cid, new Date())) {
                this.addListItem((Node)tariff, personalTariff.getId(), "\u041f\u0422: " + personalTariff.getTitle());
            }
        }
        mapRequest.clear();
        mapRequest.put("action", "ContractTariffPlans");
        mapRequest.put("module", "contract");
        action = PermissionChecker.getInstance().findAction(new String[]{"0"}, mapRequest);
        if (chekPermission || action == null || PermissionChecker.getInstance().checkActionAllow(mapRequest, "0", action, (int)this.userId, cid) == null) {
            String query = "SELECT t2.id, title FROM contract_tariff AS t1, tariff_plan AS t2 WHERE  cid=? AND tpid=t2.id AND emid=0 AND eid=0 AND ( isNull( date1 ) OR date1<=CURDATE() ) AND ( isNull( date2 ) OR date2>=CURDATE() )";
            ps = this.con.prepareStatement(query);
            ps.setInt(1, cid);
            rs = ps.executeQuery();
            while (rs.next()) {
                this.addListItem((Node)tariff, rs.getInt(1), rs.getString(2));
            }
            rs.close();
            ps.close();
        }
        mapRequest.clear();
        mapRequest.put("action", "ContractBalanceGeneral");
        mapRequest.put("module", "contract");
        action = PermissionChecker.getInstance().findAction(new String[]{"0"}, mapRequest);
        if (chekPermission || action == null || PermissionChecker.getInstance().checkActionAllow(mapRequest, "0", action, (int)this.userId, cid) == null) {
            int yy = now.get(1);
            int mm = now.get(2) + 1;
            Conf conf = this.setup.getConfig(0, Conf.class);
            Element balance = this.createElement(info, "balance");
            ContractBalance contractBalance = new BalanceDao(this.con).getContractBalance(cid, yy, mm);
            GregorianCalendar paybackFrom = new GregorianCalendar();
            paybackFrom.set(contractBalance.getYear(), contractBalance.getMonth() - 1, 1, 0, 0, 0);
            Calendar paybackTo = (Calendar)((Calendar)paybackFrom).clone();
            paybackTo.add(2, 1);
            ChargeDao chargeDao = new ChargeDao(this.con);
            BigDecimal payback = chargeDao.getSum(cid, paybackFrom.getTime(), paybackTo.getTime(), 0, 1, true);
            chargeDao.close();
            balance.setAttribute("summa1", Utils.formatBigDecimalSumm(contractBalance.getIncomingSaldo()));
            balance.setAttribute("summa2", Utils.formatBigDecimalSumm(contractBalance.getPayments()));
            balance.setAttribute("summa3", Utils.formatBigDecimalSumm(contractBalance.getAccounts()));
            balance.setAttribute("summa4", Utils.formatBigDecimalSumm(contractBalance.getCharges().subtract(payback)));
            balance.setAttribute("summa5", Utils.formatBigDecimalSumm(contractBalance.toBalanceWithoutReserves()));
            balance.setAttribute("summa6", Utils.formatBigDecimalSumm(contractBalance.toBalance()));
            balance.setAttribute("summa7", Utils.formatBigDecimalSumm(payback));
            balance.setAttribute("summa8", Utils.formatBigDecimalSumm(contractBalance.getReserve()));
            balance.setAttribute("yy", String.valueOf(contractBalance.getYear()));
            balance.setAttribute("mm", String.valueOf(contractBalance.getMonth()));
            if (conf != null && (conf.groups & gr) > 0L) {
                balance.setAttribute("outSaldo", Utils.formatCost(contractBalance.toSaldo()));
            }
        }
        Element modules = this.createElement(info, "modules");
        for (BGModule module : new ContractModuleManager(this.con).getContractModules(cid)) {
            Element item = this.createElement(modules, "item");
            item.setAttribute("id", String.valueOf(module.getId()));
            item.setAttribute("title", module.getTitle());
            item.setAttribute("package", module.getInstalledModule().getPackageClient());
            String className = module.getInstalledModule().getPackageServer() + ".Module";
            ApplicationModule moduleClass = Utils.newInstance(className, ApplicationModule.class);
            if (moduleClass == null) continue;
            item.setAttribute("status", moduleClass.getStatus(this.con, module.getId(), cid));
        }
        mapRequest.clear();
        mapRequest.put("action", "ContractScriptTable");
        mapRequest.put("module", "contract");
        action = PermissionChecker.getInstance().findAction(new String[]{"0"}, mapRequest);
        if (chekPermission || action == null || PermissionChecker.getInstance().checkActionAllow(mapRequest, "0", action, (int)this.userId, cid) == null) {
            Element script = this.createElement(info, "script");
            String query = "SELECT s.id, s.title FROM contract_script cs LEFT JOIN script s ON cs.script_id=s.id WHERE cid=? AND ( isNull( date1 ) OR date1<=CURDATE() ) AND ( isNull( date2 ) OR date2>=CURDATE() )";
            ps = this.con.prepareStatement(query);
            ps.setInt(1, cid);
            rs = ps.executeQuery();
            while (rs.next()) {
                this.addListItem((Node)script, rs.getInt(1), rs.getString(2));
            }
            ps.close();
            rs.close();
        }
        Element plugins = this.createElement(info, "plugins");
        for (BGPlugInElement extension : BGPluginManagerServer.getManager().getExtensions("bitel.billing.server.contract.action.ActionContractInfo", true)) {
            Element extensionElement = extension.getElement();
            BGPluginServer plugin = (BGPluginServer)extension.getPlugin();
            NodeList list = extensionElement.getElementsByTagName("treeNode");
            for (int index = 0; index < list.getLength(); ++index) {
                Element treeNode = (Element)list.item(index);
                try {
                    String key = plugin.getResourceString(treeNode.getAttribute("key"));
                    String className = treeNode.getAttribute("class");
                    PluginTreeNodeInterface node = (PluginTreeNodeInterface)Class.forName(className).newInstance();
                    Element item = this.createElement(plugins, "item");
                    item.setAttribute("key", key);
                    item.setAttribute("title", node.getTitle(this.context, cid));
                    item.setAttribute("value", node.getValue(this.context, cid));
                    continue;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    private static final class Conf
    extends Config {
        public final long groups;

        public Conf(int mid, ParameterMap moduleSetup, Setup serverSetup) {
            super(mid, moduleSetup, serverSetup);
            String groups = serverSetup.get("contract.balance.showOutSaldoGroups", null);
            this.groups = Utils.notBlankString(groups) ? Utils.enumToMask(groups) : 0L;
        }
    }
}

