/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.contract.action;

import bitel.billing.server.contract.ContractRemover;
import bitel.billing.server.contract.action.base.ActionBase;
import java.io.File;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.XMLUtils;

public class ActionArchiveInfo
extends ActionBase {
    @Override
    public void doAction() throws SQLException, BGException {
        Date date1 = this.getDateParameter("date1");
        Date date2 = this.getDateParameter("date2");
        String folder = this.getParameter("folder", "/");
        String fileMask = this.getParameter("mask", "");
        if (fileMask.length() == 0) {
            fileMask = null;
        }
        ContractRemover cr = new ContractRemover(this.setup, this.con, folder);
        Element table = this.createElement(this.rootNode, "table");
        Element data = this.createElement(table, "data");
        List<File> files = cr.getContractsFromArchive(fileMask);
        for (File arch : files) {
            String name = arch.getName();
            Date createTime = new Date(arch.lastModified());
            String lastModif = TimeUtils.format(createTime, "dd.MM.yyyy HH:mm:ss");
            if (date1 != null && date1.after(createTime) || date2 != null && date2.before(createTime)) continue;
            Element row = XMLUtils.createElement(data, "row");
            row.setAttribute("f0", name);
            row.setAttribute("f1", lastModif);
        }
    }
}

