/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.call.action;

import bitel.billing.server.call.action.base.ActionBase;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.common.Utils;

public class ActionUpdateRadiusInfo
extends ActionBase {
    @Override
    public void doAction() throws SQLException, BGException {
        int mid = this.getIntParameter("mid", -1);
        int lid = this.getIntParameter("lid", -1);
        String atribut = this.getParameter("atribut");
        String value = this.getParameter("value");
        String realm = this.getParameter("realm");
        int rpMode = this.getIntParameter("rp_mode", -1);
        String realmGroup = this.getParameter("realm_group");
        if (mid == -1 || lid <= 0 || atribut == null || value == null || rpMode < 0 || realmGroup == null) {
            return;
        }
        this.updateAttributes(lid, atribut, value, realm);
        this.updateAttributeSet(lid);
        this.updateRealmOptions(lid, rpMode, realmGroup);
    }

    protected final void updateAttributes(int lid, String atribut, String value, String realm) throws SQLException {
        List<String> atrValues = Utils.toList(atribut);
        List<String> namValues = Utils.toList(value);
        List<String> realmValues = Utils.toList(realm);
        String query = "DELETE FROM radius_pair_" + this.mid + " WHERE id=?";
        PreparedStatement ps = this.con.prepareStatement(query);
        ps.setInt(1, lid);
        ps.executeUpdate();
        ps.close();
        query = "INSERT INTO radius_pair_" + this.mid + " ( id, pair_name, pair_value, pair_realm ) VALUES ( ?, ?, ?, ? )";
        ps = this.con.prepareStatement(query);
        ps.setInt(1, lid);
        for (int i = 0; i < namValues.size(); ++i) {
            String nValue = namValues.size() > i ? namValues.get(i).trim() : "";
            String rValue = realmValues.size() > i ? realmValues.get(i).trim() : "";
            ps.setString(2, this.fromHexString(atrValues.get(i).trim()));
            ps.setString(3, this.fromHexString(nValue));
            ps.setString(4, this.fromHexString(rValue));
            ps.executeUpdate();
        }
        ps.close();
    }

    protected final void updateAttributeSet(int lid) throws SQLException {
        List<String> setIds = Utils.toList(this.getParameter("setIds"));
        List<String> setRealms = Utils.toList(this.getParameter("setRealms"));
        PreparedStatement ps = this.con.prepareStatement("DELETE FROM radius_pair_set_" + this.mid + " WHERE id=?");
        ps.setInt(1, lid);
        ps.executeUpdate();
        ps.close();
        ps = this.con.prepareStatement("INSERT INTO radius_pair_set_" + this.mid + " (id, set_id, realm) VALUES (?, ?, ?)");
        ps.setInt(1, lid);
        for (int i = 0; i < setIds.size(); ++i) {
            ps.setInt(2, Utils.parseInt(setIds.get(i)));
            ps.setString(3, this.fromHexString(setRealms.get(i)));
            ps.executeUpdate();
        }
        ps.close();
    }

    protected final void updateRealmOptions(int lid, int rpMode, String realmGroup) throws SQLException {
        String query = "UPDATE user_login_" + this.mid + " SET rp_mode=?, realm_group=? WHERE id=?";
        PreparedStatement ps = this.con.prepareStatement(query);
        ps.setInt(1, rpMode);
        ps.setString(2, realmGroup);
        ps.setInt(3, lid);
        ps.executeUpdate();
        ps.close();
    }

    protected final String fromHexString(String value) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < value.length(); i += 4) {
            String st = value.substring(i, i + 4);
            int f = Integer.parseInt(st, 16);
            buf.append((char)f);
        }
        return buf.toString();
    }
}

