/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.admin.action;

import bitel.billing.server.admin.action.base.ActionBase;
import bitel.billing.server.admin.bean.AddressCountry;
import bitel.billing.server.admin.bean.AddressManager;
import bitel.billing.server.admin.bean.AddressStruct;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.directory.address.AddressArea;
import ru.bitel.bgbilling.kernel.directory.address.AddressCity;
import ru.bitel.bgbilling.kernel.directory.address.AddressDirectoryManager;
import ru.bitel.bgbilling.kernel.directory.address.AddressHouse;
import ru.bitel.bgbilling.kernel.directory.address.AddressQuarter;
import ru.bitel.bgbilling.kernel.directory.address.AddressStreet;
import ru.bitel.common.Utils;

public class ActionGetHouseInfo
extends ActionBase {
    @Override
    public void doAction() throws SQLException, BGException {
        int houseid = this.getIntParameter("houseid", 0);
        int pid = this.getIntParameter("pid", -1);
        String flat = this.getParameter("flat", null);
        String room = this.getParameter("room", null);
        String pod = this.getParameter("pod", null);
        String floor = this.getParameter("floor", null);
        boolean isObject = this.getBooleanParameter("isObject", false);
        AddressStruct addressStruct = new AddressStruct();
        Element table = this.createElement(this.rootNode, "table");
        Element data = this.createElement(table, "data");
        AddressDirectoryManager addressDirectoryManager = new AddressDirectoryManager(this.con);
        AddressHouse addressHouse = addressDirectoryManager.getAddressHouse(houseid);
        if (addressHouse != null) {
            AddressArea addressArea = addressDirectoryManager.getAddressArea(addressHouse.getAreaId());
            AddressStreet addressStreet = addressDirectoryManager.getAddressStreet(addressHouse.getStreetId());
            AddressQuarter addressQuarter = addressDirectoryManager.getAddressQuarter(addressHouse.getQuarterId());
            AddressCity addressCity = addressDirectoryManager.getAddressCity(addressStreet.getCityId());
            AddressCountry addressCountry = addressDirectoryManager.getAddressCountry(addressCity.getCountryId());
            Element row = this.createElement(data, "row");
            row.setAttribute("f0", houseid + "");
            row.setAttribute("f1", addressHouse.getPostIndex());
            row.setAttribute("f2", addressCity.getTitle());
            row.setAttribute("f3", addressArea != null ? addressArea.getTitle() : "\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d");
            row.setAttribute("f4", addressQuarter != null ? addressQuarter.getTitle() : "\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d");
            row.setAttribute("f5", addressStreet.getTitle());
            int s = addressHouse.getHouse();
            row.setAttribute("f6", (s > 0 ? s + "" : "") + addressHouse.getFrac());
            row.setAttribute("f7", addressHouse.getAmount() + "");
            row.setAttribute("f9", addressHouse.getComment());
            row.setAttribute("f10", addressStreet.getCityId() + "");
            row.setAttribute("f11", addressHouse.getAreaId() + "");
            row.setAttribute("f12", addressHouse.getQuarterId() + "");
            row.setAttribute("f13", addressHouse.getStreetId() + "");
            addressStruct.setIndex(addressHouse.getPostIndex());
            addressStruct.setCountry(addressCountry != null ? addressCountry.getTitle() : "");
            addressStruct.setCity(addressCity.getTitle());
            addressStruct.setArea(addressArea != null ? addressArea.getTitle() : null);
            addressStruct.setQuarter(addressQuarter != null ? addressQuarter.getTitle() : null);
            addressStruct.setStreet(addressStreet.getTitle());
            addressStruct.setHouse(addressHouse.getHouse() + "");
            addressStruct.setFrac(addressHouse.getFrac());
            if (flat != null && !flat.equals("")) {
                addressStruct.setFlat(String.valueOf(flat));
            }
            if (room != null && !room.equals("")) {
                addressStruct.setRoom(String.valueOf(room));
            }
            if (pod != null && !pod.equals("")) {
                addressStruct.setPod(String.valueOf(pod));
            }
            if (floor != null && !floor.equals("")) {
                addressStruct.setFloor(String.valueOf(floor));
            }
            addressStruct.setComment(addressHouse.getComment());
        }
        String paramString = "address.house";
        List<String> paramList = Utils.toList(this.setup.get(paramString, null));
        AddressManager addressManager = new AddressManager(this.con, this.setup);
        Map<String, String> paramMap = addressManager.getAddressParams("address_house", houseid);
        Element extraParams = this.createElement(this.rootNode, "extraParams");
        for (String str : paramList) {
            if (paramMap.get(str) == null) continue;
            Element param = this.createElement(extraParams, "param");
            param.setAttribute("param_id", str);
            param.setAttribute("param_title", this.setup.get(paramString + "." + str + ".title", null));
            param.setAttribute("param_value", paramMap.get(str));
        }
        if (pid > 0) {
            this.getFormatAddressTable(addressStruct, pid, null, isObject);
        }
    }
}

