/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server;

import bitel.billing.server.admin.errorlog.AlarmSender;
import bitel.billing.server.admin.errorlog.bean.AlarmErrorMessage;
import bitel.billing.server.tariff.TariffTreesCache;
import bitel.billing.server.task.TEProcessManager;
import bitel.billing.server.task.TESocketManager;
import bitel.billing.server.task.TaskRunProcessor;
import bitel.billing.server.task.bean.RunTaskDataManager;
import java.sql.Connection;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.admin.server.errorlog.DatabaseCheckTask;
import ru.bitel.bgbilling.kernel.event.EventListener;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.events.system.ScheduledTaskReloadEvent;
import ru.bitel.bgbilling.kernel.event.processors.CommonKernelEventProcessor;
import ru.bitel.bgbilling.kernel.event.processors.ScriptEventProcessor;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginManagerServer;
import ru.bitel.bgbilling.kernel.task.server.bean.TaskData;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.bgbilling.server.util.UserMap;
import ru.bitel.common.Utils;
import ru.bitel.common.logging.LoggingPrintStream;
import ru.bitel.common.logging.NestedContext;

public class TaskExecuter
extends Thread {
    private static final Logger log = Logger.getLogger(TaskExecuter.class);
    public static int STATUS_WORK = 0;
    public static int STATUS_SUSPENDED = 1;
    public static int STATUS_FINISHED = 2;
    private Calendar last_start_date = null;
    private final Setup setup;
    private Map<Integer, TaskData> tasks = new HashMap<Integer, TaskData>();
    private int status = STATUS_WORK;
    private Date startTime = new Date();
    private static final String THREAD_COUNT_KEY = "scheduler.periodic.thread.count";
    private ThreadPoolExecutor pool;
    private TaskRunProcessor proccesor = null;

    public TaskExecuter(int port) throws BGException {
        LoggingPrintStream.assignToOutput();
        this.setup = new Setup("data.data");
        Setup.setSetup(this.setup);
        System.setProperty("java.protocol.handler.pkgs", "bitel.billing.common.protocol");
        new TEProcessManager(this, port);
        if (log.isInfoEnabled()) {
            log.info((Object)"Start TaskExecuter");
        }
        this.init();
        new ScriptEventProcessor(this.setup).start();
        new CommonKernelEventProcessor(this.setup);
        this.proccesor = new TaskRunProcessor(this.setup);
        this.clearCurrentPeriodic();
        AlarmSender.initSender(this.setup);
        AlarmSender.registerAlarmTask(new DatabaseCheckTask());
        try {
            Utils.checkJava();
        }
        catch (BGException e) {
            AlarmSender.sendAlarm(new AlarmErrorMessage("bad.java", "\u041f\u043b\u0430\u043d\u0438\u0440\u043e\u0432\u0449\u0438\u043a: \u043d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u0430\u044f Java", e.getMessage()), System.currentTimeMillis());
        }
        int schedulerThreadCount = this.setup.getInt(THREAD_COUNT_KEY, 5);
        this.pool = new ThreadPoolExecutor(schedulerThreadCount, schedulerThreadCount, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
        if (this.setup.getInt("scheduler.only.run", 0) == 0) {
            this.start();
        }
        try {
            EventProcessor.getInstance().addListener(new EventListener<ScheduledTaskReloadEvent>(){

                @Override
                public void notify(ScheduledTaskReloadEvent e, EventListenerContext ctx) {
                    TaskExecuter.this.reloadTasks();
                }
            }, ScheduledTaskReloadEvent.class);
        }
        catch (BGException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void init() {
        Connection con = this.setup.getDBConnectionFromPool();
        try {
            UserMap.initUserMap(con);
            BGPluginManagerServer.getManager().init(con, "scheduler");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            ServerUtils.closeConnection(con);
        }
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    if (this.status == STATUS_FINISHED) {
                        this.finishTE();
                    }
                    if (this.status == STATUS_WORK) {
                        GregorianCalendar now = new GregorianCalendar();
                        if (this.last_start_date == null || now.get(6) != this.last_start_date.get(6)) {
                            this.reloadTasks();
                        }
                        if (this.last_start_date == null || now.get(12) != this.last_start_date.get(12)) {
                            log.debug((Object)"Looking tasks");
                            for (Integer key : this.tasks.keySet()) {
                                try {
                                    TaskData td = this.tasks.get(key);
                                    if (!td.canWork(now)) continue;
                                    if (this.pool.getActiveCount() == this.pool.getMaximumPoolSize()) {
                                        String alarmKey = "scheduler.periodic.task.run.skip";
                                        long alarmTime = System.currentTimeMillis();
                                        if (!AlarmSender.needAlarmSend(alarmKey, alarmTime, 30000L)) continue;
                                        String message = "\u0412 \u0440\u0430\u043c\u043a\u0430\u0445 \u043e\u0442\u0432\u0435\u0434\u0435\u043d\u043d\u043e\u0433\u043e \u043f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u043e\u0439 scheduler.periodic.thread.count \u043c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0447\u0438\u0441\u043b\u0430 \u043e\u0434\u043d\u043e\u0432\u0440\u0435\u043c\u0435\u043d\u043d\u043e \u0437\u0430\u043f\u0443\u0449\u0435\u043d\u043d\u044b\u0445 \u043f\u043e\u0442\u043e\u043a\u043e\u0432 (" + this.pool.getMaximumPoolSize() + ") \u043f\u043b\u0430\u043d\u0438\u0440\u043e\u0432\u0449\u0438\u043a \u043d\u0435 \u0441\u043c\u043e\u0433 \u0437\u0430\u043f\u0443\u0441\u0442\u0438\u0442\u044c \u043f\u0435\u0440\u0438\u043e\u0434\u0438\u0447\u0435\u0441\u043a\u0443\u044e \u0437\u0430\u0434\u0430\u0447\u0443 \u0441 \u043a\u043e\u0434\u043e\u043c #" + td.getId() + ".\n\u041d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0432\u044b\u044f\u0441\u043d\u0438\u0442\u044c \u043f\u0440\u0438\u0447\u0438\u043d\u0443 \u043c\u0435\u0434\u043b\u0435\u043d\u043d\u043e\u0433\u043e \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0438\u044f \u043f\u0435\u0440\u0438\u043e\u0434\u0438\u0447\u0435\u0441\u043a\u0438\u0445 \u0437\u0430\u0434\u0430\u0447, \u0437\u0430\u043f\u0443\u0449\u0435\u043d\u043d\u044b\u0445 \u0440\u0430\u043d\u0435\u0435.";
                                        log.warn((Object)("task #" + td.getId() + " was skipped! for details see alarms."));
                                        AlarmSender.sendAlarm(new AlarmErrorMessage(alarmKey, "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0437\u0430\u043f\u0443\u0441\u0442\u0438\u0442\u044c \u043f\u0435\u0440\u0438\u043e\u0434\u0438\u0447\u0435\u0441\u043a\u0443\u044e \u0437\u0430\u0434\u0430\u0447\u0443", message), alarmTime);
                                        continue;
                                    }
                                    td.initTask(now, this.setup);
                                    log.info((Object)("Starting periodic task #" + td.getId() + ": " + td.getClassName()));
                                    this.pool.execute(td.getTask());
                                }
                                catch (Exception e) {
                                    log.error((Object)e.getMessage(), (Throwable)e);
                                }
                            }
                            this.last_start_date = now;
                        }
                    }
                    TaskExecuter.sleep(5000L);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reloadTasks() {
        log.info((Object)"TaskExecuter => reloadTasks()");
        Connection con = this.setup.getDBConnectionFromPool();
        try {
            this.tasks.clear();
            for (TaskData td : new RunTaskDataManager(con).getTaskDataForReload()) {
                Integer task_id = td.getId();
                this.tasks.put(task_id, td);
                log.info((Object)("Task #" + task_id + ": " + td.getClassName()));
            }
        }
        catch (Exception ex) {
            log.error((Object)"error reload tasks", (Throwable)ex);
        }
        finally {
            ServerUtils.closeConnection(con);
        }
    }

    private void clearCurrentPeriodic() {
        Connection con = this.setup.getDBConnectionFromPool();
        try {
            new RunTaskDataManager(con).clearCurrentPeriodic();
        }
        catch (Exception ex) {
            log.error((Object)"error clear current periodic", (Throwable)ex);
        }
        finally {
            ServerUtils.closeConnection(con);
        }
    }

    private void finishTE() {
        log.info((Object)"Finishing TaskExecuter");
        System.exit(0);
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int value) {
        this.status = value;
        log.info((Object)("TaskExecuter => setStatus() : " + this.status));
    }

    public String getStatusString() {
        StringBuffer result = new StringBuffer(50);
        result.append("TaskExecuter");
        result.append(this.status == STATUS_WORK ? " working" : (this.status == STATUS_SUSPENDED ? " suspend" : " undef"));
        result.append("\n");
        result.append(ServerUtils.uptimeStatus(this.startTime)).append("\n");
        result.append(Utils.memoryStatus()).append("\n");
        result.append("Trees in cache: " + TariffTreesCache.getCache().getCacheStatus()).append("\n");
        result.append("Periodic tasks executed: " + this.pool.getCompletedTaskCount() + "; ");
        result.append("active: " + this.pool.getActiveCount()).append("\n");
        if (this.proccesor != null) {
            result.append(this.proccesor.getStatusString());
        }
        result.append(this.setup.getPoolStatus()).append("\n");
        return result.toString();
    }

    public String getPoolStackTrace() {
        return this.setup.getPoolStackTrace();
    }

    public static void setDebug(boolean value) {
        log.setLevel(value ? Level.DEBUG : Level.INFO);
    }

    public static void main(String[] args) {
        NestedContext.push("scheduler");
        new TESocketManager(args);
    }

    public static void exit() {
        String[] params = new String[]{"-estop"};
        TaskExecuter.main(params);
    }
}

