/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.common;

import java.util.StringTokenizer;
import ru.bitel.common.Utils;

public class MaskUtils {
    private int _startValue = 0;
    private int _maskLength = 1;

    public MaskUtils(int startValue, int maskLength) {
        this._startValue = startValue;
        this._maskLength = maskLength;
    }

    public long stringToLong(String text) {
        long result = 0L;
        StringTokenizer st = new StringTokenizer(text, ",");
        while (st.hasMoreTokens()) {
            long add;
            int i;
            String token = st.nextToken().trim();
            if (token.startsWith("*")) {
                int mode = 1;
                int delim = 1;
                StringTokenizer st1 = new StringTokenizer(token, "/");
                if (st1.countTokens() == 2) {
                    mode = 1;
                    st1.nextToken();
                    delim = Utils.parseInt(st1.nextToken(), 1);
                }
                if ((st1 = new StringTokenizer(token, "\\")).countTokens() == 2) {
                    mode = 2;
                    st1.nextToken();
                    delim = Utils.parseInt(st1.nextToken(), 1);
                }
                if (delim == 0) {
                    delim = 1;
                }
                for (i = 0; i < this._maskLength; ++i) {
                    if ((mode != 1 || (i + this._startValue) % delim != 0) && (mode != 2 || (i + this._startValue) % delim == 0)) continue;
                    add = 1L << i;
                    result |= add;
                }
                continue;
            }
            if (!Character.isDigit(token.charAt(0))) continue;
            StringTokenizer periodSt = new StringTokenizer(token, "-");
            int start = 0;
            int stop = 0;
            try {
                stop = start = Integer.parseInt(periodSt.nextToken().trim());
                if (periodSt.hasMoreTokens()) {
                    stop = Integer.parseInt(periodSt.nextToken().trim());
                }
            }
            catch (Exception i2) {
                // empty catch block
            }
            for (i = start; i <= stop && i <= this._maskLength + this._startValue - 1; ++i) {
                add = 1L << i - this._startValue;
                result |= add;
            }
        }
        return result;
    }

    public String longToString(long value) {
        StringBuffer result = new StringBuffer();
        int start = -2;
        int stop = -2;
        for (int i = 0; i < this._maskLength; ++i) {
            long andMask = 1L << i;
            if ((value & andMask) <= 0L) continue;
            int paramValue = this._startValue + i;
            if (stop == paramValue - 1) {
                stop = paramValue;
                continue;
            }
            this.addInterval(start, stop, result, false);
            start = paramValue;
            stop = paramValue;
        }
        this.addInterval(start, stop, result, true);
        return result.toString();
    }

    private void addInterval(int start, int stop, StringBuffer sb, boolean last) {
        if (start >= 0) {
            sb.append(String.valueOf(start));
            if (stop > 0 && stop > start) {
                sb.append(" - ");
                sb.append(String.valueOf(stop));
            }
            if (!last) {
                sb.append(", ");
            }
        }
    }
}

