/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import java.lang.reflect.InvocationTargetException;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.TimeZone;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.util.DurationNumberFormat;
import net.sf.jasperreports.engine.util.FormatFactory;
import net.sf.jasperreports.engine.util.JRClassLoader;

public class DefaultFormatFactory
implements FormatFactory {
    public static final String EXCEPTION_MESSAGE_KEY_FACTORY_INSTANCE_ERROR = "util.format.factory.instance.error";
    public static final String EXCEPTION_MESSAGE_KEY_FACTORY_LOADING_ERROR = "util.format.factory.loading.error";
    public static final String STANDARD_DATE_FORMAT_DEFAULT = "default";
    public static final String STANDARD_DATE_FORMAT_SHORT = "short";
    public static final String STANDARD_DATE_FORMAT_MEDIUM = "medium";
    public static final String STANDARD_DATE_FORMAT_LONG = "long";
    public static final String STANDARD_DATE_FORMAT_FULL = "full";
    public static final String STANDARD_DATE_FORMAT_HIDE = "hide";
    public static final String STANDARD_DATE_FORMAT_SEPARATOR = ",";
    public static final String STANDARD_NUMBER_FORMAT_DURATION = "[h]:mm:ss";

    @Override
    public DateFormat createDateFormat(String pattern, Locale locale, TimeZone tz) {
        DateFormat format;
        int sepIdx;
        String dateTok;
        int[] dateStyle = null;
        int[] timeStyle = null;
        if (pattern != null && pattern.trim().length() > 0 && (dateStyle = DefaultFormatFactory.getDateStyle(dateTok = (sepIdx = pattern.indexOf(STANDARD_DATE_FORMAT_SEPARATOR)) < 0 ? pattern : pattern.substring(0, sepIdx))) != null) {
            if (sepIdx >= 0) {
                String timeTok = pattern.substring(sepIdx + STANDARD_DATE_FORMAT_SEPARATOR.length());
                timeStyle = DefaultFormatFactory.getDateStyle(timeTok);
            } else {
                timeStyle = dateStyle;
            }
        }
        if (dateStyle != null && timeStyle != null) {
            format = DefaultFormatFactory.getDateFormat(dateStyle, timeStyle, locale);
        } else {
            format = locale == null ? DateFormat.getDateTimeInstance(3, 3) : DateFormat.getDateTimeInstance(3, 3, locale);
            if (pattern != null && pattern.trim().length() > 0 && format instanceof SimpleDateFormat) {
                ((SimpleDateFormat)format).applyPattern(pattern);
            }
        }
        if (tz != null) {
            format.setTimeZone(tz);
        }
        return format;
    }

    protected static int[] getDateStyle(String pattern) {
        if (pattern.equalsIgnoreCase(STANDARD_DATE_FORMAT_DEFAULT)) {
            return new int[]{2};
        }
        if (pattern.equalsIgnoreCase(STANDARD_DATE_FORMAT_SHORT)) {
            return new int[]{3};
        }
        if (pattern.equalsIgnoreCase(STANDARD_DATE_FORMAT_MEDIUM)) {
            return new int[]{2};
        }
        if (pattern.equalsIgnoreCase(STANDARD_DATE_FORMAT_LONG)) {
            return new int[]{1};
        }
        if (pattern.equalsIgnoreCase(STANDARD_DATE_FORMAT_FULL)) {
            return new int[]{0};
        }
        if (pattern.equalsIgnoreCase(STANDARD_DATE_FORMAT_HIDE)) {
            return new int[0];
        }
        return null;
    }

    protected static DateFormat getDateFormat(int[] dateStyle, int[] timeStyle, Locale locale) {
        if (dateStyle.length == 0) {
            if (timeStyle.length == 0) {
                return new SimpleDateFormat("");
            }
            return locale == null ? DateFormat.getTimeInstance(timeStyle[0]) : DateFormat.getTimeInstance(timeStyle[0], locale);
        }
        if (timeStyle.length == 0) {
            return locale == null ? DateFormat.getDateInstance(dateStyle[0]) : DateFormat.getDateInstance(dateStyle[0], locale);
        }
        return locale == null ? DateFormat.getDateTimeInstance(dateStyle[0], timeStyle[0]) : DateFormat.getDateTimeInstance(dateStyle[0], timeStyle[0], locale);
    }

    @Override
    public NumberFormat createNumberFormat(String pattern, Locale locale) {
        NumberFormat format = null;
        if (pattern != null && pattern.trim().length() > 0) {
            if (STANDARD_NUMBER_FORMAT_DURATION.equals(pattern)) {
                format = new DurationNumberFormat();
            } else {
                format = locale == null ? NumberFormat.getNumberInstance() : NumberFormat.getNumberInstance(locale);
                if (format instanceof DecimalFormat) {
                    ((DecimalFormat)format).applyPattern(pattern);
                }
            }
        }
        return format;
    }

    public static FormatFactory createFormatFactory(String formatFactoryClassName) {
        FormatFactory formatFactory = null;
        if (formatFactoryClassName != null) {
            try {
                Class<?> formatFactoryClass = JRClassLoader.loadClassForName(formatFactoryClassName);
                formatFactory = (FormatFactory)formatFactoryClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ClassNotFoundException e) {
                throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_FACTORY_LOADING_ERROR, new Object[]{formatFactoryClassName}, e);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_FACTORY_INSTANCE_ERROR, new Object[]{formatFactoryClassName}, e);
            }
        } else {
            formatFactory = new DefaultFormatFactory();
        }
        return formatFactory;
    }
}

