/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.analytics.dataset;

import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.analytics.dataset.BaseDataLevelBucket;
import net.sf.jasperreports.engine.analytics.dataset.BucketOrder;
import net.sf.jasperreports.engine.analytics.dataset.DataLevelBucketProperty;
import net.sf.jasperreports.engine.design.events.JRChangeEventsSupport;
import net.sf.jasperreports.engine.design.events.JRPropertyChangeSupport;
import net.sf.jasperreports.engine.type.SortOrderEnum;

public class DesignDataLevelBucket
extends BaseDataLevelBucket
implements JRChangeEventsSupport {
    private static final long serialVersionUID = 10200L;
    public static final String PROPERTY_COMPARATOR_EXPRESSION = "comparatorExpression";
    public static final String PROPERTY_EXPRESSION = "expression";
    public static final String PROPERTY_LABEL_EXPRESSION = "labelExpression";
    public static final String PROPERTY_ORDER = "order";
    public static final String PROPERTY_VALUE_CLASS = "valueClassName";
    public static final String PROPERTY_BUCKET_PROPERTIES = "bucketProperties";
    private transient JRPropertyChangeSupport eventSupport;

    public void setComparatorExpression(JRExpression comparatorExpression) {
        JRExpression old = this.comparatorExpression;
        this.comparatorExpression = comparatorExpression;
        this.getEventSupport().firePropertyChange(PROPERTY_COMPARATOR_EXPRESSION, old, this.comparatorExpression);
    }

    public void setExpression(JRExpression expression) {
        JRExpression old = this.expression;
        this.expression = expression;
        this.getEventSupport().firePropertyChange(PROPERTY_EXPRESSION, old, this.expression);
    }

    public void setLabelExpression(JRExpression expression) {
        JRExpression old = this.labelExpression;
        this.labelExpression = expression;
        this.getEventSupport().firePropertyChange(PROPERTY_LABEL_EXPRESSION, old, this.labelExpression);
    }

    @Deprecated
    public void setOrder(SortOrderEnum orderValue) {
        BucketOrder order = BucketOrder.fromSortOrderEnum(orderValue);
        this.setOrder(order);
    }

    public void setOrder(BucketOrder order) {
        BucketOrder old = this.order;
        this.order = order;
        this.getEventSupport().firePropertyChange(PROPERTY_ORDER, old, this.order);
    }

    public void setValueClassName(String valueClassName) {
        String old = this.valueClassName;
        this.valueClassName = valueClassName;
        this.valueClass = null;
        this.valueClassRealName = null;
        this.getEventSupport().firePropertyChange(PROPERTY_VALUE_CLASS, old, this.valueClassName);
    }

    public void addBucketProperty(DataLevelBucketProperty property) {
        this.bucketProperties.add(property);
        this.getEventSupport().fireCollectionElementAddedEvent(PROPERTY_BUCKET_PROPERTIES, property, this.bucketProperties.size() - 1);
    }

    public void removeBucketProperty(DataLevelBucketProperty property) {
        int idx = this.bucketProperties.indexOf(property);
        if (idx >= 0) {
            this.bucketProperties.remove(idx);
            this.getEventSupport().fireCollectionElementRemovedEvent(PROPERTY_BUCKET_PROPERTIES, this.bucketProperties, idx);
        }
    }

    @Override
    public Object clone() {
        DesignDataLevelBucket clone = (DesignDataLevelBucket)super.clone();
        clone.eventSupport = null;
        return clone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JRPropertyChangeSupport getEventSupport() {
        DesignDataLevelBucket designDataLevelBucket = this;
        synchronized (designDataLevelBucket) {
            if (this.eventSupport == null) {
                this.eventSupport = new JRPropertyChangeSupport(this);
            }
        }
        return this.eventSupport;
    }
}

