/*
 * Decompiled with CFR 0.152.
 */
package uk.co.westhawk.snmp.stack;

import uk.co.westhawk.snmp.stack.AsnObject;
import uk.co.westhawk.snmp.stack.Pdu;

class Transmitter
implements Runnable {
    private static final String version_id = "@(#)$Id: Transmitter.java,v 3.15 2007/02/05 15:01:20 birgita Exp $ Copyright Westhawk Ltd";
    Pdu pdu = null;
    Thread me;
    String myName;

    Transmitter(String name) {
        this.me = new Thread((Runnable)this, name);
        this.me.setPriority(1);
        if (AsnObject.debug > 12) {
            System.out.println("Transmitter(): Made thread " + name);
        }
        this.myName = name;
        this.me.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (this.me != null) {
            this.sit();
            Transmitter transmitter = this;
            synchronized (transmitter) {
                if (this.pdu != null) {
                    this.pdu.transmit();
                    this.pdu = null;
                }
            }
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(this.getClass().getName());
        buffer.append("[");
        buffer.append("name=").append(this.myName);
        buffer.append("]");
        return buffer.toString();
    }

    synchronized void setPdu(Pdu p) {
        this.pdu = p;
    }

    synchronized void sit() {
        while (this.me != null && this.pdu == null) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    synchronized void stand() {
        this.notifyAll();
    }

    void interruptMe() {
        if (this.me != null) {
            this.me.interrupt();
        }
    }

    void destroy() {
        this.me = null;
        this.pdu = null;
        this.stand();
    }
}

