/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio.tcp;

import com.hazelcast.internal.networking.ReadHandler;
import com.hazelcast.internal.networking.SocketReader;
import com.hazelcast.internal.util.counters.Counter;
import com.hazelcast.nio.Packet;
import com.hazelcast.nio.tcp.TcpIpConnection;
import com.hazelcast.spi.impl.packetdispatcher.PacketDispatcher;
import java.nio.ByteBuffer;

public class MemberReadHandler
implements ReadHandler {
    protected final TcpIpConnection connection;
    protected Packet packet;
    private final PacketDispatcher packetDispatcher;
    private final Counter normalPacketsRead;
    private final Counter priorityPacketsRead;

    public MemberReadHandler(TcpIpConnection connection, PacketDispatcher packetDispatcher) {
        this.connection = connection;
        this.packetDispatcher = packetDispatcher;
        SocketReader socketReader = connection.getSocketReader();
        this.normalPacketsRead = socketReader.getNormalFramesReadCounter();
        this.priorityPacketsRead = socketReader.getPriorityFramesReadCounter();
    }

    @Override
    public void onRead(ByteBuffer src) throws Exception {
        while (src.hasRemaining()) {
            boolean complete;
            if (this.packet == null) {
                this.packet = new Packet();
            }
            if (!(complete = this.packet.readFrom(src))) break;
            this.handlePacket(this.packet);
            this.packet = null;
        }
    }

    protected void handlePacket(Packet packet) {
        if (packet.isFlagRaised(16)) {
            this.priorityPacketsRead.inc();
        } else {
            this.normalPacketsRead.inc();
        }
        packet.setConn(this.connection);
        this.packetDispatcher.dispatch(packet);
    }
}

