/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.cluster.impl;

import com.hazelcast.config.NetworkConfig;
import com.hazelcast.instance.Node;
import com.hazelcast.internal.cluster.impl.AbstractJoiner;
import com.hazelcast.internal.cluster.impl.JoinRequest;
import com.hazelcast.internal.cluster.impl.SplitBrainJoinMessage;
import com.hazelcast.internal.cluster.impl.SplitBrainMulticastListener;
import com.hazelcast.nio.Address;
import com.hazelcast.spi.properties.GroupProperty;
import com.hazelcast.util.Clock;
import com.hazelcast.util.EmptyStatement;
import com.hazelcast.util.RandomPicker;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class MulticastJoiner
extends AbstractJoiner {
    private static final long JOIN_RETRY_INTERVAL = 1000L;
    private static final int PUBLISH_INTERVAL_MIN = 50;
    private static final int PUBLISH_INTERVAL_MAX = 200;
    private static final int TRY_COUNT_MAX_LAST_DIGITS = 512;
    private static final int TRY_COUNT_MODULO = 10;
    private final AtomicInteger currentTryCount = new AtomicInteger(0);
    private final AtomicInteger maxTryCount;
    private final BlockingDeque<SplitBrainJoinMessage> splitBrainJoinMessages = new LinkedBlockingDeque<SplitBrainJoinMessage>();

    public MulticastJoiner(Node node) {
        super(node);
        this.maxTryCount = new AtomicInteger(this.calculateTryCount());
        node.multicastService.addMulticastListener(new SplitBrainMulticastListener(node, this.splitBrainJoinMessages));
    }

    @Override
    public void doJoin() {
        long joinStartTime = Clock.currentTimeMillis();
        long maxJoinMillis = this.getMaxJoinMillis();
        Address thisAddress = this.node.getThisAddress();
        while (this.shouldRetry() && Clock.currentTimeMillis() - joinStartTime < maxJoinMillis) {
            this.clusterJoinManager.setMasterAddress(null);
            Address masterAddress = this.getTargetAddress();
            if (masterAddress == null) {
                masterAddress = this.findMasterWithMulticast();
            }
            this.clusterJoinManager.setMasterAddress(masterAddress);
            if (masterAddress == null || thisAddress.equals(masterAddress)) {
                this.clusterJoinManager.setAsMaster();
                return;
            }
            this.logger.info("Trying to join to discovered node: " + masterAddress);
            this.joinMaster();
        }
    }

    private void joinMaster() {
        Address master;
        long maxMasterJoinTime = this.getMaxJoinTimeToMasterNode();
        long start = Clock.currentTimeMillis();
        while (this.shouldRetry() && Clock.currentTimeMillis() - start < maxMasterJoinTime && (master = this.node.getMasterAddress()) != null) {
            if (this.logger.isFineEnabled()) {
                this.logger.fine("Joining to master " + master);
            }
            this.clusterJoinManager.sendJoinRequest(master, true);
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                EmptyStatement.ignore(e);
            }
            if (!this.isBlacklisted(master)) continue;
            this.clusterJoinManager.setMasterAddress(null);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void searchForOtherClusters() {
        this.node.multicastService.send(this.node.createSplitBrainJoinMessage());
        try {
            SplitBrainJoinMessage joinInfo;
            while ((joinInfo = this.splitBrainJoinMessages.poll(3L, TimeUnit.SECONDS)) != null) {
                try {
                    SplitBrainJoinMessage response;
                    if (this.node.clusterService.getMember(joinInfo.getAddress()) != null) {
                        if (!this.logger.isFineEnabled()) return;
                        this.logger.fine("Ignoring merge join response, since " + joinInfo.getAddress() + " is already a member.");
                        return;
                    }
                    if (joinInfo.getMemberCount() == 1) {
                        Thread.sleep(2L * this.node.getProperties().getMillis(GroupProperty.WAIT_SECONDS_BEFORE_JOIN));
                    }
                    if (!this.shouldMerge(response = this.sendSplitBrainJoinMessage(joinInfo.getAddress()))) continue;
                    this.logger.warning(this.node.getThisAddress() + " is merging [multicast] to " + joinInfo.getAddress());
                    this.startClusterMerge(joinInfo.getAddress());
                }
                catch (Exception e) {
                    if (this.logger == null) continue;
                    this.logger.warning(e);
                }
            }
            return;
        }
        catch (InterruptedException ignored) {
            EmptyStatement.ignore(ignored);
        }
    }

    @Override
    public String getType() {
        return "multicast";
    }

    void onReceivedJoinRequest(JoinRequest joinRequest) {
        if (joinRequest.getUuid().compareTo(this.node.getThisUuid()) < 0) {
            this.maxTryCount.incrementAndGet();
        }
    }

    private Address findMasterWithMulticast() {
        try {
            if (this.logger.isFineEnabled()) {
                this.logger.fine("Searching for master node. Max tries: " + this.maxTryCount.get());
            }
            JoinRequest joinRequest = this.node.createJoinRequest(false);
            while (this.node.isRunning() && this.currentTryCount.incrementAndGet() <= this.maxTryCount.get()) {
                joinRequest.setTryCount(this.currentTryCount.get());
                this.node.multicastService.send(joinRequest);
                if (this.node.getMasterAddress() == null) {
                    Thread.sleep(this.getPublishInterval());
                    continue;
                }
                Address address = this.node.getMasterAddress();
                return address;
            }
        }
        catch (Exception e) {
            if (this.logger != null) {
                this.logger.warning(e);
            }
        }
        finally {
            this.currentTryCount.set(0);
        }
        return null;
    }

    private int calculateTryCount() {
        int lastDigits;
        NetworkConfig networkConfig = this.config.getNetworkConfig();
        long timeoutMillis = TimeUnit.SECONDS.toMillis(networkConfig.getJoin().getMulticastConfig().getMulticastTimeoutSeconds());
        int avgPublishInterval = 125;
        int tryCount = (int)timeoutMillis / avgPublishInterval;
        String host = this.node.getThisAddress().getHost();
        try {
            lastDigits = Integer.parseInt(host.substring(host.lastIndexOf(46) + 1));
        }
        catch (NumberFormatException e) {
            lastDigits = RandomPicker.getInt(512);
        }
        int portDiff = this.node.getThisAddress().getPort() - networkConfig.getPort();
        return tryCount += (lastDigits + portDiff) % 10;
    }

    private int getPublishInterval() {
        return RandomPicker.getInt(50, 200);
    }
}

