/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import junit.framework.TestCase;
import org.xbill.DNS.Mnemonic;

public class MnemonicTest
extends TestCase {
    private Mnemonic m_mn;

    public MnemonicTest(String name) {
        super(name);
    }

    public void setUp() {
        this.m_mn = new Mnemonic(MnemonicTest.class.getName() + " UPPER", 2);
    }

    public void test_toInteger() {
        Integer i = Mnemonic.toInteger(64);
        MnemonicTest.assertEquals((Object)new Integer(64), (Object)i);
        Integer i2 = Mnemonic.toInteger(64);
        MnemonicTest.assertEquals((Object)i, (Object)i2);
        MnemonicTest.assertNotSame((Object)i, (Object)i2);
        i = Mnemonic.toInteger(-1);
        MnemonicTest.assertEquals((Object)new Integer(-1), (Object)i);
        i2 = Mnemonic.toInteger(-1);
        MnemonicTest.assertEquals((Object)i, (Object)i2);
        MnemonicTest.assertNotSame((Object)i, (Object)i2);
        i = Mnemonic.toInteger(0);
        MnemonicTest.assertEquals((Object)new Integer(0), (Object)i);
        i2 = Mnemonic.toInteger(0);
        MnemonicTest.assertEquals((Object)i, (Object)i2);
        MnemonicTest.assertSame((Object)i, (Object)i2);
        i = Mnemonic.toInteger(63);
        MnemonicTest.assertEquals((Object)new Integer(63), (Object)i);
        i2 = Mnemonic.toInteger(63);
        MnemonicTest.assertEquals((Object)i, (Object)i2);
        MnemonicTest.assertSame((Object)i, (Object)i2);
    }

    public void test_no_maximum() {
        try {
            this.m_mn.check(-1);
            MnemonicTest.fail((String)"IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            this.m_mn.check(0);
        }
        catch (IllegalArgumentException e) {
            MnemonicTest.fail((String)e.getMessage());
        }
        try {
            this.m_mn.check(Integer.MAX_VALUE);
        }
        catch (IllegalArgumentException e) {
            MnemonicTest.fail((String)e.getMessage());
        }
        this.m_mn.setNumericAllowed(true);
        int val = this.m_mn.getValue("-2");
        MnemonicTest.assertEquals((int)-1, (int)val);
        val = this.m_mn.getValue("0");
        MnemonicTest.assertEquals((int)0, (int)val);
        val = this.m_mn.getValue("2147483647");
        MnemonicTest.assertEquals((int)Integer.MAX_VALUE, (int)val);
    }

    public void test_setMaximum() {
        this.m_mn.setMaximum(15);
        try {
            this.m_mn.check(-1);
            MnemonicTest.fail((String)"IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            this.m_mn.check(0);
        }
        catch (IllegalArgumentException e) {
            MnemonicTest.fail((String)e.getMessage());
        }
        try {
            this.m_mn.check(15);
        }
        catch (IllegalArgumentException e) {
            MnemonicTest.fail((String)e.getMessage());
        }
        try {
            this.m_mn.check(16);
            MnemonicTest.fail((String)"IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        this.m_mn.setNumericAllowed(true);
        int val = this.m_mn.getValue("-2");
        MnemonicTest.assertEquals((int)-1, (int)val);
        val = this.m_mn.getValue("0");
        MnemonicTest.assertEquals((int)0, (int)val);
        val = this.m_mn.getValue("15");
        MnemonicTest.assertEquals((int)15, (int)val);
        val = this.m_mn.getValue("16");
        MnemonicTest.assertEquals((int)-1, (int)val);
    }

    public void test_setPrefix() {
        String prefix = "A mixed CASE Prefix".toUpperCase();
        this.m_mn.setPrefix(prefix);
        String out = this.m_mn.getText(10);
        MnemonicTest.assertEquals((String)(prefix + "10"), (String)out);
        int i = this.m_mn.getValue(out);
        MnemonicTest.assertEquals((int)10, (int)i);
    }

    public void test_basic_operation() {
        this.m_mn.add(10, "Ten");
        this.m_mn.add(20, "Twenty");
        this.m_mn.addAlias(20, "Veinte");
        this.m_mn.add(30, "Thirty");
        String text = this.m_mn.getText(10);
        MnemonicTest.assertEquals((String)"TEN", (String)text);
        text = this.m_mn.getText(20);
        MnemonicTest.assertEquals((String)"TWENTY", (String)text);
        text = this.m_mn.getText(30);
        MnemonicTest.assertEquals((String)"THIRTY", (String)text);
        text = this.m_mn.getText(40);
        MnemonicTest.assertEquals((String)"40", (String)text);
        int value = this.m_mn.getValue("tEn");
        MnemonicTest.assertEquals((int)10, (int)value);
        value = this.m_mn.getValue("twenty");
        MnemonicTest.assertEquals((int)20, (int)value);
        value = this.m_mn.getValue("VeiNTe");
        MnemonicTest.assertEquals((int)20, (int)value);
        value = this.m_mn.getValue("THIRTY");
        MnemonicTest.assertEquals((int)30, (int)value);
    }

    public void test_basic_operation_lower() {
        this.m_mn = new Mnemonic(MnemonicTest.class.getName() + " LOWER", 3);
        this.m_mn.add(10, "Ten");
        this.m_mn.add(20, "Twenty");
        this.m_mn.addAlias(20, "Veinte");
        this.m_mn.add(30, "Thirty");
        String text = this.m_mn.getText(10);
        MnemonicTest.assertEquals((String)"ten", (String)text);
        text = this.m_mn.getText(20);
        MnemonicTest.assertEquals((String)"twenty", (String)text);
        text = this.m_mn.getText(30);
        MnemonicTest.assertEquals((String)"thirty", (String)text);
        text = this.m_mn.getText(40);
        MnemonicTest.assertEquals((String)"40", (String)text);
        int value = this.m_mn.getValue("tEn");
        MnemonicTest.assertEquals((int)10, (int)value);
        value = this.m_mn.getValue("twenty");
        MnemonicTest.assertEquals((int)20, (int)value);
        value = this.m_mn.getValue("VeiNTe");
        MnemonicTest.assertEquals((int)20, (int)value);
        value = this.m_mn.getValue("THIRTY");
        MnemonicTest.assertEquals((int)30, (int)value);
    }

    public void test_basic_operation_sensitive() {
        this.m_mn = new Mnemonic(MnemonicTest.class.getName() + " SENSITIVE", 1);
        this.m_mn.add(10, "Ten");
        this.m_mn.add(20, "Twenty");
        this.m_mn.addAlias(20, "Veinte");
        this.m_mn.add(30, "Thirty");
        String text = this.m_mn.getText(10);
        MnemonicTest.assertEquals((String)"Ten", (String)text);
        text = this.m_mn.getText(20);
        MnemonicTest.assertEquals((String)"Twenty", (String)text);
        text = this.m_mn.getText(30);
        MnemonicTest.assertEquals((String)"Thirty", (String)text);
        text = this.m_mn.getText(40);
        MnemonicTest.assertEquals((String)"40", (String)text);
        int value = this.m_mn.getValue("Ten");
        MnemonicTest.assertEquals((int)10, (int)value);
        value = this.m_mn.getValue("twenty");
        MnemonicTest.assertEquals((int)-1, (int)value);
        value = this.m_mn.getValue("Twenty");
        MnemonicTest.assertEquals((int)20, (int)value);
        value = this.m_mn.getValue("VEINTE");
        MnemonicTest.assertEquals((int)-1, (int)value);
        value = this.m_mn.getValue("Veinte");
        MnemonicTest.assertEquals((int)20, (int)value);
        value = this.m_mn.getValue("Thirty");
        MnemonicTest.assertEquals((int)30, (int)value);
    }

    public void test_invalid_numeric() {
        this.m_mn.setNumericAllowed(true);
        int value = this.m_mn.getValue("Not-A-Number");
        MnemonicTest.assertEquals((int)-1, (int)value);
    }

    public void test_addAll() {
        this.m_mn.add(10, "Ten");
        this.m_mn.add(20, "Twenty");
        Mnemonic mn2 = new Mnemonic("second test Mnemonic", 2);
        mn2.add(20, "Twenty");
        mn2.addAlias(20, "Veinte");
        mn2.add(30, "Thirty");
        this.m_mn.addAll(mn2);
        String text = this.m_mn.getText(10);
        MnemonicTest.assertEquals((String)"TEN", (String)text);
        text = this.m_mn.getText(20);
        MnemonicTest.assertEquals((String)"TWENTY", (String)text);
        text = this.m_mn.getText(30);
        MnemonicTest.assertEquals((String)"THIRTY", (String)text);
        text = this.m_mn.getText(40);
        MnemonicTest.assertEquals((String)"40", (String)text);
        int value = this.m_mn.getValue("tEn");
        MnemonicTest.assertEquals((int)10, (int)value);
        value = this.m_mn.getValue("twenty");
        MnemonicTest.assertEquals((int)20, (int)value);
        value = this.m_mn.getValue("VeiNTe");
        MnemonicTest.assertEquals((int)20, (int)value);
        value = this.m_mn.getValue("THIRTY");
        MnemonicTest.assertEquals((int)30, (int)value);
    }
}

